/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.entity.animation.MobAnimation;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public abstract class AnimatedPathfinderMob
extends PathfinderMob {
    private static final EntityDataAccessor<Integer> CURRENT_ACTION = SynchedEntityData.defineId(AnimatedPathfinderMob.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final AttributeModifier STATIONARY_MOB_MODIFIER = new AttributeModifier(Minestuck.id("stationary_animation_modifier"), -1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL);
    private int remainingAnimationTicks;

    protected AnimatedPathfinderMob(EntityType<? extends AnimatedPathfinderMob> type, Level level) {
        super(type, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CURRENT_ACTION, (Object)MobAnimation.IDLE_ACTION.ordinal());
    }

    public void tick() {
        super.tick();
        if (this.remainingAnimationTicks > 0) {
            --this.remainingAnimationTicks;
            if (this.remainingAnimationTicks == 0) {
                this.endCurrentAction();
            }
        }
    }

    public void endCurrentAction() {
        this.setCurrentAnimation(MobAnimation.DEFAULT_IDLE_ANIMATION);
    }

    protected MobAnimation.Action getCurrentAction() {
        return MobAnimation.Action.values()[(Integer)this.entityData.get(CURRENT_ACTION)];
    }

    public void freezeMob() {
        AttributeInstance instance = this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
        if (instance != null && !instance.hasModifier(STATIONARY_MOB_MODIFIER.id())) {
            instance.addTransientModifier(STATIONARY_MOB_MODIFIER);
        }
    }

    public void unfreezeMob() {
        AttributeInstance instance = this.getAttributes().getInstance(Attributes.MOVEMENT_SPEED);
        if (instance != null) {
            instance.removeModifier(STATIONARY_MOB_MODIFIER);
        }
    }

    public void setCurrentAnimation(MobAnimation animation) {
        this.setCurrentAnimation(animation, 1.0);
    }

    public void setCurrentAnimation(MobAnimation animation, double animationSpeed) {
        if (animation.freezeMovement()) {
            this.freezeMob();
        } else {
            this.unfreezeMob();
        }
        this.entityData.set(CURRENT_ACTION, (Object)animation.action().ordinal());
        this.remainingAnimationTicks = (int)Math.round((double)animation.animationLength() / animationSpeed);
    }
}

