/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity;

import com.mraof.minestuck.entity.AnimatedPathfinderMob;
import com.mraof.minestuck.entity.animation.ActionCooldown;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public abstract class AttackingAnimatedEntity
extends AnimatedPathfinderMob
implements PhasedMobAnimation.Phases.Holder,
ActionCooldown {
    private static final EntityDataAccessor<Integer> CURRENT_ACTION = SynchedEntityData.defineId(AttackingAnimatedEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int specialActionCooldown = 0;

    protected AttackingAnimatedEntity(EntityType<? extends AttackingAnimatedEntity> type, Level level) {
        super(type, level);
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CURRENT_ACTION, (Object)MobAnimation.IDLE_ACTION.ordinal());
    }

    @Override
    public PhasedMobAnimation.Phases getPhase() {
        return PhasedMobAnimation.Phases.values()[(Integer)this.entityData.get(CURRENT_ACTION)];
    }

    @Override
    public void setAnimationPhase(PhasedMobAnimation.Phases phase, MobAnimation.Action animation) {
        this.entityData.set(CURRENT_ACTION, (Object)phase.ordinal());
        if (phase == PhasedMobAnimation.Phases.ANTICIPATION) {
            this.anticipationPhaseStart(animation);
        } else if (phase == PhasedMobAnimation.Phases.INITIATION) {
            this.initiationPhaseStart(animation);
        } else if (phase == PhasedMobAnimation.Phases.CONTACT) {
            this.contactPhaseStart(animation);
        } else if (phase == PhasedMobAnimation.Phases.RECOVERY) {
            this.recoveryPhaseStart(animation);
        } else if (phase == PhasedMobAnimation.Phases.NEUTRAL) {
            this.neutralPhaseStart(animation);
        }
    }

    public void anticipationPhaseStart(MobAnimation.Action animation) {
    }

    public void initiationPhaseStart(MobAnimation.Action animation) {
    }

    public void contactPhaseStart(MobAnimation.Action animation) {
    }

    public void recoveryPhaseStart(MobAnimation.Action animation) {
    }

    public void neutralPhaseStart(MobAnimation.Action animation) {
    }

    @Override
    public void tick() {
        super.tick();
        if (this.specialActionCooldown > 0) {
            --this.specialActionCooldown;
        }
    }

    @Override
    public int getCooldown() {
        return this.specialActionCooldown;
    }

    @Override
    public void setCooldown(int amountTicks) {
        this.specialActionCooldown = amountTicks;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("SpecialActionCooldown", this.specialActionCooldown);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.specialActionCooldown = compound.getInt("SpecialActionCooldown");
    }
}

