/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity;

import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.entity.MSEntityTypes;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DecoyEntity
extends Mob
implements IEntityWithComplexSpawn {
    private static final Logger LOGGER = LogManager.getLogger();
    public GameType gameType;
    public String username;
    private UUID playerId;
    private FoodData foodStats;
    private CompoundTag foodStatsNBT;
    public CompoundTag capabilities = new CompoundTag();
    public boolean markedForDespawn;
    private double originX;
    private double originY;
    private double originZ;
    private DecoyPlayer player;
    public Inventory inventory;

    public DecoyEntity(EntityType<? extends DecoyEntity> type, Level level) {
        super(type, level);
        this.inventory = new Inventory(null);
        if (!level.isClientSide) {
            this.markedForDespawn = true;
        }
    }

    public DecoyEntity(ServerLevel level, ServerPlayer player) {
        super(MSEntityTypes.PLAYER_DECOY.get(), (Level)level);
        this.setBoundingBox(player.getBoundingBox());
        this.player = new DecoyPlayer(level, this, player);
        for (String key : player.getPersistentData().getAllKeys()) {
            this.player.getPersistentData().put(key, player.getPersistentData().get(key).copy());
        }
        this.setPos(player.getX(), player.getY(), player.getZ());
        this.originX = this.getX();
        this.originY = this.getY();
        this.originZ = this.getZ();
        this.setXRot(player.getXRot());
        this.setYRot(player.getYRot());
        this.yHeadRot = player.yHeadRot;
        this.yBodyRot = player.yBodyRot;
        this.gameType = player.gameMode.getGameModeForPlayer();
        this.initInventory(player);
        this.getAttribute(Attributes.MAX_HEALTH).replaceFrom(player.getAttribute(Attributes.MAX_HEALTH));
        this.player.getAttribute(Attributes.MAX_HEALTH).replaceFrom(player.getAttribute(Attributes.MAX_HEALTH));
        this.setHealth(player.getHealth());
        this.username = player.getGameProfile().getName();
        this.playerId = player.getUUID();
        this.setNoGravity(player.getAbilities().flying);
        player.getAbilities().addSaveData(this.capabilities);
        this.foodStatsNBT = new CompoundTag();
        player.getFoodData().addAdditionalSaveData(this.foodStatsNBT);
        this.initFoodStats(player);
    }

    protected EntityDimensions getDefaultDimensions(Pose pPose) {
        return EntityType.PLAYER.getDimensions();
    }

    private void initInventory(ServerPlayer player) {
        this.inventory = this.player.getInventory();
        this.inventory.replaceWith(player.getInventory());
    }

    private void initFoodStats(ServerPlayer sourcePlayer) {
        try {
            try {
                this.foodStats = new FoodData();
            }
            catch (NoSuchMethodError e) {
                LOGGER.info("Custom constructor detected for FoodStats. Trying with player as parameter...");
                try {
                    this.foodStats = (FoodData)FoodData.class.getConstructor(Player.class).newInstance(new Object[]{this.player});
                }
                catch (NoSuchMethodException ex) {
                    throw new NoSuchMethodException("Found no known constructor for net.minecraft.util.FoodStats.");
                }
            }
            this.foodStats.readAdditionalSaveData(this.foodStatsNBT);
        }
        catch (Exception e) {
            this.foodStats = null;
            LOGGER.error("Couldn't initiate food stats for player decoy. Proceeding to not simulate food stats.", (Throwable)e);
            sourcePlayer.sendSystemMessage((Component)Component.literal((String)"An issue came up while creating the decoy. More info in the server logs."));
        }
    }

    public CompoundTag getFoodStatsNBT() {
        if (this.foodStats != null) {
            CompoundTag nbt = new CompoundTag();
            this.foodStats.addAdditionalSaveData(nbt);
            return nbt;
        }
        return this.foodStatsNBT;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.username, 16);
        buffer.writeUUID(this.playerId);
        buffer.writeFloat(this.yHeadRot);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.username = additionalData.readUtf(16);
        this.playerId = additionalData.readUUID();
        this.yHeadRotO = this.yHeadRot = additionalData.readFloat();
        this.setYRot(this.yHeadRot);
        this.yRotO = this.getYRot();
        this.yBodyRot = this.getYRot();
    }

    public UUID getPlayerID() {
        return this.playerId;
    }

    public void tick() {
        if (this.markedForDespawn) {
            this.discard();
            return;
        }
        super.tick();
        this.yHeadRot = this.yHeadRotO;
        this.setYRot(this.yRotO);
        this.setXRot(this.xRotO);
        if (!this.level().isClientSide) {
            if (this.foodStats != null) {
                this.foodStats.tick((Player)this.player);
            }
            if (this.locationChanged()) {
                ServerEditHandler.reset(ServerEditHandler.getData(this));
            }
        }
    }

    public boolean locationChanged() {
        return this.originX >= this.getX() + 1.0 || this.originX <= this.getX() - 1.0 || this.originY >= this.getY() + 1.0 || this.originY <= this.getY() - 1.0 || this.originZ >= this.getZ() + 1.0 || this.originZ <= this.getZ() - 1.0;
    }

    public boolean hurt(DamageSource damageSource, float par2) {
        if (!(this.level().isClientSide || this.gameType.equals((Object)GameType.CREATIVE) && !damageSource.is(DamageTypeTags.BYPASSES_INVULNERABILITY))) {
            ServerEditHandler.reset(damageSource, par2, ServerEditHandler.getData(this));
        }
        return true;
    }

    public boolean shouldShowName() {
        return this.username != null;
    }

    public Component getName() {
        return Component.literal((String)(this.username != null ? this.username : "DECOY"));
    }

    public ItemStack getItemBySlot(EquipmentSlot slotIn) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            return this.inventory.getSelected();
        }
        if (slotIn == EquipmentSlot.OFFHAND) {
            return (ItemStack)this.inventory.offhand.get(0);
        }
        return (ItemStack)this.inventory.armor.get(slotIn.getIndex());
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        if (slotIn == EquipmentSlot.MAINHAND) {
            this.inventory.setItem(this.inventory.selected, stack);
        } else if (slotIn == EquipmentSlot.OFFHAND) {
            this.inventory.offhand.set(0, (Object)stack);
        } else {
            this.inventory.armor.set(slotIn.getIndex(), (Object)stack);
        }
    }

    public void setHealth(float par1) {
        if (this.player != null) {
            this.player.setHealth(par1);
        }
        super.setHealth(par1);
    }

    public Iterable<ItemStack> getArmorSlots() {
        return this.inventory.armor;
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    private static class DecoyPlayer
    extends FakePlayer {
        DecoyEntity decoy;

        DecoyPlayer(ServerLevel level, DecoyEntity decoy, ServerPlayer player) {
            super(level, player.getGameProfile());
            player.getServer().getPlayerList().getPlayerAdvancements(player);
            this.decoy = decoy;
            this.setHealth(decoy.getHealth());
        }

        public void heal(float par1) {
            this.decoy.heal(par1);
        }
    }
}

