/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity;

import com.mojang.datafixers.util.Pair;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.FrogTraitsComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.util.MSTags;
import java.util.Arrays;
import java.util.Locale;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.JumpControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class FrogEntity
extends PathfinderMob {
    private static final double BASE_HEALTH = 5.0;
    private static final double BASE_SPEED = 0.3;
    private int jumpTicks;
    private int jumpDuration;
    private boolean wasOnGround;
    private int currentMoveTypeDuration;
    private static final EntityDataAccessor<Integer> SKIN_COLOR = SynchedEntityData.defineId(FrogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> EYE_COLOR = SynchedEntityData.defineId(FrogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> BELLY_COLOR = SynchedEntityData.defineId(FrogEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<String> EYE_TYPE = SynchedEntityData.defineId(FrogEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> BELLY_TYPE = SynchedEntityData.defineId(FrogEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<String> VARIANT = SynchedEntityData.defineId(FrogEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final ResourceLocation GENETIC_SIZE_ATTRIBUTE_KEY = Minestuck.id("genetic_size");

    public FrogEntity(Level level) {
        this(MSEntityTypes.FROG.get(), level);
    }

    public FrogEntity(EntityType<? extends FrogEntity> type, Level level) {
        super(type, level);
        this.jumpControl = new JumpHelperController(this);
        this.moveControl = new MoveHelperController(this);
        this.setMovementSpeed(0.0);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(VARIANT, (Object)FrogVariants.DEFAULT.getSerializedName());
        builder.define(SKIN_COLOR, (Object)this.random(34277));
        builder.define(EYE_COLOR, (Object)this.random(15967496));
        builder.define(BELLY_COLOR, (Object)this.random(28350));
        builder.define(EYE_TYPE, (Object)EyeTypes.LIGHT.getSerializedName());
        builder.define(BELLY_TYPE, (Object)BellyTypes.SOLID.getSerializedName());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        if (player.distanceToSqr((Entity)this) < 9.0 && !this.level().isClientSide) {
            if (itemstack.getItem() == MSItems.BUG_NET.get()) {
                itemstack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                ItemStack frogItem = new ItemStack((ItemLike)MSItems.FROG.get());
                frogItem.set(MSItemComponents.FROG_TRAITS, (Object)FrogTraitsComponent.fromFrogEntity(this));
                if (this.hasCustomName()) {
                    frogItem.set(DataComponents.CUSTOM_NAME, (Object)this.getCustomName());
                }
                this.spawnAtLocation(frogItem, 0.0f);
                this.discard();
            } else if (itemstack.getItem() == MSItems.GOLDEN_GRASSHOPPER.get() && this.getFrogVariant() != FrogVariants.GOLDEN) {
                if (!player.isCreative()) {
                    itemstack.shrink(1);
                }
                this.level().addParticle((ParticleOptions)ParticleTypes.EXPLOSION, this.getX(), this.getY() + (double)(this.getBbHeight() / 2.0f), this.getZ(), 0.0, 0.0, 0.0);
                this.playSound(SoundEvents.ANVIL_HIT, this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
                this.setFrogVariant(FrogVariants.GOLDEN);
            }
        }
        return super.mobInteract(player, hand);
    }

    public static AttributeSupplier.Builder frogAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 5.0);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new PanicGoal((PathfinderMob)this, 2.2));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, (Predicate)Ingredient.of(MSTags.Items.BUGS), false));
        this.goalSelector.addGoal(6, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(11, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 10.0f));
    }

    protected float getJumpPower() {
        if (!(this.horizontalCollision || this.moveControl.hasWanted() && !(this.moveControl.getWantedY() <= this.getY() + 0.5))) {
            Path path = this.navigation.getPath();
            if (path != null && path.getNextNodeIndex() < path.getNodeCount()) {
                Vec3 vec3d = path.getNextEntityPos((Entity)this);
                if (vec3d.y > this.getY() + 0.5) {
                    return 0.5f;
                }
            }
            return this.moveControl.getSpeedModifier() <= 0.6 ? 0.2f : 0.3f;
        }
        return 0.5f;
    }

    public void jumpFromGround() {
        double d1;
        super.jumpFromGround();
        double d0 = this.moveControl.getSpeedModifier();
        if (d0 > 0.0 && (d1 = this.getDeltaMovement().horizontalDistanceSqr()) < 0.01) {
            this.moveRelative(0.1f, new Vec3(0.0, 0.0, 1.0));
        }
        if (!this.level().isClientSide) {
            this.level().broadcastEntityEvent((Entity)this, (byte)1);
        }
    }

    public void handleEntityEvent(byte id) {
        if (id == 1) {
            this.jumpDuration = 10;
            this.jumpTicks = 0;
        } else {
            super.handleEntityEvent(id);
        }
    }

    public float setJumpCompletion(float p_175521_1_) {
        return this.jumpDuration == 0 ? 0.0f : ((float)this.jumpTicks + p_175521_1_) / (float)this.jumpDuration;
    }

    public void setMovementSpeed(double newSpeed) {
        this.getNavigation().setSpeedModifier(newSpeed);
        this.moveControl.setWantedPosition(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ(), newSpeed);
    }

    public void setJumping(boolean jumping) {
        super.setJumping(jumping);
        if (jumping) {
            this.playSound(this.getJumpSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void startJumping() {
        this.setJumping(true);
        this.jumpDuration = 10;
        this.jumpTicks = 0;
    }

    public void customServerAiStep() {
        if (this.currentMoveTypeDuration > 0) {
            --this.currentMoveTypeDuration;
        }
        if (this.onGround()) {
            JumpHelperController jumpHelper;
            if (!this.wasOnGround) {
                this.setJumping(false);
                this.checkLandingDelay();
            }
            if (!(jumpHelper = (JumpHelperController)this.jumpControl).getIsJumping()) {
                if (this.moveControl.hasWanted() && this.currentMoveTypeDuration == 0) {
                    Path path = this.navigation.getPath();
                    Vec3 vec3d = new Vec3(this.moveControl.getWantedX(), this.moveControl.getWantedY(), this.moveControl.getWantedZ());
                    if (path != null && path.getNextNodeIndex() < path.getNodeCount()) {
                        vec3d = path.getNextEntityPos((Entity)this);
                    }
                    this.calculateRotationYaw(vec3d.x, vec3d.z);
                    this.startJumping();
                }
            } else if (!jumpHelper.canJump()) {
                this.enableJumpControl();
            }
        }
        this.wasOnGround = this.onGround();
    }

    private void calculateRotationYaw(double x, double z) {
        this.setYRot((float)(Mth.atan2((double)(z - this.getZ()), (double)(x - this.getX())) * 57.29577951308232) - 90.0f);
    }

    private void enableJumpControl() {
        ((JumpHelperController)this.jumpControl).setCanJump(true);
    }

    private void disableJumpControl() {
        ((JumpHelperController)this.jumpControl).setCanJump(false);
    }

    private void updateMoveTypeDuration() {
        this.currentMoveTypeDuration = this.moveControl.getSpeedModifier() < 2.2 ? 10 : 1;
    }

    private void checkLandingDelay() {
        this.updateMoveTypeDuration();
        this.disableJumpControl();
    }

    public void aiStep() {
        super.aiStep();
        if (this.jumpTicks != this.jumpDuration) {
            ++this.jumpTicks;
        } else if (this.jumpDuration != 0) {
            this.jumpTicks = 0;
            this.jumpDuration = 0;
            this.setJumping(false);
        }
    }

    protected SoundEvent getAmbientSound() {
        return MSSoundEvents.ENTITY_FROG_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MSSoundEvents.ENTITY_FROG_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return MSSoundEvents.ENTITY_FROG_DEATH.get();
    }

    protected SoundEvent getJumpSound() {
        return SoundEvents.RABBIT_JUMP;
    }

    public float getVoicePitch() {
        return (this.random.nextFloat() - this.random.nextFloat()) / (this.getScale() + 0.4f) * 0.2f + 1.0f;
    }

    protected EntityDimensions getDefaultDimensions(Pose pPose) {
        return super.getDefaultDimensions(pPose);
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Variant", this.getFrogVariant().getSerializedName());
        compound.putInt("SkinColor", this.getSkinColor());
        compound.putInt("EyeColor", this.getEyeColor());
        compound.putInt("BellyColor", this.getBellyColor());
        compound.putString("EyeType", this.getEyeType().getSerializedName());
        compound.putString("BellyType", this.getBellyType().getSerializedName());
        compound.putBoolean("WasOnGround", this.wasOnGround);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Variant", 8)) {
            this.setFrogVariant(FrogVariants.getWithDefault(compound.getString("Variant")));
        }
        if (compound.contains("EyeType", 8)) {
            this.setEyeType(EyeTypes.getWithDefault(compound.getString("EyeType")));
        }
        if (compound.contains("BellyType", 8)) {
            this.setBellyType(BellyTypes.getWithDefault(compound.getString("BellyType")));
        }
        if (compound.contains("SkinColor", 3)) {
            this.setSkinColor(Math.clamp((long)compound.getInt("SkinColor"), 0, 0xFFFFFF));
        }
        if (compound.contains("EyeColor", 3)) {
            this.setEyeColor(Math.clamp((long)compound.getInt("EyeColor"), 0, 0xFFFFFF));
        }
        if (compound.contains("BellyColor", 3)) {
            this.setBellyColor(Math.clamp((long)compound.getInt("BellyColor"), 0, 0xFFFFFF));
        }
        this.wasOnGround = compound.getBoolean("WasOnGround");
    }

    public void setSkinColor(int i) {
        this.entityData.set(SKIN_COLOR, (Object)i);
    }

    public int getSkinColor() {
        return (Integer)this.entityData.get(SKIN_COLOR);
    }

    public void setEyeColor(int i) {
        this.entityData.set(EYE_COLOR, (Object)i);
    }

    public int getEyeColor() {
        return (Integer)this.entityData.get(EYE_COLOR);
    }

    public void setBellyColor(int i) {
        this.entityData.set(BELLY_COLOR, (Object)i);
    }

    public int getBellyColor() {
        return (Integer)this.entityData.get(BELLY_COLOR);
    }

    public void setEyeType(EyeTypes i) {
        this.entityData.set(EYE_TYPE, (Object)i.getSerializedName());
    }

    public EyeTypes getEyeType() {
        return EyeTypes.getWithDefault(this.entityData);
    }

    public void setBellyType(BellyTypes i) {
        this.entityData.set(BELLY_TYPE, (Object)i.getSerializedName());
    }

    public BellyTypes getBellyType() {
        return BellyTypes.getWithDefault(this.entityData);
    }

    public void setFrogVariant(FrogVariants i) {
        this.entityData.set(VARIANT, (Object)i.getSerializedName());
    }

    public FrogVariants getFrogVariant() {
        return FrogVariants.getWithDefault(this.entityData);
    }

    public void setFrogSize(double size, boolean regenHealth) {
        this.setPos(this.getX(), this.getY(), this.getZ());
        this.getAttribute(Attributes.SCALE).setBaseValue(size);
        this.getAttribute(Attributes.MAX_HEALTH).setBaseValue(5.0 * size);
        this.getAttribute(Attributes.MOVEMENT_SPEED).setBaseValue(0.3 * size);
        if (regenHealth) {
            this.setHealth(this.getMaxHealth());
        }
        this.xpReward = (int)size;
    }

    public double getFrogSize() {
        return this.getAttribute(Attributes.SCALE).getBaseValue();
    }

    public int random(int max) {
        Random rand = new Random();
        return rand.nextInt(max + 1);
    }

    public float randomFloat(int max) {
        Random rand = new Random();
        return (float)rand.nextInt(max * 10) / 10.0f;
    }

    public FrogVariants getRandomFrogVariant(Pair<FrogVariants, Float> ... odds) {
        for (Pair<FrogVariants, Float> odd : odds) {
            if (!(this.random.nextFloat() <= ((Float)odd.getSecond()).floatValue())) continue;
            return (FrogVariants)((Object)odd.getFirst());
        }
        return FrogVariants.DEFAULT;
    }

    public FrogVariants getRandomFrogVariant() {
        return this.getRandomFrogVariant(new Pair((Object)FrogVariants.TOTALLY_NORMAL, (Object)Float.valueOf(0.05f)), new Pair((Object)FrogVariants.RUBY_CONTRABAND, (Object)Float.valueOf(0.02f)), new Pair((Object)FrogVariants.SUSAN, (Object)Float.valueOf(0.002f)));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public static boolean canFrogSpawnOn(EntityType<FrogEntity> entityType, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return true;
    }

    public static class JumpHelperController
    extends JumpControl {
        private final FrogEntity frog;
        private boolean canJump;

        public JumpHelperController(FrogEntity frog) {
            super((Mob)frog);
            this.frog = frog;
        }

        public boolean getIsJumping() {
            return this.jump;
        }

        public boolean canJump() {
            return this.canJump;
        }

        public void setCanJump(boolean canJumpIn) {
            this.canJump = canJumpIn;
        }

        public void tick() {
            if (this.jump) {
                this.frog.startJumping();
                this.jump = false;
            }
        }
    }

    static class MoveHelperController
    extends MoveControl {
        private final FrogEntity frog;
        private double nextJumpSpeed;

        public MoveHelperController(FrogEntity frog) {
            super((Mob)frog);
            this.frog = frog;
        }

        public void tick() {
            if (this.frog.onGround() && !this.frog.jumping && !((JumpHelperController)this.frog.jumpControl).getIsJumping()) {
                this.frog.setMovementSpeed(0.0);
            } else if (this.hasWanted()) {
                this.frog.setMovementSpeed(this.nextJumpSpeed);
            }
            super.tick();
        }

        public void setWantedPosition(double x, double y, double z, double speedIn) {
            if (this.frog.isInWater()) {
                speedIn = 1.5;
            }
            super.setWantedPosition(x, y, z, speedIn);
            if (speedIn > 0.0) {
                this.nextJumpSpeed = speedIn;
            }
        }
    }

    public static enum FrogVariants implements StringRepresentable
    {
        DEFAULT,
        TOTALLY_NORMAL,
        RUBY_CONTRABAND,
        GENESIS,
        NULL,
        GOLDEN,
        SUSAN;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static FrogVariants getWithDefault(String name) {
            return Arrays.stream(FrogVariants.values()).filter(value -> value.getSerializedName().equals(name)).findFirst().orElse(DEFAULT);
        }

        public static FrogVariants getWithDefault(SynchedEntityData data) {
            return FrogVariants.getWithDefault((String)data.get(VARIANT));
        }
    }

    public static enum EyeTypes implements StringRepresentable
    {
        LIGHT,
        DARK,
        BLANK;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static EyeTypes getWithDefault(String name) {
            return Arrays.stream(EyeTypes.values()).filter(value -> value.getSerializedName().equals(name)).findFirst().orElse(LIGHT);
        }

        public static EyeTypes getWithDefault(SynchedEntityData data) {
            return EyeTypes.getWithDefault((String)data.get(EYE_TYPE));
        }
    }

    public static enum BellyTypes implements StringRepresentable
    {
        NONE,
        SOLID,
        SPOTTED,
        STRIPED;


        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public static BellyTypes getWithDefault(String name) {
            return Arrays.stream(BellyTypes.values()).filter(value -> value.getSerializedName().equals(name)).findFirst().orElse(SOLID);
        }

        public static BellyTypes getWithDefault(SynchedEntityData data) {
            return BellyTypes.getWithDefault((String)data.get(BELLY_TYPE));
        }
    }
}

