/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.item.loot.MSLootTables;
import com.mraof.minestuck.network.LotusFlowerAnimationPacket;
import com.mraof.minestuck.util.MSSoundEvents;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LotusFlowerEntity
extends Entity
implements GeoEntity,
IEntityWithComplexSpawn {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int OPENING_LENGTH = 120;
    private static final int GROWTH_LENGTH = 21;
    private static final int OPEN_IDLE_LENGTH = 240;
    private static final int VANISHING_LENGTH = 13;
    private static final int IDLE_TIME = -1;
    private static final int GROWTH_STOP = -2;
    private static final int GROWTH_START = -23;
    private static final int OPEN_START = 0;
    private static final int OPEN_IDLE_START = 120;
    private static final int VANISH_START = 360;
    private static final int ANIMATION_END = 373;
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int eventTimer = -1;
    public static final String REGROW = "minestuck.lotusflowerentity.regrow";
    @Nonnull
    private Animation animationType = Animation.IDLE;

    protected LotusFlowerEntity(EntityType<? extends LotusFlowerEntity> type, Level level) {
        super(type, level);
        this.setInvulnerable(true);
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        state.getController().setAnimation(this.animationType.animation);
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public boolean isPickable() {
        return true;
    }

    public InteractionResult interact(Player player, InteractionHand hand) {
        if (this.isAlive() && !player.isShiftKeyDown() && this.animationType == Animation.IDLE) {
            this.startLotusAnimation();
            return InteractionResult.SUCCESS;
        }
        if (this.isAlive() && this.animationType == Animation.EMPTY) {
            ItemStack itemstack = player.getItemInHand(hand);
            if (player.distanceToSqr((Entity)this) < 36.0 && itemstack.is(Items.BONE_MEAL) && player.isCreative()) {
                this.restoreFromBonemeal();
            } else if (this.level().isClientSide && player.distanceToSqr((Entity)this) < 36.0) {
                player.sendSystemMessage((Component)Component.translatable((String)REGROW));
            }
            return InteractionResult.SUCCESS;
        }
        return super.interact(player, hand);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (this.animationType != Animation.IDLE) {
                this.setEventTimer(this.eventTimer + 1);
            }
            if (this.eventTimer == 120) {
                this.spawnLoot();
            } else if (this.eventTimer >= (Integer)MinestuckConfig.SERVER.lotusRestorationTime.get() * 20) {
                this.setEventTimer(-23);
            } else if (this.eventTimer == -2) {
                this.setEventTimer(-1);
            }
        }
    }

    private void startLotusAnimation() {
        if (!this.level().isClientSide) {
            this.setEventTimer(0);
            Vec3 posVec = this.position();
            this.level().playSound(null, posVec.x(), posVec.y(), posVec.z(), MSSoundEvents.EVENT_LOTUS_FLOWER_OPEN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    private void restoreFromBonemeal() {
        if (!this.level().isClientSide) {
            this.setEventTimer(-23);
        }
        Vec3 posVec = this.position();
        for (int i = 0; i < 10; ++i) {
            this.level().addParticle((ParticleOptions)ParticleTypes.COMPOSTER, posVec.x, posVec.y + 0.5, posVec.z, 0.5 - this.random.nextDouble(), 0.5 - this.random.nextDouble(), 0.5 - this.random.nextDouble());
        }
    }

    private void setEventTimer(int time) {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Shouldn't call setEventTimer client-side!");
        }
        this.eventTimer = time;
        Animation newAnimation = this.animationFromEventTimer();
        if (newAnimation != this.animationType) {
            this.updateAndSendAnimation(newAnimation);
        }
    }

    private Animation animationFromEventTimer() {
        if (this.eventTimer >= 373) {
            return Animation.EMPTY;
        }
        if (this.eventTimer >= 360) {
            return Animation.VANISH;
        }
        if (this.eventTimer >= 120) {
            return Animation.OPEN_IDLE;
        }
        if (this.eventTimer >= 0) {
            return Animation.OPEN;
        }
        if (this.eventTimer < -1) {
            return Animation.GROW;
        }
        return Animation.IDLE;
    }

    protected void updateAndSendAnimation(Animation animation) {
        this.animationType = animation;
        LotusFlowerAnimationPacket packet = LotusFlowerAnimationPacket.createPacket(this, animation);
        PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    protected void spawnLoot() {
        if (!this.level().isClientSide) {
            ServerLevel serverLevel = (ServerLevel)this.level();
            LootTable lootTable = serverLevel.getServer().reloadableRegistries().getLootTable(MSLootTables.LOTUS_FLOWER_DEFAULT);
            ObjectArrayList loot = lootTable.getRandomItems(new LootParams.Builder(serverLevel).create(LootContextParamSets.EMPTY));
            if (loot.isEmpty()) {
                LOGGER.warn("Tried to generate loot for Lotus Flower, but no items were generated!");
            }
            for (ItemStack itemStack : loot) {
                this.spawnAtLocation(itemStack, 1.0f);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("EventTimer", this.eventTimer);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("EventTimer", 99)) {
            this.eventTimer = compound.getInt("EventTimer");
            this.animationType = this.animationFromEventTimer();
        }
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.animationType);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.animationType = (Animation)additionalData.readEnum(Animation.class);
    }

    public void setAnimationFromPacket(Animation newAnimation) {
        if (this.level().isClientSide) {
            this.animationType = newAnimation;
            if (this.animationType == Animation.IDLE) {
                this.addRestoreEffects();
            }
            if (this.animationType == Animation.OPEN_IDLE) {
                this.addLootSpawnEffects();
            }
        }
    }

    protected void addRestoreEffects() {
        Vec3 posVec = this.position();
        this.level().addParticle((ParticleOptions)ParticleTypes.FLASH, posVec.x, posVec.y + 0.5, posVec.z, 0.0, 0.0, 0.0);
        this.level().playLocalSound(posVec.x(), posVec.y(), posVec.z(), MSSoundEvents.EVENT_LOTUS_FLOWER_RESTORE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
    }

    protected void addLootSpawnEffects() {
        Vec3 posVec = this.position();
        this.level().addParticle((ParticleOptions)ParticleTypes.FLASH, posVec.x, posVec.y + 0.5, posVec.z, 0.0, 0.0, 0.0);
        this.level().playLocalSound(posVec.x(), posVec.y(), posVec.z(), MSSoundEvents.EVENT_LOTUS_FLOWER_LOOT_SPAWN.get(), SoundSource.NEUTRAL, 1.0f, 1.0f, false);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void move(MoverType typeIn, Vec3 pos) {
    }

    public static enum Animation {
        IDLE("lotus.idle"),
        OPEN("lotus.open"),
        OPEN_IDLE("lotus.open.idle"),
        VANISH("lotus.vanish"),
        EMPTY("lotus.bud"),
        GROW("lotus.grow");

        private final RawAnimation animation;

        private Animation(String animationName) {
            this.animation = RawAnimation.begin().thenLoop(animationName);
        }
    }
}

