/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity;

import com.mraof.minestuck.network.ServerCursorAnimationPacket;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ServerCursorEntity
extends Entity
implements GeoEntity,
IEntityWithComplexSpawn {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private int despawnTimer = 0;
    private boolean removalFlag = false;
    private final int CURSOR_DESPAWN_TICKS = 40;
    private final int CURSOR_REMOVAL_PADDING = 3;
    @Nonnull
    private AnimationType animationType = AnimationType.CLICK;

    protected ServerCursorEntity(EntityType<? extends ServerCursorEntity> type, Level level) {
        super(type, level);
        this.noPhysics = true;
        this.setNoGravity(true);
        this.setInvulnerable(true);
        this.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        if (!this.waitForFinish(state)) {
            state.getController().setAnimation(this.animationType.animation);
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeEnum((Enum)this.animationType);
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.animationType = (AnimationType)additionalData.readEnum(AnimationType.class);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            if (!this.animationType.looping || this.removalFlag) {
                ++this.despawnTimer;
            }
            if (!this.removalFlag) {
                if (this.despawnTimer >= 40) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
            } else if (this.despawnTimer >= this.animationType.length + 3 + 1) {
                this.remove(Entity.RemovalReason.DISCARDED);
            }
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    protected void readAdditionalSaveData(CompoundTag pCompound) {
    }

    protected void addAdditionalSaveData(CompoundTag pCompound) {
    }

    public void setAnimation(AnimationType animation) {
        if (!this.level().isClientSide) {
            this.animationType = animation;
            if (!this.removalFlag) {
                this.despawnTimer = 0;
            }
            ServerCursorAnimationPacket packet = ServerCursorAnimationPacket.createPacket(this, animation);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            this.setAnimationFromPacket(animation);
        }
    }

    public void setAnimationFromPacket(AnimationType animation) {
        if (this.level().isClientSide) {
            this.animationType = animation;
        }
    }

    public void queueRemoval(AnimationType removalAnimation) {
        if (this.level().isClientSide) {
            throw new IllegalStateException("queueRemoval() was accessed from the client-side! It should only be accessed remotely.");
        }
        this.setAnimation(removalAnimation);
        this.removalFlag = true;
    }

    private boolean waitForFinish(AnimationState<?> event) {
        if (event.getController().getCurrentAnimation() == null) {
            return false;
        }
        if (event.getController().getCurrentAnimation().loopType() == Animation.LoopType.PLAY_ONCE && !this.removalFlag) {
            return event.getController().getAnimationState() == AnimationController.State.RUNNING;
        }
        return false;
    }

    public static enum AnimationType {
        IDLE("animation.ServerCursorModel.idle", true, 40),
        CLICK("animation.ServerCursorModel.click", false, 4),
        REJECTED("animation.ServerCursorModel.rejected", false, 4),
        LOADING("animation.ServerCursorModel.loading", true, 20);

        private final RawAnimation animation;
        private final boolean looping;
        private final int length;

        private AnimationType(String animationName, boolean looping, int length) {
            this.animation = RawAnimation.begin().then(animationName, looping ? Animation.LoopType.LOOP : Animation.LoopType.PLAY_ONCE);
            this.looping = looping;
            this.length = length;
        }
    }
}

