/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.ai;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.phys.AABB;

public class HurtByTargetAlliedGoal
extends TargetGoal {
    private final Predicate<Entity> alliedPredicate;
    private int revengeTimer;

    public HurtByTargetAlliedGoal(Mob mob, Predicate<Entity> alliedPredicate) {
        super(mob, false);
        this.alliedPredicate = alliedPredicate;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET));
    }

    public boolean canUse() {
        int i = this.mob.getLastHurtByMobTimestamp();
        return i != this.revengeTimer && this.canAttack(this.mob.getLastHurtByMob(), TargetingConditions.DEFAULT);
    }

    public void start() {
        this.mob.setTarget(this.mob.getLastHurtByMob());
        this.revengeTimer = this.mob.getLastHurtByMobTimestamp();
        double d0 = this.getFollowDistance();
        List list = this.mob.level().getEntitiesOfClass(Mob.class, new AABB(this.mob.getX(), this.mob.getY(), this.mob.getZ(), this.mob.getX() + 1.0, this.mob.getY() + 1.0, this.mob.getZ() + 1.0).inflate(d0, 10.0, d0), this.alliedPredicate);
        for (Mob creature : list) {
            if (this.mob == creature || creature.getLastHurtByMob() != null || creature.isAlliedTo((Entity)this.mob.getLastHurtByMob())) continue;
            creature.setTarget(this.mob.getLastHurtByMob());
        }
        super.start();
    }
}

