/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.ai;

import com.mraof.minestuck.entity.AnimatedPathfinderMob;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import org.joml.Vector3d;

public abstract class MobAnimationPhaseGoal<T extends PathfinderMob>
extends Goal {
    protected final T entity;
    protected final PhasedMobAnimation phasedAnimation;
    protected int time = 0;
    protected Vector3d lookTarget;
    protected double speed;

    public MobAnimationPhaseGoal(T entity, PhasedMobAnimation phasedAnimation) {
        this.entity = entity;
        this.phasedAnimation = phasedAnimation;
        MobAnimation animation = phasedAnimation.getAnimation();
        if (animation.freezeMovement() && !animation.freezeSight()) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE));
        } else if (!animation.freezeMovement() && animation.freezeSight()) {
            this.setFlags(EnumSet.of(Goal.Flag.LOOK));
        } else if (animation.freezeMovement() && animation.freezeSight()) {
            this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }
    }

    public boolean canUse() {
        return true;
    }

    public boolean canContinueToUse() {
        return this.phasedAnimation.getCurrentPhase((PathfinderMob)this.entity, this.time, this.speed) != PhasedMobAnimation.Phases.NEUTRAL;
    }

    public boolean isInterruptable() {
        return false;
    }

    public void start() {
        MobAnimation animation = this.phasedAnimation.getAnimation();
        this.speed = MobAnimation.getAttributeAffectedSpeed(this.entity, this.phasedAnimation.getSpeedModifyingAttribute());
        T t = this.entity;
        if (t instanceof AnimatedPathfinderMob) {
            AnimatedPathfinderMob animatedMob = (AnimatedPathfinderMob)((Object)t);
            animatedMob.setCurrentAnimation(animation, this.speed);
        }
        LivingEntity target = this.entity.getTarget();
        if (animation.freezeSight() && target != null) {
            this.lookTarget = new Vector3d(target.getX(), target.getEyeY(), target.getZ());
        }
        ((PhasedMobAnimation.Phases.Holder)this.entity).setAnimationPhase(PhasedMobAnimation.Phases.ANTICIPATION, animation.action());
    }

    public void stop() {
        this.time = 0;
        T t = this.entity;
        if (t instanceof AnimatedPathfinderMob) {
            AnimatedPathfinderMob animatedMob = (AnimatedPathfinderMob)((Object)t);
            animatedMob.endCurrentAction();
        }
    }

    public void tick() {
        if (this.phasedAnimation.getAnimation().freezeSight() && this.lookTarget != null) {
            this.entity.getLookControl().setLookAt(this.lookTarget.x, this.lookTarget.y, this.lookTarget.z);
        }
        ++this.time;
        this.phasedAnimation.attemptPhaseChange(this.time, this.entity, this.speed);
    }
}

