/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.ai.attack;

import com.mraof.minestuck.entity.ai.MobAnimationPhaseGoal;
import com.mraof.minestuck.entity.animation.ActionCooldown;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class AnimatedAttackWhenInRangeGoal<T extends PathfinderMob>
extends MobAnimationPhaseGoal<T> {
    public static final float STANDARD_MELEE_RANGE = -1.0f;
    public static final float STANDARD_MELEE_ARC = 70.0f;
    public static final int NO_COOLDOWN = -1;
    protected final float minRange;
    protected final float maxRange;
    protected final int actionCooldown;
    protected final float attackDirectionOffset;
    protected final float attackConeAngle;

    public AnimatedAttackWhenInRangeGoal(T entity, PhasedMobAnimation animation, float minRange, float maxRange, int actionCooldown, float attackDirectionOffset, float attackConeAngle) {
        super(entity, animation);
        this.minRange = minRange;
        this.maxRange = maxRange;
        this.actionCooldown = actionCooldown;
        this.attackDirectionOffset = attackDirectionOffset;
        this.attackConeAngle = attackConeAngle;
    }

    public AnimatedAttackWhenInRangeGoal(T entity, PhasedMobAnimation animation, int actionCooldown) {
        this(entity, animation, 0.0f, -1.0f, actionCooldown, 0.0f, 70.0f);
    }

    public AnimatedAttackWhenInRangeGoal(T entity, PhasedMobAnimation animation) {
        this(entity, animation, 0.0f, -1.0f, -1, 0.0f, 70.0f);
    }

    @Override
    public boolean canUse() {
        LivingEntity target = this.entity.getTarget();
        return target != null && this.isValidTarget(target) && this.entity.getSensing().hasLineOfSight((Entity)target);
    }

    @Override
    public void stop() {
        PathfinderMob pathfinderMob;
        super.stop();
        if (this.actionCooldown != -1 && (pathfinderMob = this.entity) instanceof ActionCooldown) {
            ActionCooldown cooldownEntity = (ActionCooldown)pathfinderMob;
            cooldownEntity.setCooldown(this.actionCooldown);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.time == this.phasedAnimation.getContactStartTime(this.speed)) {
            LivingEntity target = this.entity.getTarget();
            this.attemptToLandAttack(this.entity, target);
        }
    }

    protected boolean isValidTarget(@Nonnull LivingEntity target) {
        return target.isAlive() && this.withinRange(target) && this.withinAttackCone(target, 10.0f);
    }

    protected boolean targetCanBeHit(@Nonnull LivingEntity target) {
        return target.isAlive() && this.belowMaximumRange(target) && this.withinAttackCone(target, 0.0f);
    }

    protected boolean belowMaximumRange(@Nonnull LivingEntity target) {
        float moddedMaxRange = this.maxRange == -1.0f ? this.getStandardAttackReachSqr(target) : this.maxRange * this.maxRange;
        return (double)moddedMaxRange >= this.entity.distanceToSqr((Entity)target);
    }

    protected boolean aboveMinimumRange(@Nonnull LivingEntity target) {
        float moddedMinRange = this.minRange == -1.0f ? this.getStandardAttackReachSqr(target) : this.minRange * this.minRange;
        return (double)moddedMinRange <= this.entity.distanceToSqr((Entity)target);
    }

    protected float getStandardAttackReachSqr(LivingEntity target) {
        return this.entity.getBbWidth() * 2.0f * this.entity.getBbWidth() * 2.0f + target.getBbWidth();
    }

    protected boolean withinRange(@Nonnull LivingEntity target) {
        return this.belowMaximumRange(target) && this.aboveMinimumRange(target);
    }

    protected boolean withinAttackCone(@Nonnull LivingEntity target, float anglePadding) {
        Vec3 attackDirection = Vec3.directionFromRotation((float)0.0f, (float)(this.entity.getVisualRotationYInDegrees() + this.attackDirectionOffset));
        Vec3 targetDirection = this.entity.position().vectorTo(target.position()).normalize();
        targetDirection = new Vec3(targetDirection.x, 0.0, targetDirection.z);
        float angleOfTargetFromConeCenter = 90.0f * ((float)attackDirection.dot(targetDirection) * -1.0f + 1.0f);
        return angleOfTargetFromConeCenter <= Mth.clamp((float)(this.attackConeAngle + anglePadding), (float)0.0f, (float)180.0f);
    }

    public void attemptToLandAttack(PathfinderMob attacker, LivingEntity target) {
        if (target != null && this.targetCanBeHit(target)) {
            attacker.doHurtTarget((Entity)target);
        }
    }
}

