/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.ai.attack;

import java.util.EnumSet;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.RangedAttackMob;

public class AttackByDistanceGoal
extends Goal {
    private final Mob entityHost;
    private final Mob attacker;
    private LivingEntity attackTarget;
    private int rangedAttackTime = -1;
    private float entityMoveSpeed;
    private int ticksSeeingTarget = 0;
    private int attackIntervalMin;
    private int maxRangedAttackTime;
    private float attackRadius;
    private float attackRadiusSqr;

    public AttackByDistanceGoal(RangedAttackMob par1IRangedAttackMob, float par2, int par3, float par4) {
        this(par1IRangedAttackMob, par2, par3, par3, par4);
    }

    public AttackByDistanceGoal(RangedAttackMob par1IRangedAttackMob, float par2, int par3, int par4, float par5) {
        if (!(par1IRangedAttackMob instanceof Mob)) {
            throw new IllegalArgumentException("ArrowAttackGoal requires Mob implements RangedAttackMob");
        }
        Mob mob = (Mob)par1IRangedAttackMob;
        this.attacker = mob;
        this.entityHost = mob;
        this.entityMoveSpeed = par2;
        this.attackIntervalMin = par3;
        this.maxRangedAttackTime = par4;
        this.attackRadius = par5;
        this.attackRadiusSqr = par5 * par5;
        this.setFlags(EnumSet.of(Goal.Flag.TARGET, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        LivingEntity entityliving = this.entityHost.getTarget();
        if (entityliving == null) {
            return false;
        }
        if (entityliving.isAlive()) {
            this.attackTarget = entityliving;
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse() || !this.entityHost.getNavigation().isDone();
    }

    public void stop() {
        this.attackTarget = null;
        this.ticksSeeingTarget = 0;
        this.rangedAttackTime = -1;
    }

    public void tick() {
        double d0 = this.entityHost.distanceToSqr(this.attackTarget.getX(), this.attackTarget.getBoundingBox().minY, this.attackTarget.getZ());
        boolean flag = this.entityHost.getSensing().hasLineOfSight((Entity)this.attackTarget);
        this.ticksSeeingTarget = flag ? ++this.ticksSeeingTarget : 0;
        if (d0 <= (double)this.attackRadiusSqr && this.ticksSeeingTarget >= 20) {
            this.entityHost.getNavigation().stop();
        } else {
            this.entityHost.getNavigation().moveTo((Entity)this.attackTarget, (double)this.entityMoveSpeed);
        }
        this.entityHost.getLookControl().setLookAt((Entity)this.attackTarget, 30.0f, 30.0f);
        double meleeRange = this.attacker.getBbWidth() * 2.0f * this.attacker.getBbWidth() * 2.0f;
        if (d0 > meleeRange) {
            if (--this.rangedAttackTime == 0) {
                if (d0 > (double)this.attackRadiusSqr || !flag) {
                    return;
                }
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                float f1 = Mth.clamp((float)f, (float)0.1f, (float)1.0f);
                ((RangedAttackMob)this.attacker).performRangedAttack(this.attackTarget, f1);
                this.rangedAttackTime = Mth.floor((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            } else if (this.rangedAttackTime < 0) {
                float f = (float)Math.sqrt(d0) / this.attackRadius;
                this.rangedAttackTime = Mth.floor((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
            }
        } else {
            this.rangedAttackTime = Math.max(this.rangedAttackTime - 1, 0);
            if (this.attacker.distanceToSqr(this.attackTarget.getX(), this.attackTarget.getBoundingBox().minY, this.attackTarget.getZ()) <= d0 && this.rangedAttackTime <= 0) {
                this.rangedAttackTime = 20;
                if (!this.attacker.getItemBySlot(EquipmentSlot.MAINHAND).isEmpty()) {
                    this.attacker.swing(InteractionHand.MAIN_HAND);
                }
                this.attacker.doHurtTarget((Entity)this.attackTarget);
            }
        }
    }
}

