/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.ai.attack;

import com.mraof.minestuck.entity.AttackingAnimatedEntity;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.projectile.SmallFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FireballShootGoal<T extends AttackingAnimatedEntity>
extends AnimatedAttackWhenInRangeGoal<T> {
    public static final int GROUP_SHOOT_COOLDOWN = 20;
    private BlockPos initialTargetPos;

    public FireballShootGoal(T entity, PhasedMobAnimation animation, float minRange, float maxRange, int actionCooldown) {
        super(entity, animation, minRange, maxRange, actionCooldown, 0.0f, 180.0f);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && ((AttackingAnimatedEntity)this.entity).hasFinishedCooldown() && this.noEntitiesObstructing(((AttackingAnimatedEntity)this.entity).getTarget());
    }

    @Override
    public void start() {
        super.start();
        this.initialTargetPos = Objects.requireNonNull(((AttackingAnimatedEntity)this.entity).getTarget()).blockPosition();
        this.applyGroupCooldown();
    }

    private void applyGroupCooldown() {
        AABB aabb;
        Level level = ((AttackingAnimatedEntity)this.entity).level();
        List entityList = level.getEntitiesOfClass(AttackingAnimatedEntity.class, aabb = new AABB(((AttackingAnimatedEntity)this.entity).blockPosition()).inflate(8.0));
        if (!entityList.isEmpty()) {
            for (AttackingAnimatedEntity iteratedEntity : entityList) {
                if (iteratedEntity == this.entity || iteratedEntity.getType() != ((AttackingAnimatedEntity)this.entity).getType() || iteratedEntity.existingCooldownIsLonger(20)) continue;
                iteratedEntity.setCooldown(20 + this.phasedAnimation.getTotalAnimationLength(this.speed));
            }
        }
    }

    @Override
    public void attemptToLandAttack(PathfinderMob attacker, LivingEntity target) {
        Level level = ((AttackingAnimatedEntity)this.entity).level();
        level.playSound(null, ((AttackingAnimatedEntity)this.entity).blockPosition(), SoundEvents.FIRECHARGE_USE, SoundSource.HOSTILE, 1.0f, 1.0f);
        if (this.initialTargetPos != null) {
            double distanceX = (double)this.initialTargetPos.getX() - attacker.getX();
            double distanceY = (double)this.initialTargetPos.getY() - (attacker.getY() + (double)(attacker.getBbHeight() / 2.0f));
            double distanceZ = (double)this.initialTargetPos.getZ() - attacker.getZ();
            SmallFireball fireball = new SmallFireball(level, (LivingEntity)attacker, new Vec3(distanceX, distanceY, distanceZ));
            double bbHeight = attacker.getBbHeight();
            Vec3 viewVec = attacker.getViewVector(1.0f);
            double x = (attacker.getBoundingBox().minX + attacker.getBoundingBox().maxX) / 2.0 + viewVec.x * bbHeight;
            double y = attacker.getY() + (double)(attacker.getBbHeight() / 2.0f);
            double z = (attacker.getBoundingBox().minZ + attacker.getBoundingBox().maxZ) / 2.0 + viewVec.z * bbHeight;
            fireball.setPos(x, y, z);
            level.addFreshEntity((Entity)fireball);
        }
    }

    private boolean noEntitiesObstructing(LivingEntity target) {
        float initialYHeadRotO = ((AttackingAnimatedEntity)this.entity).yHeadRotO;
        float initialYBodyRot = ((AttackingAnimatedEntity)this.entity).yBodyRot;
        float initialYBodyRotO = ((AttackingAnimatedEntity)this.entity).yBodyRotO;
        ((AttackingAnimatedEntity)this.entity).lookAt(target.createCommandSourceStack().getAnchor(), target.position());
        Vec3 targetFacingVec = ((AttackingAnimatedEntity)this.entity).getLookAngle();
        ((AttackingAnimatedEntity)this.entity).yHeadRotO = initialYHeadRotO;
        ((AttackingAnimatedEntity)this.entity).yBodyRot = initialYBodyRot;
        ((AttackingAnimatedEntity)this.entity).yBodyRotO = initialYBodyRotO;
        int distanceBetweenPos = (int)Math.sqrt(((AttackingAnimatedEntity)this.entity).blockPosition().distSqr((Vec3i)target.blockPosition()));
        for (int step = 0; step < distanceBetweenPos; ++step) {
            Vec3 eyePos = ((AttackingAnimatedEntity)this.entity).getEyePosition(1.0f);
            Vec3 vecPos = eyePos.add(targetFacingVec.scale((double)step));
            List<LivingEntity> livingEntityList = this.entityWithinAABB(((AttackingAnimatedEntity)this.entity).level(), vecPos, step + 1 == distanceBetweenPos);
            for (LivingEntity livingEntityIterate : livingEntityList) {
                if (livingEntityIterate == null || livingEntityIterate == this.entity || livingEntityIterate == target) continue;
                return false;
            }
        }
        return true;
    }

    private List<LivingEntity> entityWithinAABB(Level level, Vec3 vecPos, boolean lastStep) {
        AABB axisAlignedBB = new AABB(BlockPos.containing((Position)vecPos)).inflate(lastStep ? 4.0 : 0.75);
        return level.getEntitiesOfClass(LivingEntity.class, axisAlignedBB);
    }
}

