/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.ai.attack;

import com.mraof.minestuck.entity.AttackingAnimatedEntity;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.List;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class GroundSlamGoal<T extends AttackingAnimatedEntity>
extends AnimatedAttackWhenInRangeGoal<T> {
    public static final int GROUP_SLAM_COOLDOWN = 20;

    public GroundSlamGoal(T entity, PhasedMobAnimation animation, float minRange, float maxRange, int actionCooldown) {
        super(entity, animation, minRange, maxRange, actionCooldown, 0.0f, 180.0f);
    }

    @Override
    public boolean canUse() {
        return super.canUse() && ((AttackingAnimatedEntity)this.entity).hasFinishedCooldown();
    }

    @Override
    public void start() {
        super.start();
        this.applyGroupCooldown();
    }

    private void applyGroupCooldown() {
        AABB aabb;
        Level level = ((AttackingAnimatedEntity)this.entity).level();
        List entityList = level.getEntitiesOfClass(AttackingAnimatedEntity.class, aabb = new AABB(((AttackingAnimatedEntity)this.entity).blockPosition()).inflate(8.0));
        if (!entityList.isEmpty()) {
            for (AttackingAnimatedEntity iteratedEntity : entityList) {
                if (iteratedEntity == this.entity || iteratedEntity.getType() != ((AttackingAnimatedEntity)this.entity).getType() || iteratedEntity.existingCooldownIsLonger(20)) continue;
                iteratedEntity.setCooldown(20 + this.phasedAnimation.getTotalAnimationLength(this.speed));
            }
        }
    }

    @Override
    public void attemptToLandAttack(PathfinderMob attacker, LivingEntity target) {
        Level level = ((AttackingAnimatedEntity)this.entity).level();
        level.playSound(null, ((AttackingAnimatedEntity)this.entity).blockPosition(), MSSoundEvents.ENTITY_SLAM.get(), SoundSource.HOSTILE, 2.5f, 1.0f);
        AABB aabb = new AABB(attacker.blockPosition()).inflate(4.0);
        List entityList = level.getEntitiesOfClass(LivingEntity.class, aabb);
        if (!entityList.isEmpty()) {
            for (LivingEntity iteratedEntity : entityList) {
                boolean smallerThanAttacker;
                boolean bl = smallerThanAttacker = iteratedEntity.getBoundingBox().getSize() < attacker.getBoundingBox().getSize();
                if (iteratedEntity == attacker || iteratedEntity == target || !iteratedEntity.onGround() || iteratedEntity.noPhysics || !smallerThanAttacker) continue;
                this.fling(attacker, iteratedEntity, false);
            }
        }
        if (target != null && this.targetCanBeHit(target) && target.onGround()) {
            boolean inMeleeRange;
            boolean bl = inMeleeRange = (double)this.getStandardAttackReachSqr(target) >= ((AttackingAnimatedEntity)this.entity).distanceToSqr((Entity)target);
            if (inMeleeRange || !target.isCrouching()) {
                this.fling(attacker, target, true);
            }
        }
    }

    private void fling(PathfinderMob attacker, LivingEntity target, boolean doHurt) {
        if (doHurt) {
            double distanceModified = 1.2 / (Math.sqrt(attacker.distanceToSqr((Entity)target)) * 0.05) - 1.4;
            float damage = Math.min(Math.max((float)distanceModified, 0.2f), 10.0f);
            target.hurt(attacker.damageSources().mobAttack((LivingEntity)attacker), damage);
        }
        target.push((double)target.getRandom().nextFloat() - 0.5, 0.75, (double)target.getRandom().nextFloat() - 0.5);
    }
}

