/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.animation;

import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;

public record MobAnimation(Action action, int animationLength, boolean freezeMovement, boolean freezeSight) {
    public static final int LOOPING_ANIMATION = -1;
    public static final Action IDLE_ACTION = Action.IDLE;
    public static final MobAnimation DEFAULT_IDLE_ANIMATION = new MobAnimation(IDLE_ACTION, -1, false, false);

    public static double getAttributeAffectedSpeed(LivingEntity entity, @Nullable Holder<Attribute> speedModifyingAttribute) {
        if (speedModifyingAttribute == null) {
            return 1.0;
        }
        AttributeInstance attributeInstance = entity.getAttribute(speedModifyingAttribute);
        return attributeInstance == null ? 1.0 : attributeInstance.getValue();
    }

    public static boolean isEntityMovingHorizontally(Entity entity) {
        return entity.getDeltaMovement().horizontalDistanceSqr() > 0.0;
    }

    public static enum Action {
        IDLE,
        TALK,
        PANIC,
        RIGHT_PUNCH,
        LEFT_PUNCH,
        CLAW,
        BITE,
        KICK,
        SWING,
        MELEE,
        SLAM,
        SHOOT,
        SHOVE;


        public static Action fromInt(int ordinal) {
            if (0 <= ordinal && ordinal < Action.values().length) {
                return Action.values()[ordinal];
            }
            throw new IllegalArgumentException("Invalid ordinal of " + ordinal + " for action!");
        }
    }
}

