/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.animation;

import com.mraof.minestuck.entity.animation.MobAnimation;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;

public class PhasedMobAnimation {
    private final MobAnimation animation;
    private final int initiationStart;
    private final int contactStart;
    private final int recoveryStart;
    private final int recoveryEnd;
    @Nullable
    private final Holder<Attribute> speedModifyingAttribute;

    public PhasedMobAnimation(MobAnimation animation, int initiationStart, int contactStart, int recoveryStart, int recoveryEnd) {
        this(animation, initiationStart, contactStart, recoveryStart, recoveryEnd, (Holder<Attribute>)Attributes.ATTACK_SPEED);
    }

    public PhasedMobAnimation(MobAnimation animation, int initiationStart, int contactStart, int recoveryStart, int recoveryEnd, @Nullable Holder<Attribute> speedModifyingAttribute) {
        this.animation = animation;
        this.initiationStart = initiationStart;
        this.contactStart = contactStart;
        this.recoveryStart = recoveryStart;
        this.recoveryEnd = recoveryEnd;
        this.speedModifyingAttribute = speedModifyingAttribute;
    }

    @Nullable
    public Holder<Attribute> getSpeedModifyingAttribute() {
        return this.speedModifyingAttribute;
    }

    public Phases getCurrentPhase(PathfinderMob entity, int time, double speed) {
        if (time < this.getInitiationStartTime(speed)) {
            return Phases.ANTICIPATION;
        }
        if (time < this.getContactStartTime(speed)) {
            return Phases.INITIATION;
        }
        if (time < this.getRecoveryStartTime(speed)) {
            return Phases.CONTACT;
        }
        if (time < this.getTotalAnimationLength(speed)) {
            return Phases.RECOVERY;
        }
        return Phases.NEUTRAL;
    }

    public int getInitiationStartTime(double speed) {
        return (int)Math.round((double)this.initiationStart / speed);
    }

    public int getContactStartTime(double speed) {
        return (int)Math.round((double)this.contactStart / speed);
    }

    public int getRecoveryStartTime(double speed) {
        return (int)Math.round((double)this.recoveryStart / speed);
    }

    public MobAnimation getAnimation() {
        return this.animation;
    }

    public int getTotalAnimationLength(double speed) {
        return (int)Math.round((double)this.recoveryEnd / speed);
    }

    public <T extends PathfinderMob> void attemptPhaseChange(int time, T entity, double speed) {
        if (time == this.getInitiationStartTime(speed)) {
            ((Phases.Holder)entity).setAnimationPhase(Phases.INITIATION, this.animation.action());
        } else if (time == this.getContactStartTime(speed)) {
            ((Phases.Holder)entity).setAnimationPhase(Phases.CONTACT, this.animation.action());
        } else if (time == this.getRecoveryStartTime(speed)) {
            ((Phases.Holder)entity).setAnimationPhase(Phases.RECOVERY, this.animation.action());
        } else if (time >= this.getTotalAnimationLength(speed)) {
            ((Phases.Holder)entity).setAnimationPhase(Phases.NEUTRAL, this.animation.action());
        }
    }

    public static enum Phases {
        NEUTRAL,
        ANTICIPATION,
        INITIATION,
        CONTACT,
        RECOVERY;


        public static Phases nextPhase(Phases phaseIn) {
            return Phases.fromInt(phaseIn.ordinal() < Phases.values().length - 1 ? phaseIn.ordinal() + 1 : 0);
        }

        public static Phases fromInt(int ordinal) {
            if (0 <= ordinal && ordinal < Phases.values().length) {
                return Phases.values()[ordinal];
            }
            throw new IllegalArgumentException("Invalid ordinal of " + ordinal + " for phases!");
        }

        public static interface Holder {
            public Phases getPhase();

            public void setAnimationPhase(Phases var1, MobAnimation.Action var2);

            default public boolean isBeforeContact() {
                return this.getPhase().ordinal() < CONTACT.ordinal();
            }

            default public boolean isActive() {
                Phases state = this.getPhase();
                return state != NEUTRAL;
            }
        }
    }
}

