/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.carapacian;

import com.mraof.minestuck.entity.ai.attack.AttackByDistanceGoal;
import com.mraof.minestuck.entity.carapacian.CarapacianEntity;
import com.mraof.minestuck.entity.carapacian.EnumEntityKingdom;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class BishopEntity
extends CarapacianEntity
implements RangedAttackMob,
Enemy {
    int burnTime;

    protected BishopEntity(EntityType<? extends BishopEntity> type, EnumEntityKingdom kingdom, Level level) {
        super(type, kingdom, level);
        this.xpReward = 3;
    }

    public static BishopEntity createProspitian(EntityType<? extends BishopEntity> type, Level level) {
        return new BishopEntity(type, EnumEntityKingdom.PROSPITIAN, level);
    }

    public static BishopEntity createDersite(EntityType<? extends BishopEntity> type, Level level) {
        return new BishopEntity(type, EnumEntityKingdom.DERSITE, level);
    }

    public static AttributeSupplier.Builder bishopAttributes() {
        return CarapacianEntity.carapacianAttributes().add(Attributes.MAX_HEALTH, 40.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new AttackByDistanceGoal(this, 1.25f, 30, 64.0f));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableExtendedGoal((Mob)this, LivingEntity.class, 0, true, false, entity -> this.attackEntitySelector.isEntityApplicable((Entity)entity)));
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        double distanceX = target.getX() - this.getX();
        double distanceY = target.getBoundingBox().minY + (double)(target.getBbHeight() / 2.0f) - (this.getY() + (double)(this.getBbHeight() / 2.0f));
        double distanceZ = target.getZ() - this.getZ();
        LargeFireball fireball = new LargeFireball(this.level(), (LivingEntity)this, new Vec3(distanceX, distanceY, distanceZ), 1);
        double d8 = this.getBbHeight();
        Vec3 vec3 = this.getViewVector(1.0f);
        double x = (this.getBoundingBox().minX + this.getBoundingBox().maxX) / 2.0 + vec3.x * d8;
        double y = this.getY() + (double)(this.getBbHeight() / 2.0f);
        double z = (this.getBoundingBox().minZ + this.getBoundingBox().maxZ) / 2.0 + vec3.z * d8;
        fireball.setPos(x, y, z);
        this.level().addFreshEntity((Entity)fireball);
    }

    public int getAttackStrength(Entity par1Entity) {
        ItemStack var2 = this.getMainHandItem();
        int var3 = 0;
        return var3;
    }

    public boolean doHurtTarget(Entity par1Entity) {
        int damage = this.getAttackStrength(par1Entity);
        int knockback = 6;
        par1Entity.push((double)(-Mth.sin((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f), 0.1, (double)(Mth.cos((float)(this.getYRot() * (float)Math.PI / 180.0f)) * (float)knockback * 0.5f));
        return par1Entity.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)damage);
    }

    public boolean hurt(DamageSource par1DamageSource, float par2) {
        if (par1DamageSource.is(DamageTypeTags.IS_FIRE)) {
            this.burnTime = (int)((float)this.burnTime + par2);
            if (this.burnTime <= 3) {
                return false;
            }
        }
        return super.hurt(par1DamageSource, par2);
    }

    private static class NearestAttackableExtendedGoal
    extends NearestAttackableTargetGoal<LivingEntity> {
        NearestAttackableExtendedGoal(Mob goalOwnerIn, Class<LivingEntity> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn, @Nullable Predicate<LivingEntity> targetPredicate) {
            super(goalOwnerIn, targetClassIn, targetChanceIn, checkSight, nearbyOnlyIn, targetPredicate);
        }

        protected AABB getTargetSearchArea(double targetDistance) {
            return this.mob.getBoundingBox().inflate(targetDistance, 64.0, targetDistance);
        }
    }
}

