/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.carapacian;

import com.mraof.minestuck.entity.AnimatedPathfinderMob;
import com.mraof.minestuck.entity.EntityListFilter;
import com.mraof.minestuck.entity.ai.HurtByTargetAlliedGoal;
import com.mraof.minestuck.entity.carapacian.EnumEntityKingdom;
import com.mraof.minestuck.util.MSTags;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class CarapacianEntity
extends AnimatedPathfinderMob {
    private final EnumEntityKingdom kingdom;
    protected List<EntityType<?>> enemyTypes = new ArrayList();
    protected final TagKey<EntityType<?>> allyTag;
    protected EntityListFilter attackEntitySelector = new EntityListFilter(this.enemyTypes);

    public CarapacianEntity(EntityType<? extends CarapacianEntity> type, EnumEntityKingdom kingdom, Level level) {
        super(type, level);
        this.kingdom = kingdom;
        this.setEnemies();
        this.allyTag = kingdom == EnumEntityKingdom.PROSPITIAN ? MSTags.EntityTypes.PROSPITIAN_CARAPACIANS : MSTags.EntityTypes.DERSITE_CARAPACIANS;
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetAlliedGoal((Mob)this, this::isAlly));
        this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
    }

    public static AttributeSupplier.Builder carapacianAttributes() {
        return Mob.createMobAttributes().add(Attributes.FOLLOW_RANGE, 32.0);
    }

    private void setEnemies() {
        switch (this.getKingdom()) {
            case PROSPITIAN: {
                BuiltInRegistries.ENTITY_TYPE.getTag(MSTags.EntityTypes.DERSITE_CARAPACIANS).ifPresent(set -> this.enemyTypes.addAll(set.stream().map(Holder::value).toList()));
                break;
            }
            case DERSITE: {
                BuiltInRegistries.ENTITY_TYPE.getTag(MSTags.EntityTypes.PROSPITIAN_CARAPACIANS).ifPresent(set -> this.enemyTypes.addAll(set.stream().map(Holder::value).toList()));
            }
        }
    }

    public void addEnemy(EntityType<?> enemyType) {
        if (this.canAttackType(enemyType) && !this.enemyTypes.contains(enemyType)) {
            this.enemyTypes.add(enemyType);
        }
    }

    public void setTarget(LivingEntity entity) {
        super.setTarget(entity);
        if (entity != null) {
            this.addEnemy(entity.getType());
        }
    }

    public boolean canAttackType(EntityType<?> typeIn) {
        return !typeIn.is(this.allyTag);
    }

    public EnumEntityKingdom getKingdom() {
        return Objects.requireNonNull(this.kingdom);
    }

    public boolean isAlly(Entity entity) {
        return entity.getType().is(this.allyTag);
    }
}

