/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.carapacian;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.ai.attack.MoveToTargetGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.entity.carapacian.CarapacianEntity;
import com.mraof.minestuck.entity.carapacian.EnumEntityKingdom;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.item.MSItems;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RangedAttackGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
public class PawnEntity
extends CarapacianEntity
implements RangedAttackMob,
Enemy,
GeoEntity,
PhasedMobAnimation.Phases.Holder,
DialogueEntity {
    private static final EntityDataAccessor<Integer> CURRENT_ACTION = SynchedEntityData.defineId(PawnEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final MobAnimation TALK_PROPERTIES = new MobAnimation(MobAnimation.Action.TALK, 80, true, false);
    private static final double ATTACK_ANIMATION_SPEED = 2.0;
    public static final PhasedMobAnimation MELEE_ANIMATION = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.MELEE, 18, true, false), 3, 5, 7, 13);
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation ARMS_WALKING_ANIMATION = RawAnimation.begin().thenLoop("walkarms");
    private static final RawAnimation PUNCH_ANIMATION_1 = RawAnimation.begin().then("punch1", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation DIE_ANIMATION = RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation TALK_ANIMATION = RawAnimation.begin().thenLoop("talk");
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final RangedAttackGoal aiArrowAttack = new RangedAttackGoal((RangedAttackMob)this, 1.25, 20, 10.0f);
    private final MeleeAttackGoal aiMeleeAttack = new MeleeAttackGoal((PathfinderMob)this, 2.0, false);
    private int ticksUntilDialogueReset = 0;
    private final DialogueComponent dialogueComponent = new DialogueComponent((LivingEntity)this);

    protected PawnEntity(EntityType<? extends PawnEntity> type, EnumEntityKingdom kingdom, Level level) {
        super(type, kingdom, level);
        this.xpReward = 1;
        this.setCombatTask();
    }

    public static PawnEntity createProspitian(EntityType<? extends PawnEntity> type, Level level) {
        return new PawnEntity(type, EnumEntityKingdom.PROSPITIAN, level);
    }

    public static PawnEntity createDersite(EntityType<? extends PawnEntity> type, Level level) {
        return new PawnEntity(type, EnumEntityKingdom.DERSITE, level);
    }

    public static AttributeSupplier.Builder pawnAttributes() {
        return CarapacianEntity.carapacianAttributes().add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_SPEED, 4.0).add(Attributes.MOVEMENT_SPEED, 0.2);
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<PawnEntity>(this, MELEE_ANIMATION));
        this.goalSelector.addGoal(3, (Goal)new MoveToTargetGoal(this, 1.0f, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, entity -> this.attackEntitySelector.isEntityApplicable((Entity)entity)));
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(CURRENT_ACTION, (Object)MobAnimation.IDLE_ACTION.ordinal());
    }

    @Override
    public PhasedMobAnimation.Phases getPhase() {
        return PhasedMobAnimation.Phases.values()[(Integer)this.entityData.get(CURRENT_ACTION)];
    }

    @Override
    public void setAnimationPhase(PhasedMobAnimation.Phases phase, MobAnimation.Action action) {
        this.entityData.set(CURRENT_ACTION, (Object)phase.ordinal());
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean isInCombat = this.goalSelector.getAvailableGoals().stream().filter(WrappedGoal::isRunning).anyMatch(goal -> goal.getGoal() instanceof MoveToTargetGoal || goal.getGoal() instanceof AnimatedAttackWhenInRangeGoal);
        if (!this.isAlive() || player.isShiftKeyDown() || isInCombat) {
            return InteractionResult.PASS;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.dialogueComponent.hasAnyOngoingDialogue()) {
            return InteractionResult.FAIL;
        }
        this.setCurrentAnimation(TALK_PROPERTIES);
        if (!this.dialogueComponent.hasActiveDialogue()) {
            this.dialogueComponent.resetDialogue();
            RandomlySelectableDialogue.instance(RandomlySelectableDialogue.DialogueCategory.CARAPACIAN_SOLDIER).pickRandomForEntity((LivingEntity)this).ifPresent(this.dialogueComponent::setDialogue);
        }
        this.dialogueComponent.tryStartDialogue(serverPlayer);
        this.dialogueComponent.getStartingDialogue().ifPresent(dialogueId -> {
            if (this.ticksUntilDialogueReset == 0) {
                this.ticksUntilDialogueReset = 24000 + this.level().random.nextInt(24000);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private void clearDialogueData() {
        this.ticksUntilDialogueReset = 0;
        this.dialogueComponent.resetDialogue();
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            return;
        }
        if (this.ticksUntilDialogueReset > 0) {
            this.ticksUntilDialogueReset -= ((Integer)MinestuckConfig.SERVER.dialogueRenewalSpeed.get()).intValue();
            if (this.ticksUntilDialogueReset <= 0) {
                this.clearDialogueData();
            }
        }
        this.dialogueComponent.closeDialogueForMovingPlayers();
    }

    protected void populateDefaultEquipmentSlots(RandomSource random, DifficultyInstance difficulty) {
        super.populateDefaultEquipmentSlots(random, difficulty);
        this.setItemSlot(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)(random.nextDouble() < 0.25 ? Items.BOW : (random.nextDouble() < 0.2 ? (ItemLike)MSItems.REGISWORD.get() : (random.nextDouble() < 0.02 ? (ItemLike)MSItems.SORD.get() : Items.STONE_SWORD)))));
    }

    public void performRangedAttack(LivingEntity target, float distanceFactor) {
        Arrow arrow = new Arrow(this.level(), (LivingEntity)this, new ItemStack((ItemLike)Items.ARROW), this.getWeaponItem());
        double d0 = target.getX() - this.getX();
        double d1 = target.getBoundingBox().minY + (double)(target.getBbHeight() / 3.0f) - arrow.getY();
        double d2 = target.getZ() - this.getZ();
        double d3 = Math.sqrt(d0 * d0 + d2 * d2);
        arrow.shoot(d0, d1 + d3 * 0.2, d2, 1.6f, 12.0f);
        this.playSound(SoundEvents.SKELETON_SHOOT, 1.0f, 1.0f / (this.getRandom().nextFloat() * 0.4f + 0.8f));
        this.level().addFreshEntity((Entity)arrow);
    }

    private void setCombatTask() {
        if (this.level() != null && !this.level().isClientSide) {
            this.goalSelector.removeGoal((Goal)this.aiArrowAttack);
            this.goalSelector.removeGoal((Goal)this.aiMeleeAttack);
            ItemStack weapon = this.getMainHandItem();
            if (!weapon.isEmpty() && weapon.getItem() == Items.BOW) {
                this.goalSelector.addGoal(4, (Goal)this.aiArrowAttack);
            } else {
                this.goalSelector.addGoal(4, (Goal)this.aiMeleeAttack);
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("dialogue", (Tag)this.dialogueComponent.write());
        compound.putInt("dialogue_reset_ticks", this.ticksUntilDialogueReset);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.dialogueComponent.read(compound.getCompound("dialogue"));
        this.ticksUntilDialogueReset = compound.getInt("dialogue_reset_ticks");
        this.setCombatTask();
    }

    public void setItemSlot(EquipmentSlot slotIn, ItemStack stack) {
        super.setItemSlot(slotIn, stack);
        if (!this.level().isClientSide) {
            this.setCombatTask();
        }
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        spawnDataIn = super.finalizeSpawn(level, difficultyIn, reason, spawnDataIn);
        this.populateDefaultEquipmentSlots(level.getRandom(), difficultyIn);
        this.populateDefaultEquipmentEnchantments(level, level.getRandom(), difficultyIn);
        this.setCombatTask();
        return spawnDataIn;
    }

    @Override
    public DialogueComponent getDialogueComponent() {
        return this.dialogueComponent;
    }

    @Override
    public ChatFormatting getChatColor() {
        return ChatFormatting.BLACK;
    }

    @Override
    public String getSpriteType() {
        String color = this.getKingdom() == EnumEntityKingdom.PROSPITIAN ? "white" : "black";
        return color + "_pawn";
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkArmsAnimation", PawnEntity::walkArmsAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkAnimation", PawnEntity::walkAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 5.0));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathAnimation", PawnEntity::deathAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "swingAnimation", PawnEntity::swingAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "talkAnimation", PawnEntity::talkAnimation));
    }

    private static PlayState walkAnimation(AnimationState<PawnEntity> state) {
        if (MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable())) {
            state.getController().setAnimation(WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState walkArmsAnimation(AnimationState<PawnEntity> state) {
        if (MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable()) && !((PawnEntity)state.getAnimatable()).isActive()) {
            state.getController().setAnimation(ARMS_WALKING_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState deathAnimation(AnimationState<PawnEntity> state) {
        if (((PawnEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState swingAnimation(AnimationState<PawnEntity> event) {
        if (((PawnEntity)event.getAnimatable()).isActive()) {
            event.getController().setAnimation(PUNCH_ANIMATION_1);
            return PlayState.CONTINUE;
        }
        event.getController().forceAnimationReset();
        event.getController().setAnimationSpeed(MobAnimation.getAttributeAffectedSpeed((LivingEntity)event.getAnimatable(), (Holder<Attribute>)Attributes.ATTACK_SPEED));
        return PlayState.STOP;
    }

    private static PlayState talkAnimation(AnimationState<PawnEntity> state) {
        MobAnimation.Action action = ((PawnEntity)state.getAnimatable()).getCurrentAction();
        if (action == MobAnimation.Action.TALK) {
            state.getController().setAnimation(TALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }
}

