/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.carapacian;

import com.mraof.minestuck.entity.carapacian.CarapacianEntity;
import com.mraof.minestuck.entity.carapacian.EnumEntityKingdom;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.Level;

public class RookEntity
extends CarapacianEntity
implements Enemy {
    protected RookEntity(EntityType<? extends RookEntity> type, EnumEntityKingdom kingdom, Level level) {
        super(type, kingdom, level);
        this.xpReward = 10;
    }

    public static RookEntity createProspitian(EntityType<? extends RookEntity> type, Level level) {
        return new RookEntity(type, EnumEntityKingdom.PROSPITIAN, level);
    }

    public static RookEntity createDersite(EntityType<? extends RookEntity> type, Level level) {
        return new RookEntity(type, EnumEntityKingdom.DERSITE, level);
    }

    public static AttributeSupplier.Builder rookAttributes() {
        return CarapacianEntity.carapacianAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.MOVEMENT_SPEED, 0.3);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3333333730697632, false));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 0, true, false, entity -> this.attackEntitySelector.isEntityApplicable((Entity)entity)));
    }

    public float getAttackStrength(Entity entity) {
        return 5.0f;
    }

    public boolean doHurtTarget(Entity entity) {
        float damage = this.getAttackStrength(entity);
        return entity.hurt(this.damageSources().mobAttack((LivingEntity)this), damage);
    }
}

