/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.consort;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.entity.AnimatedPathfinderMob;
import com.mraof.minestuck.entity.ai.AnimatedPanicGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.consort.ConsortReputation;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.inventory.ConsortMerchantInventory;
import com.mraof.minestuck.inventory.ConsortMerchantMenu;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.world.MSDimensions;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.slf4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class ConsortEntity
extends AnimatedPathfinderMob
implements MenuProvider,
GeoEntity,
DialogueEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final MobAnimation TALK_PROPERTIES = new MobAnimation(MobAnimation.Action.TALK, 80, true, false);
    private static final MobAnimation PANIC_PROPERTIES = new MobAnimation(MobAnimation.Action.PANIC, -1, false, false);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation ARMS_WALKING_ANIMATION = RawAnimation.begin().thenLoop("walkarms");
    private static final RawAnimation JUMP_ANIMATION = RawAnimation.begin().then("jump", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation PANIC_ANIMATION = RawAnimation.begin().thenLoop("panicrun");
    private static final RawAnimation TALK_ANIMATION = RawAnimation.begin().thenLoop("talk");
    private static final RawAnimation DIE_ANIMATION = RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final DialogueComponent dialogueComponent = new DialogueComponent((LivingEntity)this);
    private final EnumConsort consortType;
    private int ticksUntilDialogueReset = 0;
    private final Set<PlayerIdentifier> talkRepPlayerList = new HashSet<PlayerIdentifier>();
    public EnumConsort.MerchantType merchantType = EnumConsort.MerchantType.NONE;
    ResourceKey<Level> homeDimension;
    private boolean visitedSkaia;
    public ConsortMerchantInventory stocks;
    private int eventTimer = -1;

    public ConsortEntity(EnumConsort consortType, EntityType<? extends ConsortEntity> type, Level level) {
        super(type, level);
        this.consortType = consortType;
        this.xpReward = 1;
    }

    public static AttributeSupplier.Builder consortAttributes() {
        return Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 10.0).add(Attributes.MOVEMENT_SPEED, 0.35);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new AnimatedPanicGoal(this, 1.4, PANIC_PROPERTIES));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 1.0));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new AvoidEntityGoal((PathfinderMob)this, Player.class, 16.0f, 1.0, 1.4, this::shouldFleeFrom));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean shouldFleeFrom(LivingEntity entity) {
        if (!(entity instanceof ServerPlayer)) return false;
        ServerPlayer player = (ServerPlayer)entity;
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(entity)) return false;
        if (ConsortReputation.get(player).getConsortReputation(this.homeDimension) > -1000) return false;
        return true;
    }

    protected void applyAdditionalAITasks() {
        if (!this.hasRestriction() || this.getRestrictRadius() > 1.0f) {
            this.goalSelector.addGoal(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.5));
        }
    }

    public boolean isWithinRestriction() {
        return this.homeDimension != this.level().dimension() || super.isWithinRestriction();
    }

    protected InteractionResult mobInteract(Player player, InteractionHand hand) {
        if (!this.isAlive() || player.isShiftKeyDown()) {
            return InteractionResult.PASS;
        }
        if (this.eventTimer >= 0) {
            return InteractionResult.FAIL;
        }
        if (!(player instanceof ServerPlayer)) {
            return InteractionResult.SUCCESS;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        if (this.dialogueComponent.hasAnyOngoingDialogue()) {
            return InteractionResult.FAIL;
        }
        Optional<PlayerData> playerData = PlayerData.get(serverPlayer);
        if (playerData.isEmpty() || ConsortReputation.get(playerData.get()).getConsortReputation(this.homeDimension) <= -1000) {
            return InteractionResult.FAIL;
        }
        this.handleConsortRepFromTalking(serverPlayer);
        this.setCurrentAnimation(TALK_PROPERTIES);
        if (!this.dialogueComponent.hasActiveDialogue()) {
            this.dialogueComponent.resetDialogue();
            RandomlySelectableDialogue.instance(this.merchantType.dialogueCategory()).pickRandomForEntity((LivingEntity)this).ifPresent(this.dialogueComponent::setDialogue);
        }
        this.dialogueComponent.tryStartDialogue(serverPlayer);
        this.dialogueComponent.getStartingDialogue().ifPresent(dialogueId -> {
            MSCriteriaTriggers.CONSORT_TALK.get().trigger(serverPlayer, dialogueId.toString(), this);
            if (this.ticksUntilDialogueReset == 0) {
                this.ticksUntilDialogueReset = 24000 + this.level().random.nextInt(24000);
            }
        });
        return InteractionResult.SUCCESS;
    }

    private void clearDialogueData() {
        this.ticksUntilDialogueReset = 0;
        this.stocks = null;
        this.dialogueComponent.resetDialogue();
        this.talkRepPlayerList.clear();
    }

    private void handleConsortRepFromTalking(ServerPlayer player) {
        PlayerIdentifier identifier = IdentifierHandler.encode((Player)player);
        if (!this.talkRepPlayerList.contains(identifier)) {
            ConsortReputation.get(player).addConsortReputation(1, this.homeDimension);
            this.talkRepPlayerList.add(identifier);
        }
    }

    public void setExplosionTimer() {
        if (this.eventTimer == -1) {
            this.eventTimer = 20;
        }
    }

    public boolean hurt(DamageSource source, float amount) {
        boolean wasHurt = super.hurt(source, amount);
        if (wasHurt) {
            this.dialogueComponent.closeAllCurrentDialogue();
        }
        return wasHurt;
    }

    public void aiStep() {
        super.aiStep();
        if (this.level().isClientSide) {
            return;
        }
        if (this.ticksUntilDialogueReset > 0) {
            this.ticksUntilDialogueReset -= ((Integer)MinestuckConfig.SERVER.dialogueRenewalSpeed.get()).intValue();
            if (this.ticksUntilDialogueReset <= 0) {
                this.clearDialogueData();
            }
        }
        this.dialogueComponent.closeDialogueForMovingPlayers();
        if (MSDimensions.isSkaia((ResourceKey<Level>)this.level().dimension())) {
            this.visitedSkaia = true;
        }
        if (this.eventTimer > 0) {
            --this.eventTimer;
        } else if (this.eventTimer == 0) {
            this.explode();
        }
    }

    private void explode() {
        if (!this.level().isClientSide) {
            this.dead = true;
            float explosionRadius = 2.0f;
            this.level().explode((Entity)this, this.getX(), this.getY(), this.getZ(), explosionRadius, Level.ExplosionInteraction.MOB);
            this.discard();
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.put("dialogue", (Tag)this.dialogueComponent.write());
        compound.putInt("dialogue_reset_ticks", this.ticksUntilDialogueReset);
        ListTag list = new ListTag();
        for (PlayerIdentifier id : this.talkRepPlayerList) {
            list.add((Object)id.saveToNBT(new CompoundTag(), "id"));
        }
        compound.put("talkRepList", (Tag)list);
        compound.putInt("Type", this.merchantType.ordinal());
        ResourceLocation.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)this.homeDimension.location()).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(tag -> compound.put("HomeDim", tag));
        if (this.merchantType != EnumConsort.MerchantType.NONE && this.stocks != null) {
            compound.put("Stock", (Tag)this.stocks.writeToNBT());
        }
        if (this.hasRestriction()) {
            CompoundTag nbt = new CompoundTag();
            BlockPos home = this.getRestrictCenter();
            nbt.putInt("HomeX", home.getX());
            nbt.putInt("HomeY", home.getY());
            nbt.putInt("HomeZ", home.getZ());
            nbt.putInt("MaxHomeDistance", (int)this.getRestrictRadius());
            compound.put("HomePos", (Tag)nbt);
        }
        compound.putBoolean("Skaia", this.visitedSkaia);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.dialogueComponent.read(compound.getCompound("dialogue"));
        this.ticksUntilDialogueReset = compound.getInt("dialogue_reset_ticks");
        this.talkRepPlayerList.clear();
        ListTag list = compound.getList("talkRepList", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.talkRepPlayerList.add((PlayerIdentifier)IdentifierHandler.load(list.getCompound(i), "id").getOrThrow());
        }
        this.merchantType = EnumConsort.MerchantType.values()[Mth.clamp((int)compound.getInt("Type"), (int)0, (int)(EnumConsort.MerchantType.values().length - 1))];
        if (compound.contains("HomeDim", 8)) {
            this.homeDimension = Level.RESOURCE_KEY_CODEC.parse((DynamicOps)NbtOps.INSTANCE, (Object)compound.get("HomeDim")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
        }
        if (this.homeDimension == null) {
            this.homeDimension = this.level().dimension();
        }
        if (this.merchantType != EnumConsort.MerchantType.NONE && compound.contains("Stock", 9)) {
            this.stocks = new ConsortMerchantInventory(this, compound.getList("Stock", 10));
        }
        if (compound.contains("HomePos", 10)) {
            CompoundTag nbt = compound.getCompound("HomePos");
            BlockPos pos = new BlockPos(nbt.getInt("HomeX"), nbt.getInt("HomeY"), nbt.getInt("HomeZ"));
            this.restrictTo(pos, nbt.getInt("MaxHomeDistance"));
        }
        this.visitedSkaia = compound.getBoolean("Skaia");
        this.applyAdditionalAITasks();
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (this.merchantType == EnumConsort.MerchantType.NONE && this.random.nextInt(30) == 0) {
            this.merchantType = EnumConsort.MerchantType.SHADY;
            if (this.hasRestriction()) {
                this.restrictTo(this.getRestrictCenter(), (int)(this.getRestrictRadius() * 0.4f));
            }
        }
        this.homeDimension = this.level().dimension();
        this.visitedSkaia = this.random.nextFloat() < 0.1f;
        this.applyAdditionalAITasks();
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public boolean skipAttackInteraction(Entity entityIn) {
        if (!(entityIn instanceof FakePlayer) && entityIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityIn;
            ConsortReputation.get(player).addConsortReputation(-5, this.homeDimension);
        }
        return super.skipAttackInteraction(entityIn);
    }

    public void die(DamageSource cause) {
        ServerPlayer player;
        LivingEntity livingEntity = this.getKillCredit();
        if (livingEntity instanceof ServerPlayer && !((player = (ServerPlayer)livingEntity) instanceof FakePlayer)) {
            ConsortReputation.get(player).addConsortReputation(-100, this.homeDimension);
        }
        super.die(cause);
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public EnumConsort getConsortType() {
        return this.consortType;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int windowId, Inventory playerInventory, Player player) {
        if (this.stocks != null) {
            return new ConsortMerchantMenu(windowId, playerInventory, this.stocks, this.getConsortType(), this.merchantType, this.stocks.createPricesFor((ServerPlayer)player));
        }
        return null;
    }

    public void writeShopMenuBuffer(FriendlyByteBuf buffer) {
        ConsortMerchantMenu.write(buffer, this);
    }

    @Nullable
    protected SoundEvent getAmbientSound() {
        return this.consortType.getAmbientSound();
    }

    @Nullable
    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return this.consortType.getHurtSound();
    }

    @Nullable
    protected SoundEvent getDeathSound() {
        return this.consortType.getDeathSound();
    }

    public ResourceKey<Level> getHomeDimension() {
        return this.homeDimension;
    }

    public boolean visitedSkaia() {
        return this.visitedSkaia;
    }

    public static boolean canConsortSpawnOn(EntityType<ConsortEntity> entityType, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return true;
    }

    @Override
    public DialogueComponent getDialogueComponent() {
        return this.dialogueComponent;
    }

    @Override
    public ChatFormatting getChatColor() {
        return this.getConsortType().getColor();
    }

    @Override
    public String getSpriteType() {
        return this.getConsortType().getName();
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idleAnimation", ConsortEntity::idleAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkAnimation", ConsortEntity::walkAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "armsAnimation", ConsortEntity::armsAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathAnimation", ConsortEntity::deathAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "actionAnimation", ConsortEntity::actionAnimation));
    }

    private static PlayState idleAnimation(AnimationState<ConsortEntity> state) {
        if (state.isMoving() || ((ConsortEntity)state.getAnimatable()).getCurrentAction() != MobAnimation.Action.IDLE) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    private static PlayState walkAnimation(AnimationState<ConsortEntity> state) {
        MobAnimation.Action action = ((ConsortEntity)state.getAnimatable()).getCurrentAction();
        if (!state.isMoving()) {
            return PlayState.STOP;
        }
        if (action == MobAnimation.Action.PANIC) {
            state.getController().setAnimation(PANIC_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (action != MobAnimation.Action.IDLE) {
            return PlayState.STOP;
        }
        if (((ConsortEntity)state.getAnimatable()).jumping) {
            state.getController().setAnimation(JUMP_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().setAnimation(WALK_ANIMATION);
        return PlayState.CONTINUE;
    }

    private static PlayState armsAnimation(AnimationState<ConsortEntity> state) {
        if (!state.isMoving() || ((ConsortEntity)state.getAnimatable()).getCurrentAction() != MobAnimation.Action.IDLE) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(ARMS_WALKING_ANIMATION);
        return PlayState.CONTINUE;
    }

    private static PlayState deathAnimation(AnimationState<ConsortEntity> state) {
        if (((ConsortEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState actionAnimation(AnimationState<ConsortEntity> state) {
        MobAnimation.Action action = ((ConsortEntity)state.getAnimatable()).getCurrentAction();
        if (action == MobAnimation.Action.TALK) {
            state.getController().setAnimation(TALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }
}

