/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.consort;

import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.util.MSAttachments;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.INBTSerializable;

@ParametersAreNonnullByDefault
public final class ConsortReputation
implements INBTSerializable<ListTag> {
    private final Map<ResourceLocation, Integer> consortReputation = new HashMap<ResourceLocation, Integer>();

    public int getConsortReputation(ResourceKey<Level> dim) {
        return this.consortReputation.getOrDefault(dim.location(), 0);
    }

    public void addConsortReputation(int amount, ResourceKey<Level> dim) {
        int oldRep = this.getConsortReputation(dim);
        int newRep = Mth.clamp((int)(oldRep + amount), (int)-10000, (int)10000);
        if (newRep != oldRep) {
            this.consortReputation.put(dim.location(), newRep);
        }
    }

    public ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (Map.Entry<ResourceLocation, Integer> entry : this.consortReputation.entrySet()) {
            CompoundTag dimensionRep = new CompoundTag();
            dimensionRep.putString("dim", entry.getKey().toString());
            dimensionRep.putInt("rep", entry.getValue().intValue());
            list.add((Object)dimensionRep);
        }
        return list;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag list) {
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag dimensionRep = list.getCompound(i);
            ResourceLocation dimension = ResourceLocation.tryParse((String)dimensionRep.getString("dim"));
            if (dimension == null) continue;
            this.consortReputation.put(dimension, dimensionRep.getInt("rep"));
        }
    }

    public static ConsortReputation get(ServerPlayer player) {
        return ConsortReputation.get(PlayerData.get(player).orElseThrow());
    }

    public static ConsortReputation get(PlayerData playerData) {
        return (ConsortReputation)playerData.getData(MSAttachments.CONSORT_REPUTATION);
    }
}

