/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.consort;

import com.mraof.minestuck.entity.consort.BoondollarPrices;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ConsortRewardHandler {
    private static final Logger LOGGER = LogManager.getLogger();

    public static List<Pair<ItemStack, Integer>> generateStock(ResourceKey<LootTable> lootTable, ConsortEntity consort, RandomSource rand) {
        LootParams.Builder contextBuilder = new LootParams.Builder((ServerLevel)consort.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)consort).withParameter(LootContextParams.ORIGIN, (Object)consort.position());
        ObjectArrayList itemStacks = Objects.requireNonNull(consort.getServer()).reloadableRegistries().getLootTable(lootTable).getRandomItems(contextBuilder.create(LootContextParamSets.GIFT));
        ArrayList<Pair<ItemStack, Integer>> itemPriceList = new ArrayList<Pair<ItemStack, Integer>>();
        block0: for (ItemStack stack : itemStacks) {
            for (Pair pair : itemPriceList) {
                if (!ItemStack.isSameItemSameComponents((ItemStack)((ItemStack)pair.getKey()), (ItemStack)stack)) continue;
                ((ItemStack)pair.getKey()).grow(stack.getCount());
                continue block0;
            }
            Optional<Integer> price = BoondollarPrices.getInstance().findPrice(stack, rand);
            if (price.isPresent() && itemPriceList.size() < 9) {
                itemPriceList.add((Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)price.get()));
            }
            if (price.isPresent()) continue;
            LOGGER.warn("Couldn't find a boondollar price for {}", (Object)stack);
        }
        return itemPriceList;
    }
}

