/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.consort;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.dialogue.RandomlySelectableDialogue;
import com.mraof.minestuck.util.MSSoundEvents;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public enum EnumConsort implements StringRepresentable
{
    SALAMANDER(MSEntityTypes.SALAMANDER, "salamander", ChatFormatting.YELLOW, MSSoundEvents.ENTITY_SALAMANDER_AMBIENT, MSSoundEvents.ENTITY_SALAMANDER_HURT, MSSoundEvents.ENTITY_SALAMANDER_DEATH),
    TURTLE(MSEntityTypes.TURTLE, "turtle", ChatFormatting.LIGHT_PURPLE, () -> null, MSSoundEvents.ENTITY_TURTLE_HURT, MSSoundEvents.ENTITY_TURTLE_DEATH),
    NAKAGATOR(MSEntityTypes.NAKAGATOR, "nakagator", ChatFormatting.RED, MSSoundEvents.ENTITY_NAKAGATOR_AMBIENT, MSSoundEvents.ENTITY_NAKAGATOR_HURT, MSSoundEvents.ENTITY_NAKAGATOR_DEATH),
    IGUANA(MSEntityTypes.IGUANA, "iguana", ChatFormatting.AQUA, MSSoundEvents.ENTITY_IGUANA_AMBIENT, MSSoundEvents.ENTITY_IGUANA_HURT, MSSoundEvents.ENTITY_IGUANA_DEATH);

    public static final Codec<EnumConsort> CODEC;
    public static final Codec<List<EnumConsort>> SINGLE_OR_LIST_CODEC;
    private final Supplier<? extends EntityType<? extends ConsortEntity>> consortType;
    private final String name;
    private final ChatFormatting color;
    private final Supplier<SoundEvent> ambientSound;
    private final Supplier<SoundEvent> hurtSound;
    private final Supplier<SoundEvent> deathSound;

    private EnumConsort(Supplier<? extends EntityType<? extends ConsortEntity>> consort, String name, ChatFormatting color, Supplier<SoundEvent> ambientSound, Supplier<SoundEvent> hurtSound, Supplier<SoundEvent> deathSound) {
        this.consortType = consort;
        this.color = color;
        this.name = name;
        this.ambientSound = ambientSound;
        this.hurtSound = hurtSound;
        this.deathSound = deathSound;
    }

    public boolean isConsort(Entity consort) {
        return this.consortType.get().equals((Object)consort.getType());
    }

    public ChatFormatting getColor() {
        return this.color;
    }

    public String getName() {
        return this.name;
    }

    public EntityType<? extends ConsortEntity> getConsortType() {
        return this.consortType.get();
    }

    public SoundEvent getAmbientSound() {
        return this.ambientSound.get();
    }

    public SoundEvent getHurtSound() {
        return this.hurtSound.get();
    }

    public SoundEvent getDeathSound() {
        return this.deathSound.get();
    }

    public ConsortEntity create(EntityType<? extends ConsortEntity> type, Level level) {
        return new ConsortEntity(this, type, level);
    }

    public static MerchantType getRandomMerchant(RandomSource rand) {
        float f = rand.nextFloat();
        if (f < 0.4f) {
            return MerchantType.FOOD;
        }
        return MerchantType.GENERAL;
    }

    public static EnumConsort getFromName(String str) {
        for (EnumConsort type : EnumConsort.values()) {
            if (!type.getName().equals(str)) continue;
            return type;
        }
        throw new IllegalArgumentException("Invalid consort type " + str);
    }

    public String getSerializedName() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.fromEnum(EnumConsort::values);
        SINGLE_OR_LIST_CODEC = Codec.either(CODEC, (Codec)CODEC.listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), list -> list.size() == 1 ? Either.left((Object)((Object)((EnumConsort)((Object)((Object)list.getFirst()))))) : Either.right((Object)list));
    }

    public static enum MerchantType implements StringRepresentable
    {
        NONE(RandomlySelectableDialogue.DialogueCategory.CONSORT),
        SHADY(RandomlySelectableDialogue.DialogueCategory.SHADY_CONSORT),
        FOOD(RandomlySelectableDialogue.DialogueCategory.CONSORT_FOOD_MERCHANT),
        GENERAL(RandomlySelectableDialogue.DialogueCategory.CONSORT_GENERAL_MERCHANT);

        public static final Codec<MerchantType> CODEC;
        private final RandomlySelectableDialogue.DialogueCategory category;

        private MerchantType(RandomlySelectableDialogue.DialogueCategory category) {
            this.category = category;
        }

        public RandomlySelectableDialogue.DialogueCategory dialogueCategory() {
            return this.category;
        }

        public static MerchantType getFromName(String str) {
            for (MerchantType type : MerchantType.values()) {
                if (!type.name().toLowerCase().equals(str)) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid merchant type " + str);
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(MerchantType::values);
        }
    }
}

