/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.dialogue.DialogueAnimationData;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.DialogueMessage;
import com.mraof.minestuck.entity.dialogue.Trigger;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;

public final class Dialogue {
    public static final String DIALOGUE_FORMAT = "minestuck.dialogue.format";
    public static final ResourceLocation DEFAULT_GUI = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/dialogue/dialogue.png");

    public record ConditionFailure(Component causes) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ConditionFailure> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, ConditionFailure::causes, ConditionFailure::new);
    }

    public record ResponseData(Component message, boolean shouldClose, int index, Optional<ConditionFailure> conditionFailure) {
        public static final StreamCodec<RegistryFriendlyByteBuf, ResponseData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC, ResponseData::message, (StreamCodec)ByteBufCodecs.BOOL, ResponseData::shouldClose, (StreamCodec)ByteBufCodecs.INT, ResponseData::index, (StreamCodec)ByteBufCodecs.optional(ConditionFailure.STREAM_CODEC), ResponseData::conditionFailure, ResponseData::new);
    }

    public record DialogueData(List<Component> messages, ResourceLocation guiBackground, List<ResponseData> responses, DialogueAnimationData animationData, String spriteType) {
        public static StreamCodec<RegistryFriendlyByteBuf, DialogueData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ComponentSerialization.STREAM_CODEC.apply(ByteBufCodecs.list()), DialogueData::messages, (StreamCodec)ResourceLocation.STREAM_CODEC, DialogueData::guiBackground, (StreamCodec)ResponseData.STREAM_CODEC.apply(ByteBufCodecs.list()), DialogueData::responses, DialogueAnimationData.STREAM_CODEC, DialogueData::animationData, (StreamCodec)ByteBufCodecs.STRING_UTF8, DialogueData::spriteType, DialogueData::new);
    }

    public record SelectableDialogue(ResourceLocation dialogueId, Condition condition, int weight, boolean keepOnReset) {
        public static final int DEFAULT_WEIGHT = 10;
        public static Codec<SelectableDialogue> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dialogue").forGetter(SelectableDialogue::dialogueId), (App)Condition.NPC_ONLY_CODEC.fieldOf("condition").forGetter(SelectableDialogue::condition), (App)Codec.INT.fieldOf("dialogue_weight").orElse((Object)10).forGetter(SelectableDialogue::weight), (App)Codec.BOOL.fieldOf("keep_on_reset").orElse((Object)false).forGetter(SelectableDialogue::keepOnReset)).apply((Applicative)instance, SelectableDialogue::new));
    }

    public record NextDialogue(ResourceLocation id, boolean setAsEntrypoint, List<Pair<MessageType, DialogueMessage>> replyMessages) {
        private static final MapCodec<List<Pair<MessageType, DialogueMessage>>> MESSAGES_MAP_CODEC = Codec.mapEither((MapCodec)DialogueMessage.CODEC.fieldOf("player_message"), (MapCodec)Node.MESSAGE_CODEC.listOf().fieldOf("reply_messages")).xmap(either -> (List)either.map(message -> List.of(Pair.of((Object)((Object)MessageType.PLAYER), (Object)message)), Function.identity()), messages -> messages.size() == 1 && ((Pair)messages.get(0)).getFirst() == MessageType.PLAYER ? Either.left((Object)((DialogueMessage)((Pair)messages.get(0)).getSecond())) : Either.right((Object)messages));
        public static final Codec<NextDialogue> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(NextDialogue::id), (App)Codec.BOOL.fieldOf("set_as_entrypoint").forGetter(NextDialogue::setAsEntrypoint), (App)MESSAGES_MAP_CODEC.forGetter(NextDialogue::replyMessages)).apply((Applicative)instance, NextDialogue::new));
        public static final Codec<NextDialogue> EITHER_CODEC = Codec.either((Codec)ResourceLocation.CODEC, DIRECT_CODEC).xmap(either -> (NextDialogue)either.map(id -> new NextDialogue((ResourceLocation)id, false, List.of()), Function.identity()), nextDialogue -> !nextDialogue.setAsEntrypoint && nextDialogue.replyMessages.isEmpty() ? Either.left((Object)nextDialogue.id) : Either.right((Object)nextDialogue));

        public void apply(DialogueComponent component, ServerPlayer player) {
            if (this.setAsEntrypoint) {
                component.setDialogueForPlayer(player, this.id);
            }
            component.tryOpenScreenForDialogue(player, this.id, this);
        }
    }

    public record Response(DialogueMessage message, List<Trigger> triggers, Optional<NextDialogue> nextDialogue, Condition condition, boolean hideIfFailed, Optional<String> failTooltipKey) {
        public static Codec<Response> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DialogueMessage.CODEC.fieldOf("message").forGetter(Response::message), (App)Trigger.LIST_CODEC.fieldOf("triggers").orElse(List.of()).forGetter(Response::triggers), (App)NextDialogue.EITHER_CODEC.optionalFieldOf("next_dialogue").forGetter(Response::nextDialogue), (App)Condition.CODEC.fieldOf("condition").orElse((Object)Condition.AlwaysTrue.INSTANCE).forGetter(Response::condition), (App)Codec.BOOL.fieldOf("hide_if_failed").orElse((Object)true).forGetter(Response::hideIfFailed), (App)Codec.STRING.optionalFieldOf("fail_tooltip").forGetter(Response::failTooltipKey)).apply((Applicative)instance, Response::new));
        static Codec<List<Response>> LIST_CODEC = CODEC.listOf();

        public Optional<ResponseData> evaluateData(int responseIndex, LivingEntity entity, ServerPlayer serverPlayer) {
            Optional<ConditionFailure> conditionFailure;
            if (this.condition.test(entity, serverPlayer)) {
                conditionFailure = Optional.empty();
            } else {
                if (this.hideIfFailed) {
                    return Optional.empty();
                }
                Component failureMessages = this.failTooltipKey.map(Component::translatable).orElseGet(this.condition::getFailureTooltip);
                conditionFailure = Optional.of(new ConditionFailure(failureMessages));
            }
            return Optional.of(new ResponseData((Component)this.message.evaluateComponent(entity, serverPlayer), this.nextDialogue.isEmpty(), responseIndex, conditionFailure));
        }

        public void trigger(DialogueComponent component, ServerPlayer player) {
            if (!this.condition().test(component.entity(), player)) {
                return;
            }
            for (Trigger trigger : this.triggers()) {
                trigger.triggerEffect(component.entity(), player);
            }
            this.nextDialogue().ifPresent(nextDialogue -> nextDialogue.apply(component, player));
        }
    }

    @MethodsReturnNonnullByDefault
    public static enum MessageType implements StringRepresentable
    {
        ENTITY,
        PLAYER,
        DESCRIPTION;

        static final Codec<MessageType> CODEC;

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(MessageType::values);
        }
    }

    public record Node(List<Pair<MessageType, DialogueMessage>> messages, DialogueAnimationData animation, ResourceLocation guiPath, List<Response> responses) {
        private static final Codec<Pair<MessageType, DialogueMessage>> MESSAGE_CODEC = Codec.mapPair((MapCodec)MessageType.CODEC.fieldOf("type"), (MapCodec)DialogueMessage.CODEC.fieldOf("message")).codec();
        private static final MapCodec<List<Pair<MessageType, DialogueMessage>>> MESSAGES_MAP_CODEC = Codec.mapEither((MapCodec)DialogueMessage.CODEC.fieldOf("message"), (MapCodec)MESSAGE_CODEC.listOf().fieldOf("messages")).xmap(either -> (List)either.map(message -> List.of(Pair.of((Object)((Object)MessageType.ENTITY), (Object)message)), Function.identity()), messages -> messages.size() == 1 && ((Pair)messages.get(0)).getFirst() == MessageType.ENTITY ? Either.left((Object)((DialogueMessage)((Pair)messages.get(0)).getSecond())) : Either.right((Object)messages));
        public static final Codec<Node> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MESSAGES_MAP_CODEC.forGetter(Node::messages), (App)DialogueAnimationData.CODEC.fieldOf("animation").orElse((Object)DialogueAnimationData.DEFAULT_ANIMATION).forGetter(Node::animation), (App)ResourceLocation.CODEC.fieldOf("gui").orElse((Object)DEFAULT_GUI).forGetter(Node::guiPath), (App)Response.LIST_CODEC.fieldOf("responses").orElse(Collections.emptyList()).forGetter(Node::responses)).apply((Applicative)instance, Node::new));

        DialogueData evaluateData(LivingEntity entity, ServerPlayer player, @Nullable NextDialogue source) {
            List<ResponseData> responses = IntStream.range(0, this.responses().size()).mapToObj(responseIndex -> this.responses().get(responseIndex).evaluateData(responseIndex, entity, player)).flatMap(Optional::stream).toList();
            List<Component> lines = Stream.concat(source != null ? source.replyMessages.stream() : Stream.empty(), this.messages.stream()).map(messagePair -> this.buildMessage((Pair<MessageType, DialogueMessage>)messagePair, entity, player)).toList();
            return new DialogueData(lines, this.guiPath(), responses, this.animation, ((DialogueEntity)entity).getSpriteType());
        }

        private Component buildMessage(Pair<MessageType, DialogueMessage> messagePair, LivingEntity entity, ServerPlayer player) {
            MutableComponent messageComponent = ((DialogueMessage)messagePair.getSecond()).evaluateComponent(entity, player);
            return switch (((MessageType)((Object)messagePair.getFirst())).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> {
                    MutableComponent component = Component.translatable((String)Dialogue.DIALOGUE_FORMAT, (Object[])new Object[]{entity.getDisplayName(), messageComponent});
                    if (entity instanceof DialogueEntity) {
                        DialogueEntity dialogueEntity = (DialogueEntity)entity;
                        component.withStyle(dialogueEntity.getChatColor());
                    }
                    yield component;
                }
                case 1 -> Component.translatable((String)Dialogue.DIALOGUE_FORMAT, (Object[])new Object[]{player.getDisplayName(), messageComponent});
                case 2 -> messageComponent.withStyle(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC});
            };
        }

        public Optional<Response> getResponseIfValid(int responseIndex) {
            if (responseIndex < 0 || this.responses().size() <= responseIndex) {
                return Optional.empty();
            }
            return Optional.of(this.responses().get(responseIndex));
        }

        public void visitConnectedDialogue(Consumer<ResourceLocation> idConsumer) {
            this.responses.forEach(response -> response.nextDialogue.ifPresent(nextDialogue -> idConsumer.accept(nextDialogue.id)));
        }
    }

    public record NodeReference(ResourceLocation dialoguePath, int nodeIndex) {
    }

    public record NodeSelector(List<Pair<Condition, Node>> conditionedNodes, Node defaultNode) {
        private static final Codec<Pair<Condition, Node>> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Condition.CODEC.fieldOf("condition").forGetter(Pair::getFirst), (App)Node.CODEC.fieldOf("node").forGetter(Pair::getSecond)).apply((Applicative)instance, Pair::of));
        private static final Codec<NodeSelector> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ENTRY_CODEC.listOf().fieldOf("conditioned_nodes").forGetter(NodeSelector::conditionedNodes), (App)Node.CODEC.fieldOf("default_node").forGetter(NodeSelector::defaultNode)).apply((Applicative)instance, NodeSelector::new));
        public static final Codec<NodeSelector> CODEC = Codec.either(DIRECT_CODEC, (Codec)Node.CODEC.fieldOf("node").codec()).xmap(either -> (NodeSelector)either.map(Function.identity(), node -> new NodeSelector(List.of(), (Node)node)), nodeSelector -> nodeSelector.conditionedNodes.isEmpty() ? Either.right((Object)nodeSelector.defaultNode) : Either.left((Object)nodeSelector));

        public Pair<Node, Integer> pickNode(LivingEntity entity, ServerPlayer player) {
            for (int i = 0; i < this.conditionedNodes.size(); ++i) {
                Pair<Condition, Node> pair = this.conditionedNodes.get(i);
                if (!((Condition)pair.getFirst()).test(entity, player)) continue;
                Node node = (Node)pair.getSecond();
                return Pair.of((Object)node, (Object)i);
            }
            return Pair.of((Object)this.defaultNode, (Object)-1);
        }

        public Optional<Node> getNodeIfValid(int index, LivingEntity entity, ServerPlayer player) {
            Pair<Node, Integer> pair = this.pickNode(entity, player);
            if ((Integer)pair.getSecond() != index) {
                return Optional.empty();
            }
            return Optional.of((Node)pair.getFirst());
        }

        public void visitConnectedDialogue(Consumer<ResourceLocation> idConsumer) {
            this.conditionedNodes.forEach(pair -> ((Node)pair.getSecond()).visitConnectedDialogue(idConsumer));
            this.defaultNode.visitConnectedDialogue(idConsumer);
        }
    }
}

