/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;

public record DialogueAnimationData(String emotion, int spriteHeight, int spriteWidth, int xOffset, int yOffset, float scale) {
    public static final String GENERIC_EMOTION = "generic";
    public static final String HAPPY_EMOTION = "happy";
    public static final String ANGRY_EMOTION = "angry";
    public static final String ANXIOUS_EMOTION = "anxious";
    public static final int DEFAULT_SPRITE_WIDTH = 224;
    public static final int DEFAULT_SPRITE_HEIGHT = 224;
    public static final DialogueAnimationData DEFAULT_ANIMATION = new DialogueAnimationData("generic", 224, 224, 0, 0, 1.0f);
    public static Codec<DialogueAnimationData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.optionalFieldOf("emotion", (Object)GENERIC_EMOTION).forGetter(DialogueAnimationData::emotion), (App)Codec.INT.optionalFieldOf("height", (Object)224).forGetter(DialogueAnimationData::spriteHeight), (App)Codec.INT.optionalFieldOf("width", (Object)224).forGetter(DialogueAnimationData::spriteWidth), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(DialogueAnimationData::xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(DialogueAnimationData::yOffset), (App)Codec.FLOAT.optionalFieldOf("scale", (Object)Float.valueOf(1.0f)).forGetter(DialogueAnimationData::scale)).apply((Applicative)instance, DialogueAnimationData::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, DialogueAnimationData> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, DialogueAnimationData::emotion, (StreamCodec)ByteBufCodecs.INT, DialogueAnimationData::spriteHeight, (StreamCodec)ByteBufCodecs.INT, DialogueAnimationData::spriteWidth, (StreamCodec)ByteBufCodecs.INT, DialogueAnimationData::xOffset, (StreamCodec)ByteBufCodecs.INT, DialogueAnimationData::yOffset, (StreamCodec)ByteBufCodecs.FLOAT, DialogueAnimationData::scale, DialogueAnimationData::new);

    public ResourceLocation getRenderPath(String spriteType) {
        ResourceLocation spritePath = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)("textures/gui/dialogue/entity/" + spriteType + "/" + this.emotion + ".png"));
        AbstractTexture abstractTexture = Minecraft.getInstance().getTextureManager().getTexture(spritePath);
        if (abstractTexture == MissingTextureAtlasSprite.getTexture()) {
            return ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)("textures/gui/dialogue/entity/" + spriteType + "/generic.png"));
        }
        return spritePath;
    }
}

