/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.DialogueNodes;
import com.mraof.minestuck.network.DialoguePackets;
import com.mraof.minestuck.util.MSAttachments;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class DialogueComponent {
    private static final Logger LOGGER = LogManager.getLogger();
    private final LivingEntity entity;
    private boolean hasGeneratedOnce = false;
    @Nullable
    private ResourceLocation startingDialogue;
    private boolean keepOnReset;
    private final Map<UUID, ResourceLocation> overriddenStartingDialogue = new HashMap<UUID, ResourceLocation>();
    private final Set<String> flags = new HashSet<String>();
    private final Map<UUID, Set<String>> playerSpecificFlags = new HashMap<UUID, Set<String>>();
    private final Map<UUID, Item> matchedItem = new HashMap<UUID, Item>();
    private final Map<UUID, OngoingDialogue> ongoingDialogue = new HashMap<UUID, OngoingDialogue>();

    public DialogueComponent(LivingEntity entity) {
        this.entity = entity;
    }

    public void read(CompoundTag tag) {
        if (tag.contains("dialogue_id", 8)) {
            this.hasGeneratedOnce = true;
            this.startingDialogue = ResourceLocation.tryParse((String)tag.getString("dialogue_id"));
            this.keepOnReset = tag.getBoolean("keep_on_reset");
            tag.getList("start_override", 10).stream().map(CompoundTag.class::cast).forEach(entryTag -> {
                UUID player = entryTag.getUUID("player");
                ResourceLocation override = ResourceLocation.tryParse((String)tag.getString("dialogue_id"));
                this.overriddenStartingDialogue.put(player, override);
            });
            tag.getList("flags", 8).stream().map(StringTag.class::cast).map(StringTag::getAsString).forEach(this.flags::add);
            tag.getList("player_flags", 10).stream().map(CompoundTag.class::cast).forEach(entryTag -> {
                UUID player = entryTag.getUUID("player");
                Set<String> playerFlags = this.playerFlags(player);
                entryTag.getList("flags", 8).stream().map(StringTag.class::cast).map(StringTag::getAsString).forEach(playerFlags::add);
            });
            tag.getList("matched_item", 10).stream().map(CompoundTag.class::cast).forEach(entryTag -> {
                UUID player = entryTag.getUUID("player");
                BuiltInRegistries.ITEM.byNameCodec().parse((DynamicOps)NbtOps.INSTANCE, (Object)entryTag.get("item")).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(item -> this.matchedItem.put(player, (Item)item));
            });
        } else {
            this.hasGeneratedOnce = tag.getBoolean("has_generated");
        }
    }

    public CompoundTag write() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("has_generated", this.hasGeneratedOnce);
        if (this.startingDialogue != null) {
            tag.putString("dialogue_id", this.startingDialogue.toString());
            tag.putBoolean("keep_on_reset", this.keepOnReset);
            ListTag startOverrideTag = new ListTag();
            this.overriddenStartingDialogue.forEach((player, override) -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putUUID("player", player);
                entryTag.putString("dialogue_id", override.toString());
                startOverrideTag.add((Object)entryTag);
            });
            tag.put("start_override", (Tag)startOverrideTag);
            ListTag flagsTag = new ListTag();
            this.flags.stream().map(StringTag::valueOf).forEach(arg_0 -> flagsTag.add(arg_0));
            tag.put("flags", (Tag)flagsTag);
            ListTag playerFlagsMapTag = new ListTag();
            this.playerSpecificFlags.forEach((player, playerFlags) -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putUUID("player", player);
                ListTag playerFlagsTag = new ListTag();
                playerFlags.stream().map(StringTag::valueOf).forEach(arg_0 -> playerFlagsTag.add(arg_0));
                entryTag.put("flags", (Tag)playerFlagsTag);
                playerFlagsMapTag.add((Object)entryTag);
            });
            tag.put("player_flags", (Tag)playerFlagsMapTag);
            ListTag matchedItemTag = new ListTag();
            this.matchedItem.forEach((player, item) -> {
                CompoundTag entryTag = new CompoundTag();
                entryTag.putUUID("player", player);
                BuiltInRegistries.ITEM.byNameCodec().encodeStart((DynamicOps)NbtOps.INSTANCE, item).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(itemTag -> {
                    entryTag.put("item", itemTag);
                    matchedItemTag.add((Object)entryTag);
                });
            });
            tag.put("matched_item", (Tag)matchedItemTag);
        }
        return tag;
    }

    public LivingEntity entity() {
        return this.entity;
    }

    public boolean hasGeneratedOnce() {
        return this.hasGeneratedOnce;
    }

    public void setDialogue(Dialogue.SelectableDialogue selectable) {
        this.setDialogue(selectable.dialogueId(), selectable.keepOnReset());
    }

    public void setDialogue(ResourceLocation dialogueId, boolean keepOnReset) {
        this.closeAllCurrentDialogue();
        this.hasGeneratedOnce = true;
        this.startingDialogue = dialogueId;
        this.keepOnReset = keepOnReset;
        this.overriddenStartingDialogue.clear();
    }

    public Optional<ResourceLocation> getStartingDialogue() {
        return Optional.ofNullable(this.startingDialogue);
    }

    public void setDialogueForPlayer(ServerPlayer player, ResourceLocation dialogueId) {
        this.overriddenStartingDialogue.put(player.getUUID(), dialogueId);
    }

    public Optional<ResourceLocation> getDialogueForPlayer(ServerPlayer player) {
        return Optional.ofNullable(this.overriddenStartingDialogue.getOrDefault(player.getUUID(), this.startingDialogue));
    }

    public boolean hasActiveDialogue() {
        return this.startingDialogue != null;
    }

    public Set<String> flags() {
        return this.flags;
    }

    public Set<String> playerFlags(ServerPlayer player) {
        return this.playerFlags(player.getUUID());
    }

    private Set<String> playerFlags(UUID player) {
        return this.playerSpecificFlags.computeIfAbsent(player, _player -> new HashSet());
    }

    public Optional<Item> getMatchedItem(ServerPlayer player) {
        return Optional.ofNullable(this.matchedItem.get(player.getUUID()));
    }

    public void setMatchedItem(Item item, ServerPlayer player) {
        this.matchedItem.put(player.getUUID(), item);
    }

    public void clearMatchedItem(ServerPlayer player) {
        this.matchedItem.remove(player.getUUID());
    }

    public void resetDialogue() {
        this.closeAllCurrentDialogue();
        if (!this.keepOnReset) {
            this.startingDialogue = null;
        }
        this.overriddenStartingDialogue.clear();
        this.flags.clear();
        this.playerSpecificFlags.clear();
        this.matchedItem.clear();
    }

    public boolean hasAnyOngoingDialogue() {
        return !this.ongoingDialogue.isEmpty();
    }

    public void closeAllCurrentDialogue() {
        this.ongoingDialogue.keySet().forEach(this::closeCurrentDialogue);
        this.ongoingDialogue.clear();
    }

    public void closeDialogueForMovingPlayers() {
        List<UUID> movedPlayers = this.ongoingDialogue.entrySet().stream().filter(entry -> {
            ServerPlayer player = Objects.requireNonNull(this.entity.getServer()).getPlayerList().getPlayer((UUID)entry.getKey());
            return player == null || player.position().distanceToSqr(((OngoingDialogue)entry.getValue()).playerStartPos()) > 2.0;
        }).map(Map.Entry::getKey).toList();
        movedPlayers.forEach(this::closeCurrentDialogue);
        movedPlayers.forEach(this.ongoingDialogue::remove);
    }

    private void closeCurrentDialogue(UUID playerId) {
        ServerPlayer player = Objects.requireNonNull(this.entity.getServer()).getPlayerList().getPlayer(playerId);
        if (player == null) {
            return;
        }
        if (((CurrentDialogue)player.getData(MSAttachments.CURRENT_DIALOGUE)).lastTalkedTo((Entity)this.entity)) {
            PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new DialoguePackets.CloseScreen(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void tryStartDialogue(ServerPlayer player) {
        Optional<ResourceLocation> dialogueId = this.getDialogueForPlayer(player);
        if (dialogueId.isEmpty()) {
            return;
        }
        Dialogue.NodeSelector dialogue = DialogueNodes.getInstance().getDialogue(dialogueId.get());
        if (dialogue == null) {
            LOGGER.warn("Unable to find dialogue with id {}", (Object)dialogueId.get());
            this.resetDialogue();
            return;
        }
        this.openScreenForDialogue(player, dialogueId.get(), dialogue, null);
    }

    public void tryOpenScreenForDialogue(ServerPlayer serverPlayer, ResourceLocation dialogueId, @Nullable Dialogue.NextDialogue source) {
        Dialogue.NodeSelector dialogue = DialogueNodes.getInstance().getDialogue(dialogueId);
        if (dialogue != null) {
            this.openScreenForDialogue(serverPlayer, dialogueId, dialogue, source);
        }
    }

    public void openScreenForDialogue(ServerPlayer player, ResourceLocation dialogueId, Dialogue.NodeSelector dialogue, @Nullable Dialogue.NextDialogue source) {
        CurrentDialogue dialogueData = (CurrentDialogue)player.getData(MSAttachments.CURRENT_DIALOGUE);
        dialogueData.getComponent(player.level()).ifPresent(oldComponent -> oldComponent.clearOngoingDialogue(player));
        Pair<Dialogue.Node, Integer> node = dialogue.pickNode(this.entity, player);
        Dialogue.DialogueData data = ((Dialogue.Node)node.getFirst()).evaluateData(this.entity, player, source);
        Dialogue.NodeReference nodeReference = new Dialogue.NodeReference(dialogueId, (Integer)node.getSecond());
        this.ongoingDialogue.put(player.getUUID(), new OngoingDialogue(nodeReference, player.position()));
        DialoguePackets.OpenScreen packet = new DialoguePackets.OpenScreen(dialogueData.newDialogue(this.entity), data);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public Optional<Dialogue.Node> validateAndGetCurrentNode(ServerPlayer player) {
        return Optional.ofNullable(this.ongoingDialogue.get(player.getUUID())).map(OngoingDialogue::nodeReference).flatMap(reference -> Optional.ofNullable(DialogueNodes.getInstance().getDialogue(reference.dialoguePath())).flatMap(nodeSelector -> nodeSelector.getNodeIfValid(reference.nodeIndex(), this.entity, player)));
    }

    public void clearOngoingDialogue(ServerPlayer player) {
        this.ongoingDialogue.remove(player.getUUID());
    }

    public static final class CurrentDialogue {
        private int dialogueCounter = 0;
        @Nullable
        private Integer entityId = null;

        public boolean lastTalkedTo(Entity entity) {
            return this.entityId != null && this.entityId.intValue() == entity.getId();
        }

        private int newDialogue(LivingEntity entity) {
            this.entityId = entity.getId();
            return ++this.dialogueCounter;
        }

        public Optional<DialogueComponent> validateAndGetComponent(Level level, int dialogueId) {
            if (dialogueId != this.dialogueCounter) {
                return Optional.empty();
            }
            return this.getComponent(level);
        }

        public Optional<DialogueComponent> getComponent(Level level) {
            if (this.entityId == null) {
                return Optional.empty();
            }
            Entity entity = level.getEntity(this.entityId.intValue());
            if (!(entity instanceof DialogueEntity)) {
                return Optional.empty();
            }
            DialogueEntity dialogueEntity = (DialogueEntity)entity;
            return Optional.of(dialogueEntity.getDialogueComponent());
        }
    }

    private record OngoingDialogue(Dialogue.NodeReference nodeReference, Vec3 playerStartPos) {
    }
}

