/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public record DialogueMessage(String key, List<Argument> arguments) {
    static Codec<DialogueMessage> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("key").forGetter(DialogueMessage::key), (App)Codec.list(Argument.CODEC).fieldOf("arguments").forGetter(DialogueMessage::arguments)).apply((Applicative)instance, DialogueMessage::new));
    static Codec<DialogueMessage> CODEC = Codec.either((Codec)Codec.STRING, DIRECT_CODEC).xmap(either -> (DialogueMessage)either.map(DialogueMessage::new, Function.identity()), message -> message.arguments.isEmpty() ? Either.left((Object)message.key) : Either.right((Object)message));

    public DialogueMessage(String message) {
        this(message, List.of());
    }

    public MutableComponent evaluateComponent(LivingEntity entity, ServerPlayer serverPlayer) {
        return Component.translatable((String)this.key, (Object[])this.arguments.stream().map(argument -> argument.processing.apply(entity, serverPlayer)).toArray());
    }

    private static Optional<ResourceKey<Level>> homeDimension(LivingEntity entity) {
        if (entity instanceof ConsortEntity) {
            ConsortEntity consort = (ConsortEntity)entity;
            return Optional.of(consort.getHomeDimension());
        }
        return Optional.empty();
    }

    private static Optional<PlayerIdentifier> homeLandClientPlayer(LivingEntity entity) {
        return DialogueMessage.homeDimension(entity).flatMap(land -> SburbPlayerData.getForLand((ResourceKey<Level>)land, Objects.requireNonNull(entity.getServer()))).map(SburbPlayerData::playerId);
    }

    private static Optional<Title> homeLandTitle(LivingEntity entity) {
        return DialogueMessage.homeLandClientPlayer(entity).flatMap(clientPlayer -> Title.getTitle(clientPlayer, Objects.requireNonNull(entity.getServer())));
    }

    @MethodsReturnNonnullByDefault
    public static enum Argument implements StringRepresentable
    {
        LAND_PLAYER_NAME((npc, player) -> (Component)DialogueMessage.homeLandClientPlayer(npc).map(clientPlayer -> Component.literal((String)clientPlayer.getUsername())).orElseGet(() -> Component.literal((String)"Player name"))),
        LAND_NAME((npc, player) -> (Component)DialogueMessage.homeDimension(npc).flatMap(land -> LandTypePair.getNamed(player.server, (ResourceKey<Level>)land)).map(LandTypePair.Named::asComponent).orElseGet(() -> Component.literal((String)"Land name"))),
        LAND_TITLE((npc, player) -> DialogueMessage.homeLandTitle(npc).map(Title::asTextComponent).orElseGet(() -> Component.literal((String)"Player title"))),
        LAND_CLASS((npc, player) -> DialogueMessage.homeLandTitle(npc).map(title -> title.heroClass().asTextComponent()).orElseGet(() -> Component.literal((String)"Player class"))),
        LAND_ASPECT((npc, player) -> DialogueMessage.homeLandTitle(npc).map(title -> title.heroAspect().asTextComponent()).orElseGet(() -> Component.literal((String)"Player aspect"))),
        LAND_DENIZEN((npc, player) -> (Component)DialogueMessage.homeLandTitle(npc).map(title -> Component.translatable((String)("denizen." + title.heroAspect().getTranslationKey()))).orElseGet(() -> Component.literal((String)"Denizen"))),
        ENTITY_SOUND((npc, player) -> Component.translatable((String)(npc.getType().getDescriptionId() + ".sound"))),
        ENTITY_SOUND_2((npc, player) -> Component.translatable((String)(npc.getType().getDescriptionId() + ".sound.2"))),
        ENTITY_TYPE((npc, player) -> npc.getType().getDescription()),
        ENTITY_TYPES((npc, player) -> Component.translatable((String)(npc.getType().getDescriptionId() + ".plural"))),
        PLAYER_TITLE((npc, player) -> {
            PlayerIdentifier identifier = Objects.requireNonNull(IdentifierHandler.encode((Player)player));
            return Title.getTitle(identifier, player.server).map(Title::asTextComponent).orElseGet(() -> ((ServerPlayer)player).getName());
        }),
        MATCHED_ITEM((npc, player) -> {
            DialogueComponent component = ((DialogueEntity)npc).getDialogueComponent();
            return component.getMatchedItem((ServerPlayer)player).map(item -> item.getName(item.getDefaultInstance())).orElseGet(() -> Component.literal((String)"???"));
        });

        public static final Codec<Argument> CODEC;
        private final BiFunction<LivingEntity, ServerPlayer, Component> processing;

        private Argument(BiFunction<LivingEntity, ServerPlayer, Component> processing) {
            this.processing = processing;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(Argument::values);
        }
    }
}

