/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(bus=EventBusSubscriber.Bus.GAME)
public class DialogueNodes {
    private final BiMap<ResourceLocation, Dialogue.NodeSelector> dialogues;
    @Nullable
    private static DialogueNodes INSTANCE;

    private DialogueNodes(BiMap<ResourceLocation, Dialogue.NodeSelector> dialogues) {
        this.dialogues = dialogues;
    }

    public static DialogueNodes getInstance() {
        return Objects.requireNonNull(INSTANCE, "Called getInstance() before dialogue nodes had loaded");
    }

    @Nullable
    public Dialogue.NodeSelector getDialogue(ResourceLocation location) {
        return (Dialogue.NodeSelector)this.dialogues.get((Object)location);
    }

    public Collection<ResourceLocation> allIds() {
        return this.dialogues.keySet();
    }

    @SubscribeEvent
    public static void onResourceReload(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new Loader());
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        INSTANCE = null;
    }

    private static final class Loader
    extends SimpleJsonResourceReloadListener {
        private static final Logger LOGGER = LogManager.getLogger();
        private static final Gson GSON = new GsonBuilder().create();

        public Loader() {
            super(GSON, "minestuck/dialogue");
        }

        protected void apply(Map<ResourceLocation, JsonElement> jsonEntries, ResourceManager resourceManager, ProfilerFiller profiler) {
            ImmutableBiMap.Builder dialogues = ImmutableBiMap.builder();
            for (Map.Entry<ResourceLocation, JsonElement> entry : jsonEntries.entrySet()) {
                Dialogue.NodeSelector.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)entry.getValue()).resultOrPartial(message -> LOGGER.error("Problem parsing dialogue {}: {}", entry.getKey(), message)).ifPresent(dialogue -> dialogues.put((Object)((ResourceLocation)entry.getKey()), dialogue));
            }
            INSTANCE = new DialogueNodes((BiMap<ResourceLocation, Dialogue.NodeSelector>)dialogues.build());
            LOGGER.info("Loaded {} dialogues", (Object)DialogueNodes.INSTANCE.dialogues.size());
        }
    }
}

