/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.advancements.MSCriteriaTriggers;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.consort.ConsortReputation;
import com.mraof.minestuck.entity.consort.ConsortRewardHandler;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.Triggers;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import com.mraof.minestuck.inventory.ConsortMerchantInventory;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@MethodsReturnNonnullByDefault
public sealed interface Trigger {
    public static final Codec<Trigger> CODEC = Triggers.REGISTRY.byNameCodec().dispatch(Trigger::codec, Function.identity());
    public static final Codec<List<Trigger>> LIST_CODEC = CODEC.listOf();
    public static final Codec<EquipmentSlot> EQUIPMENT_CODEC = Codec.STRING.comapFlatMap(Trigger::parseSlot, EquipmentSlot::getName);

    public MapCodec<? extends Trigger> codec();

    public void triggerEffect(LivingEntity var1, ServerPlayer var2);

    public static DataResult<EquipmentSlot> parseSlot(String slotName) {
        try {
            return DataResult.success((Object)EquipmentSlot.byName((String)slotName));
        }
        catch (IllegalArgumentException e) {
            return DataResult.error(() -> "Not a valid name for an EquipmentSlot: " + slotName);
        }
    }

    public record SetRandomFlag(List<String> flags, boolean isPlayerSpecific) implements Trigger
    {
        static final MapCodec<SetRandomFlag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.listOf().fieldOf("flags").forGetter(SetRandomFlag::flags), (App)Codec.BOOL.fieldOf("player_specific").forGetter(SetRandomFlag::isPlayerSpecific)).apply((Applicative)instance, SetRandomFlag::new));

        public MapCodec<SetRandomFlag> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (this.flags.isEmpty()) {
                return;
            }
            if (entity instanceof DialogueEntity) {
                DialogueEntity dialogueEntity = (DialogueEntity)entity;
                DialogueComponent component = dialogueEntity.getDialogueComponent();
                Set<String> flags = this.isPlayerSpecific ? component.playerFlags(player) : component.flags();
                if (this.flags.stream().noneMatch(flags::contains)) {
                    flags.add((String)Util.getRandom(this.flags, (RandomSource)entity.getRandom()));
                }
            }
        }
    }

    public record SetFlag(String flag, boolean isPlayerSpecific) implements Trigger
    {
        static final MapCodec<SetFlag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("flag").forGetter(SetFlag::flag), (App)Codec.BOOL.fieldOf("player_specific").forGetter(SetFlag::isPlayerSpecific)).apply((Applicative)instance, SetFlag::new));

        public MapCodec<SetFlag> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (entity instanceof DialogueEntity) {
                DialogueEntity dialogueEntity = (DialogueEntity)entity;
                DialogueComponent component = dialogueEntity.getDialogueComponent();
                Set<String> flags = this.isPlayerSpecific ? component.playerFlags(player) : component.flags();
                flags.add(this.flag);
            }
        }
    }

    public record Explode() implements Trigger
    {
        static final MapCodec<Explode> CODEC = MapCodec.unit(Explode::new);

        public MapCodec<Explode> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (entity instanceof ConsortEntity) {
                ConsortEntity consortEntity = (ConsortEntity)entity;
                consortEntity.setExplosionTimer();
            }
        }
    }

    public record AddEcheladderExperience(int xp) implements Trigger
    {
        static final MapCodec<AddEcheladderExperience> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("xp").forGetter(AddEcheladderExperience::xp)).apply((Applicative)instance, AddEcheladderExperience::new));

        public MapCodec<AddEcheladderExperience> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return;
            }
            Echeladder.get(player).increaseProgress(this.xp);
        }
    }

    public record AddBoondollars(int boondollars) implements Trigger
    {
        static final MapCodec<AddBoondollars> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("boondollars").forGetter(AddBoondollars::boondollars)).apply((Applicative)instance, AddBoondollars::new));

        public MapCodec<AddBoondollars> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            Optional<PlayerData> data = PlayerData.get(player);
            if (data.isPresent() && this.boondollars != 0) {
                if (this.boondollars > 0) {
                    PlayerBoondollars.addBoondollars(data.get(), this.boondollars);
                } else {
                    PlayerBoondollars.takeBoondollars(data.get(), -this.boondollars);
                }
            }
        }
    }

    public record AddConsortReputation(int reputation) implements Trigger
    {
        static final MapCodec<AddConsortReputation> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("reputation").forGetter(AddConsortReputation::reputation)).apply((Applicative)instance, AddConsortReputation::new));

        public MapCodec<AddConsortReputation> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (!(entity instanceof ConsortEntity)) {
                return;
            }
            ConsortEntity consortEntity = (ConsortEntity)entity;
            PlayerData.get(player).ifPresent(playerData -> ConsortReputation.get(playerData).addConsortReputation(this.reputation, consortEntity.getHomeDimension()));
        }
    }

    public record GiveFromLootTable(ResourceKey<LootTable> lootTable) implements Trigger
    {
        private static final Logger LOGGER = LogManager.getLogger();
        static final MapCodec<GiveFromLootTable> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(GiveFromLootTable::lootTable)).apply((Applicative)instance, GiveFromLootTable::new));

        public MapCodec<GiveFromLootTable> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return;
            }
            LootParams.Builder builder = new LootParams.Builder((ServerLevel)entity.level()).withParameter(LootContextParams.THIS_ENTITY, (Object)entity).withParameter(LootContextParams.ORIGIN, (Object)entity.position());
            ObjectArrayList loot = entity.getServer().reloadableRegistries().getLootTable(this.lootTable).getRandomItems(builder.create(LootContextParamSets.GIFT));
            if (loot.isEmpty()) {
                LOGGER.warn("Tried to generate loot from {}, but no items were generated!", this.lootTable);
            }
            for (ItemStack itemstack : loot) {
                player.spawnAtLocation(itemstack, 0.0f);
                if (!(entity instanceof ConsortEntity)) continue;
                ConsortEntity consortEntity = (ConsortEntity)entity;
                MSCriteriaTriggers.CONSORT_ITEM.get().trigger(player, this.lootTable.toString(), itemstack, consortEntity);
            }
        }
    }

    public record GiveItem(Item item, int amount) implements Trigger
    {
        static final MapCodec<GiveItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(GiveItem::item), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(GiveItem::amount)).apply((Applicative)instance, GiveItem::new));

        public GiveItem(Item item) {
            this(item, 1);
        }

        public MapCodec<GiveItem> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return;
            }
            player.addItem(new ItemStack((ItemLike)this.item, this.amount));
        }
    }

    public record SetNPCMatchedItem(EquipmentSlot slot) implements Trigger
    {
        static final MapCodec<SetNPCMatchedItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EQUIPMENT_CODEC.optionalFieldOf("slot", (Object)EquipmentSlot.MAINHAND).forGetter(SetNPCMatchedItem::slot)).apply((Applicative)instance, SetNPCMatchedItem::new));

        public MapCodec<SetNPCMatchedItem> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            DialogueComponent component = ((DialogueEntity)entity).getDialogueComponent();
            Optional<Item> matchedItem = component.getMatchedItem(player);
            matchedItem.ifPresent(item -> {
                ItemStack matchedStack = Condition.PlayerHasItem.findPlayerItem(item, (Player)player, 1);
                if (matchedStack != null) {
                    entity.setItemSlot(this.slot, new ItemStack((ItemLike)item));
                    matchedStack.shrink(1);
                }
            });
        }
    }

    public record SetNPCItem(Item item, EquipmentSlot slot) implements Trigger
    {
        static final MapCodec<SetNPCItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(SetNPCItem::item), (App)EQUIPMENT_CODEC.optionalFieldOf("slot", (Object)EquipmentSlot.MAINHAND).forGetter(SetNPCItem::slot)).apply((Applicative)instance, SetNPCItem::new));

        public MapCodec<SetNPCItem> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            entity.setItemSlot(this.slot, new ItemStack((ItemLike)this.item));
        }
    }

    public static enum TakeMatchedItem implements Trigger
    {
        INSTANCE;

        static final MapCodec<TakeMatchedItem> CODEC;

        public MapCodec<TakeMatchedItem> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            DialogueComponent component = ((DialogueEntity)entity).getDialogueComponent();
            Optional<Item> matchedItem = component.getMatchedItem(player);
            matchedItem.ifPresent(item -> {
                ItemStack matchedStack = Condition.PlayerHasItem.findPlayerItem(item, (Player)player, 1);
                if (matchedStack != null) {
                    matchedStack.shrink(1);
                }
            });
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record TakeItem(Item item, int amount) implements Trigger
    {
        static final MapCodec<TakeItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(TakeItem::item), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(TakeItem::amount)).apply((Applicative)instance, TakeItem::new));

        public TakeItem(Item item) {
            this(item, 1);
        }

        public MapCodec<TakeItem> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return;
            }
            ItemStack stack = Condition.PlayerHasItem.findPlayerItem(this.item, (Player)player, this.amount);
            if (stack != null) {
                stack.shrink(this.amount);
            }
        }
    }

    public record Command(String commandText) implements Trigger
    {
        static final MapCodec<Command> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("command").forGetter(Command::commandText)).apply((Applicative)instance, Command::new));

        public MapCodec<Command> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return;
            }
            CommandSourceStack sourceStack = player.createCommandSourceStack().withSuppressedOutput().withPermission(2);
            player.server.getCommands().performPrefixedCommand(sourceStack, this.commandText);
        }
    }

    public record OpenConsortMerchantGui(ResourceKey<LootTable> lootTable) implements Trigger
    {
        static final MapCodec<OpenConsortMerchantGui> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceKey.codec((ResourceKey)Registries.LOOT_TABLE).fieldOf("loot_table").forGetter(OpenConsortMerchantGui::lootTable)).apply((Applicative)instance, OpenConsortMerchantGui::new));

        public MapCodec<OpenConsortMerchantGui> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (entity instanceof ConsortEntity) {
                ConsortEntity consortEntity = (ConsortEntity)entity;
                if (consortEntity.stocks == null) {
                    consortEntity.stocks = new ConsortMerchantInventory(consortEntity, ConsortRewardHandler.generateStock(this.lootTable, consortEntity, consortEntity.level().random));
                }
                player.openMenu((MenuProvider)new SimpleMenuProvider((MenuConstructor)consortEntity, (Component)Component.literal((String)"Consort shop")), consortEntity::writeShopMenuBuffer);
            }
        }
    }

    public record SetPlayerDialogue(ResourceLocation dialogueId) implements Trigger
    {
        static final MapCodec<SetPlayerDialogue> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dialogue").forGetter(SetPlayerDialogue::dialogueId)).apply((Applicative)instance, SetPlayerDialogue::new));

        public MapCodec<SetPlayerDialogue> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            ((DialogueEntity)entity).getDialogueComponent().setDialogueForPlayer(player, this.dialogueId);
        }
    }

    public record SetDialogueFromList(List<ResourceLocation> newPaths) implements Trigger
    {
        static final MapCodec<SetDialogueFromList> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.list((Codec)ResourceLocation.CODEC).fieldOf("new_paths").forGetter(SetDialogueFromList::newPaths)).apply((Applicative)instance, SetDialogueFromList::new));

        public MapCodec<SetDialogueFromList> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (entity instanceof DialogueEntity) {
                DialogueEntity dialogueEntity = (DialogueEntity)entity;
                dialogueEntity.getDialogueComponent().setDialogue((ResourceLocation)Util.getRandom(this.newPaths, (RandomSource)entity.level().random), false);
            }
        }
    }

    public record SetDialogue(ResourceLocation newPath) implements Trigger
    {
        static final MapCodec<SetDialogue> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("new_path").forGetter(SetDialogue::newPath)).apply((Applicative)instance, SetDialogue::new));

        public MapCodec<SetDialogue> codec() {
            return CODEC;
        }

        @Override
        public void triggerEffect(LivingEntity entity, ServerPlayer player) {
            if (entity instanceof DialogueEntity) {
                DialogueEntity dialogueEntity = (DialogueEntity)entity;
                dialogueEntity.getDialogueComponent().setDialogue(this.newPath, false);
            }
        }
    }
}

