/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.carapacian.CarapacianEntity;
import com.mraof.minestuck.entity.carapacian.EnumEntityKingdom;
import com.mraof.minestuck.entity.consort.ConsortEntity;
import com.mraof.minestuck.entity.consort.ConsortReputation;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.entity.dialogue.DialogueComponent;
import com.mraof.minestuck.entity.dialogue.DialogueEntity;
import com.mraof.minestuck.entity.dialogue.DialogueNodes;
import com.mraof.minestuck.entity.dialogue.condition.Conditions;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.PlayerBoondollars;
import com.mraof.minestuck.player.PlayerData;
import com.mraof.minestuck.player.Title;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.world.MSDimensions;
import com.mraof.minestuck.world.lands.LandTypePair;
import com.mraof.minestuck.world.lands.LandTypes;
import com.mraof.minestuck.world.lands.terrain.TerrainLandType;
import com.mraof.minestuck.world.lands.title.TitleLandType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.Scoreboard;

public interface Condition {
    public static final Codec<Condition> CODEC = Conditions.REGISTRY.byNameCodec().dispatch(Condition::codec, Function.identity());
    public static final Codec<Condition> NPC_ONLY_CODEC = CODEC.validate(condition -> condition.isNpcOnly() ? DataResult.success((Object)condition) : DataResult.error(() -> "Player condition not supported here"));
    public static final Codec<PlayerOnlyCondition> PLAYER_ONLY_CODEC = CODEC.comapFlatMap(condition -> {
        DataResult dataResult;
        if (condition instanceof PlayerOnlyCondition) {
            PlayerOnlyCondition playerOnly = (PlayerOnlyCondition)condition;
            dataResult = DataResult.success((Object)playerOnly);
        } else {
            dataResult = DataResult.error(() -> "NPC condition not supported here");
        }
        return dataResult;
    }, Function.identity());

    public MapCodec<? extends Condition> codec();

    public boolean test(LivingEntity var1, ServerPlayer var2);

    default public Component getFailureTooltip() {
        return Component.empty();
    }

    default public boolean isNpcOnly() {
        return false;
    }

    default public boolean isPlayerOnly() {
        return false;
    }

    public static interface PlayerOnlyCondition
    extends Condition {
        public boolean test(ServerPlayer var1);

        @Override
        default public boolean test(LivingEntity entity, ServerPlayer player) {
            return this.test(player);
        }

        @Override
        default public boolean isNpcOnly() {
            return false;
        }

        @Override
        default public boolean isPlayerOnly() {
            return true;
        }
    }

    public static enum ConsortVisitedSkaia implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<ConsortVisitedSkaia> CODEC;

        public MapCodec<ConsortVisitedSkaia> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            ConsortEntity consort;
            return entity instanceof ConsortEntity && (consort = (ConsortEntity)entity).visitedSkaia();
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public static enum IsInSkaia implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<IsInSkaia> CODEC;

        public MapCodec<IsInSkaia> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return MSDimensions.isSkaia((ResourceKey<Level>)entity.level().dimension());
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record NearSpawn(int maxDistance) implements NpcOnlyCondition
    {
        static final MapCodec<NearSpawn> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("max_distance").forGetter(NearSpawn::maxDistance)).apply((Applicative)instance, NearSpawn::new));

        public MapCodec<NearSpawn> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            LevelData levelData = entity.level().getLevelData();
            Vec3 spawn = Vec3.atCenterOf((Vec3i)levelData.getSpawnPos());
            return entity.distanceToSqr(spawn) <= (double)(this.maxDistance * this.maxDistance);
        }
    }

    public record Flag(String flag) implements Condition
    {
        static final MapCodec<Flag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("flag").forGetter(Flag::flag)).apply((Applicative)instance, Flag::new));

        public MapCodec<Flag> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            if (entity instanceof DialogueEntity) {
                DialogueEntity dialogueEntity = (DialogueEntity)entity;
                DialogueComponent component = dialogueEntity.getDialogueComponent();
                return component.flags().contains(this.flag) || component.playerFlags(player).contains(this.flag);
            }
            return false;
        }
    }

    public static enum HasMoveRestriction implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<HasMoveRestriction> CODEC;

        public MapCodec<HasMoveRestriction> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            Mob mob;
            return entity instanceof Mob && (mob = (Mob)entity).hasRestriction();
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record DialogueExists(ResourceLocation dialogueId) implements Condition
    {
        static final MapCodec<DialogueExists> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("dialogue_id").forGetter(DialogueExists::dialogueId)).apply((Applicative)instance, DialogueExists::new));

        public MapCodec<DialogueExists> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            return DialogueNodes.getInstance().getDialogue(this.dialogueId) != null;
        }
    }

    public record CustomHasTag(boolean checkPlayer, String tagName) implements Condition
    {
        static final MapCodec<CustomHasTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("check_player", (Object)true).forGetter(CustomHasTag::checkPlayer), (App)Codec.STRING.fieldOf("tag_name").forGetter(CustomHasTag::tagName)).apply((Applicative)instance, CustomHasTag::new));

        public MapCodec<CustomHasTag> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return false;
            }
            if (this.checkPlayer) {
                return player.getTags().contains(this.tagName);
            }
            return entity.getTags().contains(this.tagName);
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"The target does not have the correct tag");
        }
    }

    public record CustomHasScore(int value, String ownerName, String objectiveName) implements Condition
    {
        static final MapCodec<CustomHasScore> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("value", (Object)0).forGetter(CustomHasScore::value), (App)Codec.STRING.fieldOf("owner_name").forGetter(CustomHasScore::ownerName), (App)Codec.STRING.fieldOf("objective_name").forGetter(CustomHasScore::objectiveName)).apply((Applicative)instance, CustomHasScore::new));

        public MapCodec<CustomHasScore> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            if (player == null) {
                return false;
            }
            Scoreboard scoreboard = player.getScoreboard();
            Objective objective = scoreboard.getObjective(this.objectiveName);
            if (objective == null) {
                return false;
            }
            Collection scores = scoreboard.listPlayerScores(objective);
            String modOwnerName = switch (this.ownerName) {
                case "player" -> player.getScoreboardName();
                case "npc" -> entity.getScoreboardName();
                default -> this.ownerName;
            };
            return scores.stream().filter(score -> score.owner().equals(modOwnerName)).anyMatch(score -> score.value() == this.value);
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"A custom scoreboard value does not match");
        }
    }

    public record PlayerHasAdvancement(ResourceLocation advancementId) implements PlayerOnlyCondition
    {
        static final MapCodec<PlayerHasAdvancement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("advancement_id").forGetter(PlayerHasAdvancement::advancementId)).apply((Applicative)instance, PlayerHasAdvancement::new));

        public MapCodec<PlayerHasAdvancement> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            if (player == null) {
                return false;
            }
            AdvancementHolder holder = player.server.getAdvancements().get(this.advancementId);
            if (holder == null) {
                return false;
            }
            return player.getAdvancements().getOrStartProgress(holder).isDone();
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Player has not completed advancement");
        }
    }

    public static enum PlayerHasEntered implements PlayerOnlyCondition
    {
        INSTANCE;

        static final MapCodec<PlayerHasEntered> CODEC;

        public MapCodec<PlayerHasEntered> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            if (player == null) {
                return false;
            }
            return SburbPlayerData.get(player).hasEntered();
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Player has not Entered");
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record PlayerHasBoondollars(int amount) implements PlayerOnlyCondition
    {
        static final MapCodec<PlayerHasBoondollars> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(PlayerHasBoondollars::amount)).apply((Applicative)instance, PlayerHasBoondollars::new));

        public MapCodec<PlayerHasBoondollars> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            if (player == null) {
                return false;
            }
            Optional<PlayerData> data = PlayerData.get(player);
            if (data.isPresent()) {
                return PlayerBoondollars.getBoondollars(data.get()) >= (long)this.amount;
            }
            return false;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Your porkhollow doesn't meet requirement");
        }
    }

    public record PlayerHasReputation(int amount, boolean greaterThan) implements PlayerOnlyCondition
    {
        static final MapCodec<PlayerHasReputation> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(PlayerHasReputation::amount), (App)Codec.BOOL.optionalFieldOf("greater_than", (Object)true).forGetter(PlayerHasReputation::greaterThan)).apply((Applicative)instance, PlayerHasReputation::new));

        public MapCodec<PlayerHasReputation> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            if (player == null) {
                return false;
            }
            Level level = player.level();
            Optional<ConsortReputation> reputation = PlayerData.get(player).map(ConsortReputation::get);
            if (reputation.isEmpty()) {
                return false;
            }
            return this.greaterThan ? reputation.get().getConsortReputation((ResourceKey<Level>)level.dimension()) > this.amount : reputation.get().getConsortReputation((ResourceKey<Level>)level.dimension()) < this.amount;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Your reputation doesn't meet requirement");
        }
    }

    public record PlayerIsAspect(EnumAspect enumAspect) implements PlayerOnlyCondition
    {
        static final MapCodec<PlayerIsAspect> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumAspect.CODEC.fieldOf("aspect").forGetter(PlayerIsAspect::enumAspect)).apply((Applicative)instance, PlayerIsAspect::new));

        public MapCodec<PlayerIsAspect> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            if (player == null) {
                return false;
            }
            return Title.isPlayerOfAspect(player, this.enumAspect);
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"You aren't the required Aspect");
        }
    }

    public record PlayerIsClass(EnumClass enumClass) implements PlayerOnlyCondition
    {
        static final MapCodec<PlayerIsClass> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumClass.CODEC.fieldOf("class").forGetter(PlayerIsClass::enumClass)).apply((Applicative)instance, PlayerIsClass::new));

        public MapCodec<PlayerIsClass> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            if (player == null) {
                return false;
            }
            return Title.getTitle(player).map(value -> value.heroClass().equals((Object)this.enumClass)).orElse(false);
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"You aren't the required Class");
        }
    }

    public static enum HasMatchedItem implements Condition
    {
        INSTANCE;

        static final MapCodec<HasMatchedItem> CODEC;

        public MapCodec<HasMatchedItem> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            DialogueComponent component = ((DialogueEntity)entity).getDialogueComponent();
            Optional<Item> lastMatched = component.getMatchedItem(player);
            return lastMatched.isPresent() && PlayerHasItem.findPlayerItem(lastMatched.get(), (Player)player, 1) != null;
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record ItemTagMatchExclude(TagKey<Item> itemTag, Item exclusionItem) implements Condition
    {
        static final MapCodec<ItemTagMatchExclude> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(ItemTagMatchExclude::itemTag), (App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("exclusion_item").forGetter(ItemTagMatchExclude::exclusionItem)).apply((Applicative)instance, ItemTagMatchExclude::new));

        public MapCodec<ItemTagMatchExclude> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            DialogueComponent component = ((DialogueEntity)entity).getDialogueComponent();
            Optional<Item> lastMatched = component.getMatchedItem(player);
            if (lastMatched.isPresent() && lastMatched.get().builtInRegistryHolder().is(this.itemTag) && PlayerHasItem.findPlayerItem(lastMatched.get(), (Player)player, 1) != null) {
                return true;
            }
            Optional tag = BuiltInRegistries.ITEM.getTag(this.itemTag);
            List items = tag.stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).filter(item -> item != this.exclusionItem).collect(Collectors.toCollection(ArrayList::new));
            while (!items.isEmpty()) {
                Item nextItem = (Item)items.remove(entity.getRandom().nextInt(items.size()));
                if (PlayerHasItem.findPlayerItem(nextItem, (Player)player, 1) == null) continue;
                component.setMatchedItem(nextItem, player);
                return true;
            }
            component.clearMatchedItem(player);
            return false;
        }
    }

    public record ItemTagMatch(TagKey<Item> itemTag) implements Condition
    {
        static final MapCodec<ItemTagMatch> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)Registries.ITEM).fieldOf("tag").forGetter(ItemTagMatch::itemTag)).apply((Applicative)instance, ItemTagMatch::new));

        public MapCodec<ItemTagMatch> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity, ServerPlayer player) {
            DialogueComponent component = ((DialogueEntity)entity).getDialogueComponent();
            Optional<Item> lastMatched = component.getMatchedItem(player);
            if (lastMatched.isPresent() && lastMatched.get().builtInRegistryHolder().is(this.itemTag) && PlayerHasItem.findPlayerItem(lastMatched.get(), (Player)player, 1) != null) {
                return true;
            }
            Optional tag = BuiltInRegistries.ITEM.getTag(this.itemTag);
            List items = tag.stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).collect(Collectors.toCollection(ArrayList::new));
            while (!items.isEmpty()) {
                Item nextItem = (Item)items.remove(entity.getRandom().nextInt(items.size()));
                if (PlayerHasItem.findPlayerItem(nextItem, (Player)player, 1) == null) continue;
                component.setMatchedItem(nextItem, player);
                return true;
            }
            component.clearMatchedItem(player);
            return false;
        }
    }

    public record PlayerHasItem(Item item, int amount) implements PlayerOnlyCondition
    {
        static final MapCodec<PlayerHasItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(PlayerHasItem::item), (App)Codec.INT.optionalFieldOf("amount", (Object)1).forGetter(PlayerHasItem::amount)).apply((Applicative)instance, PlayerHasItem::new));

        public MapCodec<PlayerHasItem> codec() {
            return CODEC;
        }

        @Override
        public boolean test(ServerPlayer player) {
            ItemStack stack = PlayerHasItem.findPlayerItem(this.item, (Player)player, this.amount);
            return stack != null;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"You don't have the required item(s)");
        }

        @Nullable
        public static ItemStack findPlayerItem(Item item, Player player, int minAmount) {
            for (ItemStack invItem : player.getInventory().items) {
                if (!invItem.is(item) || invItem.getCount() < minAmount) continue;
                return invItem;
            }
            return null;
        }
    }

    public record NPCIsHoldingItem(Item item) implements NpcOnlyCondition
    {
        static final MapCodec<NPCIsHoldingItem> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ITEM.byNameCodec().fieldOf("item").forGetter(NPCIsHoldingItem::item)).apply((Applicative)instance, NPCIsHoldingItem::new));

        public MapCodec<NPCIsHoldingItem> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return entity.getMainHandItem().is(this.item) || entity.getOffhandItem().is(this.item);
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"NPC is not holding the right item");
        }
    }

    public record AtOrAboveY(double y) implements NpcOnlyCondition
    {
        static final MapCodec<AtOrAboveY> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("y").forGetter(AtOrAboveY::y)).apply((Applicative)instance, AtOrAboveY::new));

        public MapCodec<AtOrAboveY> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return this.y <= entity.getY();
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not at the right height");
        }
    }

    public record InTitleLandTypeTag(TagKey<TitleLandType> landTypeTag) implements NpcOnlyCondition
    {
        static final MapCodec<InTitleLandTypeTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)LandTypes.TITLE_REGISTRY.key()).fieldOf("land_type_tag").forGetter(InTitleLandTypeTag::landTypeTag)).apply((Applicative)instance, InTitleLandTypeTag::new));

        public MapCodec<InTitleLandTypeTag> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            ServerLevel serverLevel;
            Optional<LandTypePair.Named> potentialLandTypes;
            if (this.landTypeTag == null) {
                return false;
            }
            Level level = entity.level();
            if (level instanceof ServerLevel && (potentialLandTypes = LandTypePair.getNamed(serverLevel = (ServerLevel)level)).isPresent()) {
                return potentialLandTypes.get().landTypes().getTitle().is(this.landTypeTag);
            }
            return false;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in specific Land tag");
        }
    }

    public record InTitleLandType(TitleLandType landType) implements NpcOnlyCondition
    {
        static final MapCodec<InTitleLandType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LandTypes.TITLE_REGISTRY.byNameCodec().fieldOf("land_type").forGetter(InTitleLandType::landType)).apply((Applicative)instance, InTitleLandType::new));

        public MapCodec<InTitleLandType> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            ServerLevel serverLevel;
            Optional<LandTypePair.Named> potentialLandTypes;
            if (this.landType == null) {
                return false;
            }
            Level level = entity.level();
            if (level instanceof ServerLevel && (potentialLandTypes = LandTypePair.getNamed(serverLevel = (ServerLevel)level)).isPresent()) {
                return potentialLandTypes.get().landTypes().getTitle() == this.landType;
            }
            return false;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in specific Land");
        }
    }

    public record InConsortTerrainLandType(EnumConsort consort) implements NpcOnlyCondition
    {
        static final MapCodec<InConsortTerrainLandType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumConsort.CODEC.fieldOf("consort").forGetter(InConsortTerrainLandType::consort)).apply((Applicative)instance, InConsortTerrainLandType::new));

        public MapCodec<InConsortTerrainLandType> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            ServerLevel serverLevel;
            Optional<LandTypePair.Named> potentialLandTypes;
            Level level = entity.level();
            if (level instanceof ServerLevel && (potentialLandTypes = LandTypePair.getNamed(serverLevel = (ServerLevel)level)).isPresent()) {
                return potentialLandTypes.get().landTypes().getTerrain().getConsortType() == this.consort.getConsortType();
            }
            return false;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in specific Land");
        }
    }

    public record InTerrainLandTypeTag(TagKey<TerrainLandType> landTypeTag) implements NpcOnlyCondition
    {
        static final MapCodec<InTerrainLandTypeTag> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)TagKey.codec((ResourceKey)LandTypes.TERRAIN_REGISTRY.key()).fieldOf("land_type_tag").forGetter(InTerrainLandTypeTag::landTypeTag)).apply((Applicative)instance, InTerrainLandTypeTag::new));

        public MapCodec<InTerrainLandTypeTag> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            ServerLevel serverLevel;
            Optional<LandTypePair.Named> potentialLandTypes;
            if (this.landTypeTag == null) {
                return false;
            }
            Level level = entity.level();
            if (level instanceof ServerLevel && (potentialLandTypes = LandTypePair.getNamed(serverLevel = (ServerLevel)level)).isPresent()) {
                return potentialLandTypes.get().landTypes().getTerrain().is(this.landTypeTag);
            }
            return false;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in specific Land tag");
        }
    }

    public record InTerrainLandType(TerrainLandType landType) implements NpcOnlyCondition
    {
        static final MapCodec<InTerrainLandType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LandTypes.TERRAIN_REGISTRY.byNameCodec().fieldOf("land_type").forGetter(InTerrainLandType::landType)).apply((Applicative)instance, InTerrainLandType::new));

        public MapCodec<InTerrainLandType> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            ServerLevel serverLevel;
            Optional<LandTypePair.Named> potentialLandTypes;
            if (this.landType == null) {
                return false;
            }
            Level level = entity.level();
            if (level instanceof ServerLevel && (potentialLandTypes = LandTypePair.getNamed(serverLevel = (ServerLevel)level)).isPresent()) {
                return potentialLandTypes.get().landTypes().getTerrain() == this.landType;
            }
            return false;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in specific Land");
        }
    }

    public static enum IsConsortInHomeLand implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<IsConsortInHomeLand> CODEC;

        public MapCodec<IsConsortInHomeLand> codec() {
            return CODEC;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean test(LivingEntity entity) {
            if (!(entity instanceof ConsortEntity)) return false;
            ConsortEntity consort = (ConsortEntity)entity;
            if (!MSDimensions.isLandDimension(entity.getServer(), consort.getHomeDimension())) return false;
            if (!consort.level().dimension().equals(consort.getHomeDimension())) return false;
            return true;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in home Land");
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public static enum IsConsortFromLand implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<IsConsortFromLand> CODEC;

        public MapCodec<IsConsortFromLand> codec() {
            return CODEC;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean test(LivingEntity entity) {
            if (!(entity instanceof ConsortEntity)) return false;
            ConsortEntity consort = (ConsortEntity)entity;
            if (!MSDimensions.isLandDimension(entity.getServer(), consort.getHomeDimension())) return false;
            return true;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not from a Land");
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public static enum IsInLand implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<IsInLand> CODEC;

        public MapCodec<IsInLand> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return MSDimensions.isLandDimension(entity.getServer(), (ResourceKey<Level>)entity.level().dimension());
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"Is not in a Land");
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public record IsEntityType(EntityType<?> entityType) implements NpcOnlyCondition
    {
        static final MapCodec<IsEntityType> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.ENTITY_TYPE.byNameCodec().fieldOf("entity_type").forGetter(IsEntityType::entityType)).apply((Applicative)instance, IsEntityType::new));

        public MapCodec<IsEntityType> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return this.entityType != null && entity.getType().equals(this.entityType);
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"NPC is wrong entity type");
        }
    }

    public record IsFromKingdom(EnumEntityKingdom kingdom) implements NpcOnlyCondition
    {
        static final MapCodec<IsFromKingdom> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)EnumEntityKingdom.CODEC.fieldOf("kingdom").forGetter(IsFromKingdom::kingdom)).apply((Applicative)instance, IsFromKingdom::new));

        public MapCodec<IsFromKingdom> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            CarapacianEntity carapacianEntity;
            return entity instanceof CarapacianEntity && (carapacianEntity = (CarapacianEntity)entity).getKingdom() == this.kingdom;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"NPC is not from the correct kingdom");
        }
    }

    public record IsCarapacian() implements NpcOnlyCondition
    {
        static final MapCodec<IsCarapacian> CODEC = MapCodec.unit(IsCarapacian::new);

        public MapCodec<IsCarapacian> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return entity instanceof CarapacianEntity;
        }

        @Override
        public Component getFailureTooltip() {
            return Component.literal((String)"NPC is not carapacian");
        }
    }

    public static enum FirstTimeGenerating implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<FirstTimeGenerating> CODEC;

        public MapCodec<FirstTimeGenerating> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            if (entity instanceof DialogueEntity) {
                DialogueEntity dialogueEntity = (DialogueEntity)entity;
                return !dialogueEntity.getDialogueComponent().hasGeneratedOnce();
            }
            return false;
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public static enum AlwaysTrue implements NpcOnlyCondition
    {
        INSTANCE;

        static final MapCodec<AlwaysTrue> CODEC;

        public MapCodec<AlwaysTrue> codec() {
            return CODEC;
        }

        @Override
        public boolean test(LivingEntity entity) {
            return true;
        }

        static {
            CODEC = MapCodec.unit((Object)INSTANCE);
        }
    }

    public static interface NpcOnlyCondition
    extends Condition {
        public boolean test(LivingEntity var1);

        @Override
        default public boolean test(LivingEntity entity, ServerPlayer player) {
            return this.test(entity);
        }

        @Override
        default public boolean isNpcOnly() {
            return true;
        }

        @Override
        default public boolean isPlayerOnly() {
            return false;
        }
    }
}

