/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.dialogue.condition;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mraof.minestuck.entity.dialogue.condition.Condition;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.LivingEntity;

@MethodsReturnNonnullByDefault
public record ListCondition(List<Condition> conditions, ListType type) implements Condition
{
    static final MapCodec<ListCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Condition.CODEC.listOf().fieldOf("conditions").forGetter(ListCondition::conditions), (App)ListType.CODEC.fieldOf("list_type").forGetter(ListCondition::type)).apply((Applicative)instance, ListCondition::new));

    public MapCodec<ListCondition> codec() {
        return CODEC;
    }

    @Override
    public boolean test(LivingEntity entity, ServerPlayer player) {
        return this.type.conditionMerger.test(this.conditions.stream().map(condition -> condition.test(entity, player)));
    }

    @Override
    public boolean isNpcOnly() {
        return this.conditions.stream().allMatch(Condition::isNpcOnly);
    }

    @Override
    public Component getFailureTooltip() {
        MutableComponent component = Component.empty();
        if (!this.conditions.isEmpty()) {
            component.append(this.conditions.get(0).getFailureTooltip());
        }
        for (int i = 1; i < this.conditions.size(); ++i) {
            component.append("\n").append(this.conditions.get(i).getFailureTooltip());
        }
        return component;
    }

    public static enum ListType implements StringRepresentable
    {
        ALL(stream -> stream.allMatch(result -> result)),
        ANY(stream -> stream.anyMatch(result -> result)),
        ONE(stream -> stream.filter(result -> result).count() == 1L),
        NONE(stream -> stream.noneMatch(result -> result));

        public static final Codec<ListType> CODEC;
        private final Predicate<Stream<Boolean>> conditionMerger;

        private ListType(Predicate<Stream<Boolean>> conditionMerger) {
            this.conditionMerger = conditionMerger;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            CODEC = StringRepresentable.fromEnum(ListType::values);
        }
    }
}

