/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.item.MSItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;

public class BarbasolBombEntity
extends ThrowableItemProjectile {
    private boolean shouldDestroy = true;

    public BarbasolBombEntity(EntityType<? extends BarbasolBombEntity> type, Level level) {
        super(type, level);
    }

    public BarbasolBombEntity(EntityType<? extends BarbasolBombEntity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public BarbasolBombEntity(EntityType<? extends BarbasolBombEntity> type, LivingEntity livingEntityIn, Level level, boolean shouldDestroy) {
        super(type, livingEntityIn, level);
        this.shouldDestroy = shouldDestroy;
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putBoolean("shouldDestroy", this.shouldDestroy);
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.shouldDestroy = compound.getBoolean("shouldDestroy");
    }

    protected void onHit(HitResult result) {
        if (!this.level().isClientSide) {
            this.level().explode(null, result.getLocation().x, result.getLocation().y, result.getLocation().z, 3.0f, this.shouldDestroy ? Level.ExplosionInteraction.TNT : Level.ExplosionInteraction.NONE);
        }
        this.discard();
    }

    protected Item getDefaultItem() {
        return (Item)MSItems.BARBASOL_BOMB.get();
    }
}

