/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.projectiles.ProjectileDamaging;
import com.mraof.minestuck.util.MSSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BouncingProjectileEntity
extends ThrowableItemProjectile {
    private int bounce;
    private int inBlockTicks = 0;
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(BouncingProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public BouncingProjectileEntity(EntityType<? extends BouncingProjectileEntity> type, Level level) {
        super(type, level);
    }

    public BouncingProjectileEntity(EntityType<? extends BouncingProjectileEntity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public BouncingProjectileEntity(EntityType<? extends BouncingProjectileEntity> type, LivingEntity owner, Level level, int maxTick) {
        super(type, owner, level);
        this.setLifespan(maxTick);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIFESPAN, (Object)200);
    }

    protected void onHit(HitResult result) {
        int damage = ProjectileDamaging.getDamageFromItem(this.getItemFromItemStack().getItem());
        ++this.bounce;
        double velocityX = this.getDeltaMovement().x;
        double velocityY = this.getDeltaMovement().y;
        double velocityZ = this.getDeltaMovement().z;
        double absVelocityX = Math.abs(velocityX);
        double absVelocityY = Math.abs(velocityY);
        double absVelocityZ = Math.abs(velocityZ);
        if (result.getType() == HitResult.Type.ENTITY) {
            if (!this.level().isClientSide) {
                Entity entity = ((EntityHitResult)result).getEntity();
                if (entity instanceof UnderlingEntity) {
                    entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage * 1.5f);
                } else if (entity != this.getOwner()) {
                    entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
                } else {
                    this.resetThrower();
                }
            }
            if (absVelocityX >= absVelocityY && absVelocityX >= absVelocityZ) {
                this.setDeltaMovement(-velocityX, velocityY, velocityZ);
            }
            if (absVelocityY >= absVelocityX && absVelocityY >= absVelocityZ) {
                this.setDeltaMovement(velocityX, -velocityY, velocityZ);
            }
            if (absVelocityZ >= absVelocityY && absVelocityZ >= absVelocityX) {
                this.setDeltaMovement(velocityX, velocityY, -velocityZ);
            }
        } else if (result.getType() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)result;
            Direction blockFace = blockResult.getDirection();
            BlockPos blockPos = blockResult.getBlockPos();
            if (Block.canSupportCenter((LevelReader)this.level(), (BlockPos)blockPos, (Direction)blockFace)) {
                if (!this.level().isClientSide) {
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), MSSoundEvents.ITEM_PROJECTILE_BOUNCE.get(), SoundSource.NEUTRAL, 0.6f, 2.0f);
                    ++this.bounce;
                }
                if (blockFace == Direction.EAST || blockFace == Direction.WEST) {
                    this.setDeltaMovement(-velocityX, velocityY, velocityZ);
                }
                if (blockFace == Direction.DOWN || blockFace == Direction.UP) {
                    this.setDeltaMovement(velocityX, -velocityY, velocityZ);
                }
                if (blockFace == Direction.NORTH || blockFace == Direction.SOUTH) {
                    this.setDeltaMovement(velocityX, velocityY, -velocityZ);
                }
            }
            if (Block.canSupportCenter((LevelReader)this.level(), (BlockPos)blockPos, (Direction)blockFace) && blockResult.isInside()) {
                ++this.inBlockTicks;
            }
        }
        if (this.bounce > 10) {
            this.resetThrower();
        }
    }

    public void resetThrower() {
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown(this.getItem().getItem(), 5);
            this.discard();
        }
    }

    public void tick() {
        Vec3 pos = this.position();
        this.xOld = pos.x;
        this.yOld = pos.y;
        this.zOld = pos.z;
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.2));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.005));
        }
        if (this.tickCount >= this.getLifespan() || this.inBlockTicks >= 2) {
            this.resetThrower();
        }
        super.tick();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.bounce = compound.getInt("bounce");
        this.setLifespan(compound.getInt("maxTick"));
        this.inBlockTicks = compound.getInt("inBlockTicks");
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("bounce", this.bounce);
        compound.putInt("maxTick", this.getLifespan());
        compound.putInt("inBlockTicks", this.inBlockTicks);
    }

    protected Item getDefaultItem() {
        return (Item)MSItems.SORCERERS_PINBALL.get();
    }

    public ItemStack getItemFromItemStack() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public int getLifespan() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifespan(int v) {
        this.entityData.set(LIFESPAN, (Object)v);
    }
}

