/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.projectiles.ProjectileDamaging;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ConsumableProjectileEntity
extends ThrowableItemProjectile {
    public ConsumableProjectileEntity(EntityType<? extends ConsumableProjectileEntity> type, Level level) {
        super(type, level);
    }

    public ConsumableProjectileEntity(EntityType<? extends ConsumableProjectileEntity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public ConsumableProjectileEntity(EntityType<? extends ConsumableProjectileEntity> type, LivingEntity livingEntityIn, Level level) {
        super(type, livingEntityIn, level);
    }

    private static boolean isNonCreativePlayer(Entity entity) {
        Player player;
        return entity instanceof Player && !(player = (Player)entity).isCreative();
    }

    protected void onHit(HitResult result) {
        int damage = ProjectileDamaging.getDamageFromItem(this.getItemFromItemStack().getItem());
        if (result.getType() == HitResult.Type.ENTITY) {
            Entity entity = ((EntityHitResult)result).getEntity();
            if (entity instanceof UnderlingEntity) {
                entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage * 1.5f);
            } else {
                entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
            }
        }
        if (ConsumableProjectileEntity.isNonCreativePlayer(this.getOwner())) {
            if (this.random.nextFloat() < 0.99f) {
                ItemEntity itemEntity = new ItemEntity(this.level(), this.getX(), this.getY(), this.getZ(), this.getItemFromItemStack());
                this.level().addFreshEntity((Entity)itemEntity);
            } else {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.ITEM_BREAK, SoundSource.NEUTRAL, 0.8f, 1.5f);
            }
        }
        this.discard();
    }

    protected Item getDefaultItem() {
        return (Item)MSItems.SHURIKEN.get();
    }

    public ItemStack getItemFromItemStack() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }
}

