/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.alchemy.GristGutter;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.network.GristRejectAnimationPacket;
import com.mraof.minestuck.player.GristCache;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class GristEntity
extends Entity
implements IEntityWithComplexSpawn {
    public int cycle;
    public int consumeDelay;
    public int gristAge = 0;
    private int gristHealth = 5;
    private GristType gristType = GristTypes.BUILD.get();
    private long gristValue = 1L;
    private Player closestPlayer;
    private int targetCycle;
    private int shakeTimer = 0;
    private static final int SHAKE_DURATION = 37;

    public static GristEntity create(EntityType<? extends GristEntity> type, Level level) {
        return new GristEntity(type, level);
    }

    public GristEntity(Level level, double x, double y, double z, GristAmount gristData) {
        super(MSEntityTypes.GRIST.get(), level);
        this.gristValue = gristData.amount();
        this.setPos(x, y, z);
        this.setYRot((float)(Math.random() * 360.0));
        this.setDeltaMovement(level.random.nextGaussian() * 0.2 - 0.1, level.random.nextGaussian() * 0.2, level.random.nextGaussian() * 0.2 - 0.1);
        this.gristType = gristData.type();
    }

    public GristEntity(EntityType<? extends GristEntity> type, Level level) {
        super(type, level);
    }

    public GristEntity(Level level, double x, double y, double z, GristAmount gristData, int pickupDelay) {
        this(level, x, y, z, gristData);
        this.consumeDelay = pickupDelay;
    }

    public static void spawnGristEntities(GristSet gristSet, Level level, double x, double y, double z, RandomSource rand, Consumer<GristEntity> postProcessor, int delay, int gusherCount) {
        for (GristAmount amount : gristSet.asAmounts()) {
            long spawnedCount;
            long countLeft = amount.amount();
            for (int i = 0; i < 10 && countLeft > 0L; countLeft -= spawnedCount, ++i) {
                spawnedCount = countLeft <= amount.amount() / 10L || i == gusherCount - 1 ? countLeft : Math.min(countLeft, (long)level.random.nextDouble() * countLeft + 1L);
                GristAmount spawnedAmount = amount.type().amount(spawnedCount);
                GristEntity entity = new GristEntity(level, x, y, z, spawnedAmount, delay);
                postProcessor.accept(entity);
                level.addFreshEntity((Entity)entity);
            }
        }
    }

    public static void spawnGristEntities(GristSet gristSet, Level level, double x, double y, double z, RandomSource rand, Consumer<GristEntity> postProcessor) {
        GristEntity.spawnGristEntities(gristSet, level, x, y, z, rand, postProcessor, 0, 10);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        this.gristHealth = (int)((float)this.gristHealth - amount);
        if (this.gristHealth <= 0) {
            this.discard();
        }
        return false;
    }

    public void setAnimationFromPacket() {
        this.shakeTimer = 37;
    }

    public float getShakeFactor() {
        return (float)this.shakeTimer / 37.0f;
    }

    public long getPlayerCacheRoom(Player entityIn) {
        if (entityIn instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entityIn;
            long cacheCapacity = GristCache.get(player).getRemainingCapacity(this.gristType);
            long gutterCapacity = GristGutter.get(player).map(GristGutter::getRemainingCapacity).orElse(0L);
            return gutterCapacity + cacheCapacity;
        }
        return 0L;
    }

    public void tick() {
        super.tick();
        long canPickUp = this.getPlayerCacheRoom(this.closestPlayer);
        if (this.level().isClientSide && this.shakeTimer > 0) {
            --this.shakeTimer;
        }
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        if (this.isInLava()) {
            this.setDeltaMovement(0.2, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        double d0 = (double)this.getDimensions(Pose.STANDING).width() * 2.0;
        if (this.targetCycle < this.cycle - 20 + this.getId() % 100) {
            if (this.closestPlayer == null || canPickUp < this.gristValue || this.closestPlayer.distanceToSqr((Entity)this) > d0 * d0) {
                this.closestPlayer = this.level().getNearestPlayer(this.getX(), this.getY(), this.getZ(), d0, (Predicate)new PlayerCanPickUpGristSelector());
            }
            this.targetCycle = this.cycle;
        }
        if (this.closestPlayer != null) {
            double d1 = (this.closestPlayer.getX() - this.getX()) / d0;
            double d2 = (this.closestPlayer.getY() + (double)this.closestPlayer.getEyeHeight() - this.getY()) / d0;
            double d3 = (this.closestPlayer.getZ() - this.getZ()) / d0;
            double d4 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
            double d5 = (double)this.getDimensions(Pose.STANDING).width() * 2.0 - d4;
            if (d5 > 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(d1 / d4 * d5 * 0.1, d2 / d4 * d5 * 0.1, d3 / d4 * d5 * 0.1));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = BlockPos.containing((double)this.getX(), (double)(this.getBoundingBox().minY - 1.0), (double)this.getZ());
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.cycle;
        ++this.gristAge;
        if (this.gristAge >= 6000) {
            this.discard();
        }
    }

    public void checkDespawn() {
        if (this.gristValue <= 0L) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putShort("Health", (short)this.gristHealth);
        compound.putShort("Age", (short)this.gristAge);
        compound.putLong("Value", (long)((short)this.gristValue));
        compound.put("Type", GristHelper.encodeGristType(this.gristType));
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.gristHealth = compound.getShort("Health") & 0xFF;
        this.gristAge = compound.getShort("Age");
        if (compound.contains("Value", 99)) {
            this.gristValue = compound.getLong("Value");
        }
        if (compound.contains("Type", 8)) {
            this.gristType = GristHelper.parseGristType(compound.get("Type")).orElseGet(GristTypes.BUILD);
        }
    }

    public void playerTouch(Player player) {
        ServerPlayer serverPlayer;
        block7: {
            block6: {
                if (!(player instanceof ServerPlayer)) break block6;
                serverPlayer = (ServerPlayer)player;
                if (!(player instanceof FakePlayer)) break block7;
            }
            return;
        }
        if (ServerEditHandler.isInEditmode(serverPlayer)) {
            return;
        }
        long canPickUp = this.getPlayerCacheRoom((Player)serverPlayer);
        if (canPickUp >= this.gristValue) {
            this.consumeGrist(IdentifierHandler.encode((Player)serverPlayer), true);
        } else {
            GristRejectAnimationPacket packet = GristRejectAnimationPacket.createPacket(this);
            PacketDistributor.sendToPlayersTrackingEntity((Entity)this, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public void consumeGrist(PlayerIdentifier identifier, boolean sound) {
        if (this.level().isClientSide) {
            throw new IllegalStateException("Grist entities shouldn't be consumed client-side.");
        }
        if (sound) {
            this.playSound(SoundEvents.ITEM_PICKUP, 0.1f, 0.5f * ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.8f));
        }
        GristCache.get(this.level(), identifier).addWithGutter(this.getAmount(), GristHelper.EnumSource.CLIENT);
        this.discard();
    }

    public boolean isAttackable() {
        return false;
    }

    public GristType getGristType() {
        return this.gristType;
    }

    public GristAmount getAmount() {
        return this.gristType.amount(this.gristValue);
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return super.getDimensions(poseIn).scale((float)Math.pow(this.gristValue, 0.25));
    }

    public float getSizeByValue() {
        return (float)(Math.pow(this.gristValue, 0.25) / 3.0);
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        GristType.STREAM_CODEC.encode((Object)buffer, (Object)this.gristType);
        buffer.writeLong(this.gristValue);
    }

    public void readSpawnData(RegistryFriendlyByteBuf data) {
        this.gristType = (GristType)GristType.STREAM_CODEC.decode((Object)data);
        this.gristValue = data.readLong();
    }

    public class PlayerCanPickUpGristSelector
    implements Predicate<Entity> {
        @Override
        public boolean test(@Nullable Entity player) {
            if (!(player instanceof Player)) {
                return false;
            }
            return GristEntity.this.getPlayerCacheRoom((Player)player) >= GristEntity.this.gristValue;
        }
    }
}

