/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.item.CustomBoatItem;
import com.mraof.minestuck.item.MSItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetalBoatEntity
extends Boat
implements IEntityWithComplexSpawn {
    private static final Logger LOGGER = LogManager.getLogger();
    @Nonnull
    private Type type = Type.IRON;
    private final List<ItemEntity> captureDropsCache = new ArrayList<ItemEntity>(5);

    public MetalBoatEntity(EntityType<? extends MetalBoatEntity> type, Level level) {
        super(type, level);
    }

    public MetalBoatEntity(Level level, double x, double y, double z, @Nonnull Type type) {
        super(MSEntityTypes.METAL_BOAT.get(), level);
        this.blocksBuilding = false;
        this.setPos(x, y, z);
        this.setDeltaMovement(Vec3.ZERO);
        this.xo = x;
        this.yo = y;
        this.zo = z;
        this.type = type;
    }

    public Type boatType() {
        return this.type;
    }

    public boolean hurt(DamageSource source, float amount) {
        return super.hurt(source, amount * this.type.damageModifier);
    }

    public void tick() {
        Boat.Status status = this.getStatus();
        if (status == Boat.Status.IN_WATER) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.1, 0.0));
        } else if (status == Boat.Status.UNDER_WATER) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.02, 0.0));
        }
        super.tick();
    }

    public void setDeltaMovement(Vec3 motionIn) {
        super.setDeltaMovement(new Vec3(motionIn.x, -Math.abs(motionIn.y), motionIn.z));
    }

    protected void checkFallDamage(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        Collection prevCapture = this.captureDrops(this.captureDropsCache);
        super.checkFallDamage(y, onGroundIn, state, pos);
        if (!this.captureDrops(prevCapture).isEmpty()) {
            this.captureDropsCache.clear();
            for (int i = 0; i < 3; ++i) {
                this.spawnAtLocation((ItemLike)this.getDroppedItem());
            }
        }
    }

    private Item getDroppedItem() {
        return this.type.droppedItem.get();
    }

    public Item getDropItem() {
        return this.type.boatItem.get();
    }

    public void setVariant(Boat.Type pBoatType) {
        throw new UnsupportedOperationException();
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("Type", this.type.asString());
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.type = Type.fromString(compound.getString("Type"));
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeUtf(this.type.asString());
    }

    public void readSpawnData(RegistryFriendlyByteBuf additionalData) {
        this.type = Type.fromString(additionalData.readUtf(16));
    }

    public static enum Type implements CustomBoatItem.BoatProvider
    {
        IRON(0.6666667f, () -> Items.IRON_INGOT, (Supplier<Item>)MSItems.IRON_BOAT, ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/entity/iron_boat.png")),
        GOLD(1.0f, () -> Items.GOLD_INGOT, (Supplier<Item>)MSItems.GOLD_BOAT, ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/entity/gold_boat.png"));

        private final float damageModifier;
        private final Supplier<Item> droppedItem;
        private final Supplier<Item> boatItem;
        private final ResourceLocation boatTexture;

        private Type(float damageModifier, Supplier<Item> droppedItem, Supplier<Item> boatItem, ResourceLocation boatTexture) {
            this.damageModifier = damageModifier;
            this.droppedItem = droppedItem;
            this.boatItem = boatItem;
            this.boatTexture = boatTexture;
        }

        public String asString() {
            return this.toString().toLowerCase();
        }

        public static Type fromString(String name) {
            for (Type type : Type.values()) {
                if (!type.asString().equals(name)) continue;
                return type;
            }
            LOGGER.error("No minestuck boat type matching string \"{}\"", (Object)name);
            return IRON;
        }

        public ResourceLocation getBoatTexture() {
            return this.boatTexture;
        }

        @Override
        public Entity createBoat(ItemStack stack, Level level, double x, double y, double z) {
            return new MetalBoatEntity(level, x, y, z, this);
        }
    }
}

