/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.entity.MSEntityTypes;
import java.util.ArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;

public class PosterEntity
extends Painting {
    private ItemStack droppedItem;

    public PosterEntity(Level pLevel) {
        super(MSEntityTypes.POSTER.get(), pLevel);
    }

    public PosterEntity(Level level, BlockPos pos, ItemStack droppedItem) {
        this(level);
        this.pos = pos;
        this.droppedItem = droppedItem;
    }

    public PosterEntity(Level pLevel, BlockPos pPos, Direction pDirection, Holder<PaintingVariant> pVariant, ItemStack droppedItem) {
        super(pLevel, pPos, pDirection, pVariant);
        this.droppedItem = droppedItem;
    }

    public PosterEntity(EntityType<PosterEntity> hangingArtEntityEntityType, Level level) {
        super(hangingArtEntityEntityType, level);
    }

    public void dropItem(@Nullable Entity pBrokenEntity) {
        if (this.level().getGameRules().getBoolean(GameRules.RULE_DOENTITYDROPS)) {
            Player player;
            this.playSound(SoundEvents.PAINTING_BREAK, 1.0f, 1.0f);
            if (pBrokenEntity instanceof Player && (player = (Player)pBrokenEntity).hasInfiniteMaterials()) {
                return;
            }
            this.spawnAtLocation(this.droppedItem);
        }
    }

    public void readAdditionalSaveData(CompoundTag pCompound) {
        this.droppedItem = ItemStack.parseOptional((HolderLookup.Provider)this.registryAccess(), (CompoundTag)pCompound.getCompound("item"));
    }

    public void addAdditionalSaveData(CompoundTag pCompound) {
        pCompound.put("item", this.droppedItem.save((HolderLookup.Provider)this.registryAccess()));
    }

    private static int variantArea(Holder<PaintingVariant> p_218899_) {
        return ((PaintingVariant)p_218899_.value()).area();
    }

    public static Optional<PosterEntity> createArt(Level pLevel, BlockPos pPos, Direction pDirection, ItemStack itemStack, TagKey<PaintingVariant> pool) {
        PosterEntity painting = new PosterEntity(pLevel, pPos, itemStack);
        ArrayList<Holder> list = new ArrayList<Holder>();
        pLevel.registryAccess().registryOrThrow(Registries.PAINTING_VARIANT).getTagOrEmpty(pool).forEach(list::add);
        if (list.isEmpty()) {
            return Optional.empty();
        }
        painting.setDirection(pDirection);
        list.removeIf(p_344343_ -> {
            painting.setVariant((Holder)p_344343_);
            return !painting.survives();
        });
        if (list.isEmpty()) {
            return Optional.empty();
        }
        int i = list.stream().mapToInt(PosterEntity::variantArea).max().orElse(0);
        list.removeIf(p_218883_ -> PosterEntity.variantArea((Holder<PaintingVariant>)p_218883_) < i);
        Optional optional = Util.getRandomSafe(list, (RandomSource)painting.random);
        if (optional.isEmpty()) {
            return Optional.empty();
        }
        painting.setVariant((Holder)optional.get());
        painting.setDirection(pDirection);
        return Optional.of(painting);
    }

    public ItemStack getItem() {
        return this.droppedItem;
    }
}

