/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.weapon.projectiles.ProjectileDamaging;
import com.mraof.minestuck.util.MSSoundEvents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ReturningProjectileEntity
extends ThrowableItemProjectile {
    private int bounce;
    private int inBlockTicks = 0;
    private static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(ReturningProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Boolean> NOCLIP = SynchedEntityData.defineId(ReturningProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);

    public ReturningProjectileEntity(EntityType<? extends ReturningProjectileEntity> type, Level level) {
        super(type, level);
    }

    public ReturningProjectileEntity(EntityType<? extends ReturningProjectileEntity> type, double x, double y, double z, Level level) {
        super(type, x, y, z, level);
    }

    public ReturningProjectileEntity(EntityType<? extends ReturningProjectileEntity> type, LivingEntity livingEntityIn, Level level, int maxTick, boolean noBlockCollision) {
        super(type, livingEntityIn, level);
        this.setLifespan(maxTick);
        this.setNoclip(noBlockCollision);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LIFESPAN, (Object)200);
        builder.define(NOCLIP, (Object)false);
    }

    protected void onHit(HitResult result) {
        int damage = ProjectileDamaging.getDamageFromItem(this.getItemFromItemStack().getItem());
        if (result.getType() == HitResult.Type.ENTITY) {
            this.setDeltaMovement(this.getDeltaMovement().scale(-1.05));
            if (!this.level().isClientSide) {
                ++this.bounce;
                Entity entity = ((EntityHitResult)result).getEntity();
                if (entity instanceof UnderlingEntity) {
                    entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage * 1.5f);
                } else if (entity != this.getOwner()) {
                    entity.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), (float)damage);
                } else {
                    this.resetThrower();
                }
            }
        } else if (result.getType() == HitResult.Type.BLOCK && !this.isNoclip()) {
            BlockHitResult blockResult = (BlockHitResult)result;
            Direction blockFace = blockResult.getDirection();
            BlockPos blockPos = blockResult.getBlockPos();
            if (Block.canSupportCenter((LevelReader)this.level(), (BlockPos)blockPos, (Direction)blockFace)) {
                this.setDeltaMovement(this.getDeltaMovement().scale(-1.05));
                if (!this.level().isClientSide) {
                    ++this.bounce;
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), MSSoundEvents.ITEM_PROJECTILE_BOUNCE.get(), SoundSource.NEUTRAL, 0.6f, 2.0f);
                }
            }
            if (Block.canSupportCenter((LevelReader)this.level(), (BlockPos)blockPos, (Direction)blockFace) && blockResult.isInside()) {
                ++this.inBlockTicks;
            }
        }
        if (this.bounce > 10) {
            this.resetThrower();
        }
    }

    public void resetThrower() {
        Entity entity = this.getOwner();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCooldowns().addCooldown(this.getItem().getItem(), 5);
            this.discard();
        }
    }

    public void tick() {
        Vec3 pos = this.position();
        this.xOld = pos.x;
        this.yOld = pos.y;
        this.zOld = pos.z;
        if (this.isInWater()) {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.2));
        } else {
            this.setDeltaMovement(this.getDeltaMovement().scale(1.005));
        }
        if (this.tickCount >= this.getLifespan() || this.inBlockTicks >= 2) {
            this.resetThrower();
        }
        super.tick();
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        this.bounce = compound.getInt("bounce");
        this.setLifespan(compound.getInt("maxTick"));
        this.inBlockTicks = compound.getInt("inBlockTicks");
        this.setNoclip(compound.getBoolean("noBlockCollision"));
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("bounce", this.bounce);
        compound.putInt("maxTick", this.getLifespan());
        compound.putInt("inBlockTicks", this.inBlockTicks);
        compound.putBoolean("noBlockCollision", this.isNoclip());
    }

    protected Item getDefaultItem() {
        return (Item)MSItems.CHAKRAM.get();
    }

    public ItemStack getItemFromItemStack() {
        ItemStack itemstack = this.getItem();
        return itemstack.isEmpty() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public int getLifespan() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifespan(int v) {
        this.entityData.set(LIFESPAN, (Object)v);
    }

    public boolean isNoclip() {
        return (Boolean)this.entityData.get(NOCLIP);
    }

    public void setNoclip(boolean v) {
        this.entityData.set(NOCLIP, (Object)v);
    }
}

