/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.item;

import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.entity.MSEntityTypes;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.neoforged.neoforge.entity.IEntityWithComplexSpawn;

@ParametersAreNonnullByDefault
public class VitalityGelEntity
extends Entity
implements IEntityWithComplexSpawn {
    public int cycle;
    public int age = 0;
    private int healAmount = 1;
    private int health = 5;
    private Player closestPlayer;
    private int targetCycle;
    public float animationOffset;

    public VitalityGelEntity(Level level, double x, double y, double z, int healAmount) {
        this(MSEntityTypes.VITALITY_GEL.get(), level, x, y, z, healAmount);
    }

    protected VitalityGelEntity(EntityType<? extends VitalityGelEntity> type, Level level, double x, double y, double z, int healAmount) {
        super(type, level);
        this.setPos(x, y, z);
        this.setYRot((float)(Math.random() * 360.0));
        this.setDeltaMovement(level.random.nextGaussian() * 0.2 - 0.1, level.random.nextGaussian() * 0.2, level.random.nextGaussian() * 0.2 - 0.1);
        this.healAmount = healAmount;
    }

    public VitalityGelEntity(EntityType<? extends VitalityGelEntity> type, Level level) {
        super(type, level);
        this.animationOffset = (float)(Math.random() * Math.PI * 2.0);
    }

    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (this.isInvulnerableTo(source)) {
            return false;
        }
        this.markHurt();
        this.health = (int)((float)this.health - amount);
        if (this.health <= 0) {
            this.discard();
        }
        return false;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    public void tick() {
        super.tick();
        this.xo = this.getX();
        this.yo = this.getY();
        this.zo = this.getZ();
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.03, 0.0));
        if (this.isInLava()) {
            this.setDeltaMovement(0.2, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f);
            this.playSound(SoundEvents.GENERIC_BURN, 0.4f, 2.0f + this.random.nextFloat() * 0.4f);
        }
        double d0 = (double)this.getDimensions(Pose.STANDING).width() * 2.0;
        if (this.targetCycle < this.cycle - 20 + this.getId() % 100) {
            if (this.closestPlayer == null || this.closestPlayer.distanceToSqr((Entity)this) > d0 * d0) {
                this.closestPlayer = this.level().getNearestPlayer((Entity)this, d0);
            }
            this.targetCycle = this.cycle;
        }
        if (this.closestPlayer != null) {
            double d1 = (this.closestPlayer.getX() - this.getX()) / d0;
            double d2 = (this.closestPlayer.getY() + (double)this.closestPlayer.getEyeHeight() - this.getY()) / d0;
            double d3 = (this.closestPlayer.getZ() - this.getZ()) / d0;
            double d4 = Math.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
            double d5 = (double)this.getDimensions(Pose.STANDING).width() * 2.0 - d4;
            if (d5 > 0.0) {
                this.setDeltaMovement(this.getDeltaMovement().add(d1 / d4 * d5 * 0.1, d2 / d4 * d5 * 0.1, d3 / d4 * d5 * 0.1));
            }
        }
        this.move(MoverType.SELF, this.getDeltaMovement());
        float f = 0.98f;
        if (this.onGround()) {
            BlockPos pos = new BlockPos(Mth.floor((double)this.getX()), Mth.floor((double)this.getBoundingBox().minY) - 1, Mth.floor((double)this.getZ()));
            f = this.level().getBlockState(pos).getFriction((LevelReader)this.level(), pos, (Entity)this) * 0.98f;
        }
        this.setDeltaMovement(this.getDeltaMovement().multiply((double)f, 0.98, (double)f));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(1.0, -0.9, 1.0));
        }
        ++this.cycle;
        ++this.age;
        if (this.age >= 6000) {
            this.discard();
        }
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putShort("health", (short)((byte)this.health));
        compound.putShort("age", (short)this.age);
        compound.putShort("amount", (short)this.healAmount);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.health = compound.getShort("health") & 0xFF;
        this.age = compound.getShort("age");
        if (compound.contains("amount", 99)) {
            this.healAmount = compound.getShort("amount");
        }
    }

    public void playerTouch(Player player) {
        ServerPlayer serverPlayer;
        if (this.level().isClientSide && ClientEditmodeData.isInEditmode()) {
            return;
        }
        if (player instanceof ServerPlayer && ServerEditHandler.isInEditmode(serverPlayer = (ServerPlayer)player)) {
            return;
        }
        if (!this.level().isClientSide) {
            this.playSound(SoundEvents.ITEM_PICKUP, 0.1f, 0.5f * ((this.random.nextFloat() - this.random.nextFloat()) * 0.7f + 1.8f));
            player.heal((float)this.healAmount);
        }
        this.discard();
    }

    public boolean isAttackable() {
        return false;
    }

    public EntityDimensions getDimensions(Pose poseIn) {
        return super.getDimensions(poseIn).scale((float)this.healAmount);
    }

    public float getSizeByValue() {
        return (float)this.healAmount / 4.0f;
    }

    public void writeSpawnData(RegistryFriendlyByteBuf buffer) {
        buffer.writeInt(this.healAmount);
    }

    public void readSpawnData(RegistryFriendlyByteBuf data) {
        this.healAmount = data.readInt();
    }
}

