/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.ai.attack.FireballShootGoal;
import com.mraof.minestuck.entity.ai.attack.MoveToTargetGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.entity.underling.BasiliskPartEntity;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.entity.PartEntity;
import org.joml.Vector3d;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@ParametersAreNonnullByDefault
public class BasiliskEntity
extends UnderlingEntity
implements GeoEntity {
    public static final PhasedMobAnimation TAIL_SWING_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.SWING, 12, true, false), 1, 2, 3, 6);
    public static final PhasedMobAnimation BITE_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.BITE, 10, true, false), 1, 2, 3, 5);
    public static final PhasedMobAnimation SHOOT_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.SHOOT, 14, true, true), 1, 4, 6, 7);
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenLoop("run");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation DIE_ANIMATION = RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation BITE_ANIMATION = RawAnimation.begin().then("bite", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation TAIL_WHIP_ANIMATION = RawAnimation.begin().then("tail_whip", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SHOOT_ANIMATION = RawAnimation.begin().then("shoot", Animation.LoopType.PLAY_ONCE);
    private final BasiliskPartEntity[] parts;
    private final BasiliskPartEntity head = new BasiliskPartEntity(this, 2.1f, 2.1f);
    private final BasiliskPartEntity body = new BasiliskPartEntity(this, 2.5f, 1.9f);
    private final BasiliskPartEntity tail = new BasiliskPartEntity(this, 1.8f, 1.8f);
    private final BasiliskPartEntity tailEnd = new BasiliskPartEntity(this, 1.4f, 1.3f);

    public BasiliskEntity(EntityType<? extends BasiliskEntity> type, Level level) {
        super(type, level, 5);
        this.parts = new BasiliskPartEntity[]{this.head, this.body, this.tail, this.tailEnd};
        this.noCulling = true;
        this.setId(ENTITY_COUNTER.getAndAdd(this.parts.length + 1) + 1);
    }

    public void setId(int id) {
        super.setId(id);
        for (int i = 0; i < this.parts.length; ++i) {
            this.parts[i].setId(id + i + 1);
        }
    }

    public void restoreFrom(Entity entity) {
        if (entity instanceof BasiliskPartEntity) {
            throw new UnsupportedOperationException("Tried to restore a basilisk from a basilisk part. Might be trying to copy a part and accidentally creating a new basilisk!");
        }
        super.restoreFrom(entity);
    }

    public static AttributeSupplier.Builder basiliskAttributes() {
        return UnderlingEntity.underlingAttributes().add(Attributes.MAX_HEALTH, 85.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.6).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ATTACK_SPEED, 0.5);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<BasiliskEntity>(this, TAIL_SWING_PROPERTIES, 0.0f, 3.5f, 40, 180.0f, 90.0f));
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<BasiliskEntity>(this, BITE_PROPERTIES, 1.0f, -1.0f, 40, 0.0f, 40.0f));
        this.goalSelector.addGoal(3, new FireballShootGoal<BasiliskEntity>(this, SHOOT_PROPERTIES, -1.0f, 25.0f, 180));
        this.goalSelector.addGoal(3, (Goal)new MoveToTargetGoal(this, 1.0f, false));
    }

    protected SoundEvent getAmbientSound() {
        return MSSoundEvents.ENTITY_BASILISK_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MSSoundEvents.ENTITY_BASILISK_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return MSSoundEvents.ENTITY_BASILISK_DEATH.get();
    }

    @Override
    public MutableGristSet getGristSpoils() {
        return GristHelper.generateUnderlingGristDrops(this, this.damageMap, 6.0);
    }

    @Override
    protected int getVitalityGel() {
        return this.random.nextInt(3) + 4;
    }

    @Override
    protected void onGristTypeUpdated(GristType type) {
        super.onGristTypeUpdated(type);
        this.applyGristModifier((Holder<Attribute>)Attributes.MAX_HEALTH, 20.0f * type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.applyGristModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 2.7 * (double)type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.xpReward = (int)(6.0f * type.getPower() + 4.0f);
    }

    @Override
    public void die(DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (this.dead && !this.level().isClientSide) {
            this.computePlayerProgress((int)(30.0 + 2.4 * (double)this.getGristType().getPower()));
            BasiliskEntity.firstKillBonus(entity, EcheladderBonusType.BASILISK);
        }
    }

    public boolean canBeCollidedWith() {
        return true;
    }

    public boolean isPickable() {
        return true;
    }

    public void aiStep() {
        super.aiStep();
        Vector3d[] positions = new Vector3d[this.parts.length];
        for (int j = 0; j < this.parts.length; ++j) {
            positions[j] = new Vector3d(this.parts[j].getX(), this.parts[j].getY(), this.parts[j].getZ());
        }
        float bodyAngle = this.yBodyRot * ((float)Math.PI / 180);
        double xOffset = Math.sin(bodyAngle);
        double zOffset = -Math.cos(bodyAngle);
        this.updatePart(this.body, 0.0, 0.0, 0.0);
        this.updatePart(this.head, xOffset * -2.5, 0.3, zOffset * -2.5);
        this.updatePart(this.tail, xOffset * 2.5, 0.0, zOffset * 2.5);
        this.updatePart(this.tailEnd, xOffset * 4.5, 1.0, zOffset * 4.5);
        for (int l = 0; l < this.parts.length; ++l) {
            this.parts[l].xo = positions[l].x;
            this.parts[l].yo = positions[l].y;
            this.parts[l].zo = positions[l].z;
            this.parts[l].xOld = positions[l].x;
            this.parts[l].yOld = positions[l].y;
            this.parts[l].zOld = positions[l].z;
        }
    }

    private void updatePart(BasiliskPartEntity part, double xOffset, double yOffset, double zOffset) {
        part.setPos(this.getX() + xOffset, this.getY() + yOffset, this.getZ() + zOffset);
    }

    public boolean isMultipartEntity() {
        return true;
    }

    public PartEntity<?>[] getParts() {
        return this.parts;
    }

    @Override
    public void initiationPhaseStart(MobAnimation.Action animation) {
        if (animation == MobAnimation.Action.SWING) {
            this.playSound(MSSoundEvents.ENTITY_SWOOSH.get(), 1.0f, 2.0f);
        }
    }

    @Override
    public void contactPhaseStart(MobAnimation.Action animation) {
        if (animation == MobAnimation.Action.BITE) {
            this.playSound(MSSoundEvents.ENTITY_BITE.get(), 1.0f, 1.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idleAnimation", BasiliskEntity::idleAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkAnimation", BasiliskEntity::walkAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 3.5));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathAnimation", BasiliskEntity::deathAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackAnimation", BasiliskEntity::attackAnimation));
    }

    private static PlayState idleAnimation(AnimationState<BasiliskEntity> state) {
        return PlayState.CONTINUE;
    }

    private static PlayState walkAnimation(AnimationState<BasiliskEntity> state) {
        if (!MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable())) {
            return PlayState.STOP;
        }
        if (((BasiliskEntity)state.getAnimatable()).isAggressive()) {
            state.getController().setAnimation(RUN_ANIMATION);
        } else {
            state.getController().setAnimation(WALK_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    private static PlayState deathAnimation(AnimationState<BasiliskEntity> state) {
        if (((BasiliskEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState attackAnimation(AnimationState<BasiliskEntity> state) {
        MobAnimation.Action action = ((BasiliskEntity)state.getAnimatable()).getCurrentAction();
        if (action == MobAnimation.Action.BITE) {
            state.getController().setAnimation(BITE_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (action == MobAnimation.Action.SWING) {
            state.getController().setAnimation(TAIL_WHIP_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (action == MobAnimation.Action.SHOOT) {
            state.getController().setAnimation(SHOOT_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        state.getController().setAnimationSpeed(MobAnimation.getAttributeAffectedSpeed((LivingEntity)state.getAnimatable(), (Holder<Attribute>)Attributes.ATTACK_SPEED));
        return PlayState.STOP;
    }
}

