/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.entity.underling.BasiliskEntity;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.entity.PartEntity;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class BasiliskPartEntity
extends PartEntity<BasiliskEntity> {
    private final BasiliskEntity parentMob;
    private final EntityDimensions size;

    public BasiliskPartEntity(BasiliskEntity parent, float width, float height) {
        super((Entity)parent);
        this.size = EntityDimensions.scalable((float)width, (float)height);
        this.refreshDimensions();
        this.parentMob = parent;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
    }

    public boolean isPickable() {
        return true;
    }

    public boolean canChangeDimensions(Level oldLevel, Level newLevel) {
        return false;
    }

    public boolean hurt(DamageSource source, float amount) {
        return !this.isInvulnerableTo(source) && this.parentMob.hurt(source, amount);
    }

    public boolean is(Entity pEntity) {
        return this == pEntity || this.parentMob == pEntity;
    }

    public EntityDimensions getDimensions(Pose pPose) {
        return this.size;
    }
}

