/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.ai.attack.MoveToTargetGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@ParametersAreNonnullByDefault
public class GiclopsEntity
extends UnderlingEntity
implements GeoEntity {
    public static final PhasedMobAnimation KICK_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.KICK, 40, true, true), 18, 20, 22, 1);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation KICK_ANIMATION = RawAnimation.begin().then("kick", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation DEATH_ANIMATION = RawAnimation.begin().then("death", Animation.LoopType.PLAY_ONCE);

    public GiclopsEntity(EntityType<? extends GiclopsEntity> type, Level level) {
        super(type, level, 7);
    }

    public static AttributeSupplier.Builder giclopsAttributes() {
        return UnderlingEntity.underlingAttributes().add(Attributes.MAX_HEALTH, 210.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.9).add(Attributes.MOVEMENT_SPEED, 0.2).add(Attributes.ATTACK_DAMAGE, 18.0).add(Attributes.ATTACK_SPEED, 1.0).add(Attributes.STEP_HEIGHT, 2.0);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<GiclopsEntity>(this, KICK_PROPERTIES));
        this.goalSelector.addGoal(3, (Goal)new MoveToTargetGoal(this, 1.0f, false));
    }

    protected SoundEvent getAmbientSound() {
        return MSSoundEvents.ENTITY_GICLOPS_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MSSoundEvents.ENTITY_GICLOPS_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return MSSoundEvents.ENTITY_GICLOPS_DEATH.get();
    }

    @Override
    public MutableGristSet getGristSpoils() {
        return GristHelper.generateUnderlingGristDrops(this, this.damageMap, 10.0);
    }

    @Override
    protected int getVitalityGel() {
        return this.random.nextInt(4) + 5;
    }

    @Override
    protected void onGristTypeUpdated(GristType type) {
        super.onGristTypeUpdated(type);
        this.applyGristModifier((Holder<Attribute>)Attributes.MAX_HEALTH, 46.0f * type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.applyGristModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 4.5 * (double)type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.xpReward = (int)(7.0f * type.getPower() + 5.0f);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (!this.level().isClientSide && ((Boolean)MinestuckConfig.SERVER.disableGiclops.get()).booleanValue()) {
            this.discard();
        }
    }

    @Override
    public void die(DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (this.dead && !this.level().isClientSide) {
            this.computePlayerProgress((int)(200.0f + 3.0f * this.getGristType().getPower()));
            GiclopsEntity.firstKillBonus(entity, EcheladderBonusType.GICLOPS);
        }
    }

    public boolean isInWall() {
        return false;
    }

    public boolean updateFluidHeightAndDoFluidPushing(TagKey<Fluid> fluidTag, double fluidFactor) {
        AABB realBox = this.getBoundingBox();
        this.setBoundingBox(new AABB(realBox.minX, realBox.maxY - 1.0, realBox.minZ, realBox.maxX, realBox.maxY, realBox.maxZ));
        boolean result = super.updateFluidHeightAndDoFluidPushing(fluidTag, fluidFactor);
        this.setBoundingBox(realBox);
        return result;
    }

    public boolean isPickable() {
        return true;
    }

    @Override
    public void initiationPhaseStart(MobAnimation.Action animation) {
        if (animation == MobAnimation.Action.KICK) {
            this.playSound(MSSoundEvents.ENTITY_SWOOSH.get(), 0.75f, 0.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idleAnimation", GiclopsEntity::idleAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkAnimation", GiclopsEntity::walkAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 5.0));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackAnimation", GiclopsEntity::attackAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathAnimation", GiclopsEntity::deathAnimation));
    }

    private static PlayState idleAnimation(AnimationState<GiclopsEntity> state) {
        if (state.isMoving() || ((GiclopsEntity)state.getAnimatable()).getCurrentAction() != MobAnimation.Action.IDLE) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    private static PlayState walkAnimation(AnimationState<GiclopsEntity> state) {
        if (MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable())) {
            state.getController().setAnimation(WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState attackAnimation(AnimationState<GiclopsEntity> state) {
        MobAnimation.Action action = ((GiclopsEntity)state.getAnimatable()).getCurrentAction();
        if (action == MobAnimation.Action.KICK) {
            state.getController().setAnimation(KICK_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        state.getController().setAnimationSpeed(MobAnimation.getAttributeAffectedSpeed((LivingEntity)state.getAnimatable(), (Holder<Attribute>)Attributes.ATTACK_SPEED));
        return PlayState.STOP;
    }

    private static PlayState deathAnimation(AnimationState<GiclopsEntity> state) {
        if (((GiclopsEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DEATH_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }
}

