/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.ai.attack.MoveToTargetGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.FakePlayer;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@ParametersAreNonnullByDefault
public class ImpEntity
extends UnderlingEntity
implements GeoEntity {
    public static final PhasedMobAnimation CLAW_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.CLAW, 8, true, false), 2, 5, 10, 16);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("animation.minestuck.imp.idle");
    private static final RawAnimation RUN_ANIMATION = RawAnimation.begin().thenLoop("animation.minestuck.imp.run");
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("animation.minestuck.imp.walk");
    private static final RawAnimation RUNARMS_ANIMATION = RawAnimation.begin().thenLoop("animation.minestuck.imp.runarms");
    private static final RawAnimation WALKARMS_ANIMATION = RawAnimation.begin().thenLoop("animation.minestuck.imp.walkarms");
    private static final RawAnimation DIE_ANIMATION = RawAnimation.begin().then("animation.minestuck.imp.die", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation SCRATCH_ANIMATION = RawAnimation.begin().then("animation.minestuck.imp.scratch", Animation.LoopType.PLAY_ONCE);

    public ImpEntity(EntityType<? extends ImpEntity> type, Level level) {
        super(type, level, 1);
    }

    public static AttributeSupplier.Builder impAttributes() {
        return UnderlingEntity.underlingAttributes().add(Attributes.MAX_HEALTH, 6.0).add(Attributes.MOVEMENT_SPEED, 0.28).add(Attributes.ATTACK_DAMAGE, 2.0).add(Attributes.ATTACK_SPEED, 2.0);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<ImpEntity>(this, CLAW_PROPERTIES));
        this.goalSelector.addGoal(3, (Goal)new MoveToTargetGoal(this, 1.0f, false));
    }

    @Override
    public MutableGristSet getGristSpoils() {
        return GristHelper.generateUnderlingGristDrops(this, this.damageMap, 1.0);
    }

    protected SoundEvent getAmbientSound() {
        return MSSoundEvents.ENTITY_IMP_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MSSoundEvents.ENTITY_IMP_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return MSSoundEvents.ENTITY_IMP_DEATH.get();
    }

    @Override
    protected int getVitalityGel() {
        return this.random.nextInt(3) + 1;
    }

    @Override
    protected void onGristTypeUpdated(GristType type) {
        super.onGristTypeUpdated(type);
        this.applyGristModifier((Holder<Attribute>)Attributes.MAX_HEALTH, 8.0f * type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.applyGristModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, Math.ceil(type.getPower()), AttributeModifier.Operation.ADD_VALUE);
        this.xpReward = (int)(3.0f * type.getPower() + 1.0f);
    }

    @Override
    public void die(DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (this.dead && !this.level().isClientSide) {
            this.computePlayerProgress((int)(5.0f + 2.0f * this.getGristType().getPower()));
            ImpEntity.firstKillBonus(entity, EcheladderBonusType.IMP);
        }
    }

    @Override
    protected boolean isAppropriateTarget(LivingEntity entity) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            if (!(entity instanceof FakePlayer)) {
                return Echeladder.get(player).getRung() < 16;
            }
        }
        return super.isAppropriateTarget(entity);
    }

    @Override
    public void initiationPhaseStart(MobAnimation.Action animation) {
        if (animation == MobAnimation.Action.CLAW) {
            this.playSound(MSSoundEvents.ENTITY_SWOOSH.get(), 0.2f, 1.75f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "idleAnimation", ImpEntity::idleAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkArmsAnimation", ImpEntity::walkArmsAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 1.785));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkAnimation", ImpEntity::walkAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 1.785));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathAnimation", ImpEntity::deathAnimation).setAnimationSpeed(0.7));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackAnimation", ImpEntity::attackAnimation));
    }

    private static PlayState idleAnimation(AnimationState<ImpEntity> state) {
        if (!state.isMoving() && !((ImpEntity)state.getAnimatable()).isAggressive()) {
            state.getController().setAnimation(IDLE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState walkAnimation(AnimationState<ImpEntity> state) {
        if (!MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable())) {
            return PlayState.STOP;
        }
        if (((ImpEntity)state.getAnimatable()).isAggressive()) {
            state.getController().setAnimation(RUN_ANIMATION);
        } else {
            state.getController().setAnimation(WALK_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    private static PlayState walkArmsAnimation(AnimationState<ImpEntity> state) {
        if (!MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable()) || ((ImpEntity)state.getAnimatable()).isActive()) {
            return PlayState.STOP;
        }
        if (((ImpEntity)state.getAnimatable()).isAggressive()) {
            state.getController().setAnimation(RUNARMS_ANIMATION);
        } else {
            state.getController().setAnimation(WALKARMS_ANIMATION);
        }
        return PlayState.CONTINUE;
    }

    private static PlayState deathAnimation(AnimationState<ImpEntity> state) {
        if (((ImpEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState attackAnimation(AnimationState<ImpEntity> state) {
        if (((ImpEntity)state.getAnimatable()).isActive()) {
            state.getController().setAnimation(SCRATCH_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        state.getController().setAnimationSpeed(MobAnimation.getAttributeAffectedSpeed((LivingEntity)state.getAnimatable(), (Holder<Attribute>)Attributes.ATTACK_SPEED));
        return PlayState.STOP;
    }
}

