/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.ai.attack.MoveToTargetGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@ParametersAreNonnullByDefault
public class LichEntity
extends UnderlingEntity
implements GeoEntity {
    public static final PhasedMobAnimation CLAW_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.CLAW, 10, false, false), 11, 13, 16, 22);
    private static final RawAnimation IDLE_ANIMATION = RawAnimation.begin().thenLoop("idle");
    private static final RawAnimation CLAW_LEGS_ANIMATION = RawAnimation.begin().then("claw_legs", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("walk");
    private static final RawAnimation DIE_ANIMATION = RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE);
    private static final RawAnimation CLAW_ARMS_ANIMATION = RawAnimation.begin().then("claw_arms", Animation.LoopType.PLAY_ONCE);
    private static final ResourceLocation RESISTANCE_MODIFIER_ATTACKING_ID = Minestuck.id("attacking_resistance");
    private static final AttributeModifier RESISTANCE_MODIFIER_ATTACKING = new AttributeModifier(RESISTANCE_MODIFIER_ATTACKING_ID, 1.0, AttributeModifier.Operation.ADD_VALUE);

    public LichEntity(EntityType<? extends LichEntity> type, Level level) {
        super(type, level, 7);
    }

    public static AttributeSupplier.Builder lichAttributes() {
        return UnderlingEntity.underlingAttributes().add(Attributes.MAX_HEALTH, 175.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.3).add(Attributes.MOVEMENT_SPEED, 0.25).add(Attributes.ATTACK_DAMAGE, 8.0).add(Attributes.ATTACK_SPEED, 2.25);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new AttackResistanceGoal());
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<LichEntity>(this, CLAW_PROPERTIES, 0.0f, -1.0f, -1, 0.0f, 45.0f));
        this.goalSelector.addGoal(3, (Goal)new MoveToTargetGoal(this, 1.0f, false));
    }

    protected SoundEvent getAmbientSound() {
        return MSSoundEvents.ENTITY_LICH_AMBIENT.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MSSoundEvents.ENTITY_LICH_HURT.get();
    }

    protected SoundEvent getDeathSound() {
        return MSSoundEvents.ENTITY_LICH_DEATH.get();
    }

    @Override
    public MutableGristSet getGristSpoils() {
        return GristHelper.generateUnderlingGristDrops(this, this.damageMap, 8.0);
    }

    @Override
    protected int getVitalityGel() {
        return this.random.nextInt(3) + 6;
    }

    @Override
    protected void onGristTypeUpdated(GristType type) {
        super.onGristTypeUpdated(type);
        this.applyGristModifier((Holder<Attribute>)Attributes.MAX_HEALTH, 30.0f * type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.applyGristModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 3.4 * (double)type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.xpReward = (int)(6.5 * (double)type.getPower() + 4.0);
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 90 && !this.level().isClientSide()) {
            this.level().broadcastEntityEvent((Entity)this, (byte)60);
            this.remove(Entity.RemovalReason.KILLED);
        }
    }

    @Override
    public void die(DamageSource cause) {
        super.die(cause);
        Entity killer = cause.getEntity();
        if (this.dead && !this.level().isClientSide) {
            this.computePlayerProgress((int)(50.0 + 2.6 * (double)this.getGristType().getPower()));
            LichEntity.firstKillBonus(killer, EcheladderBonusType.LICH);
        }
    }

    @Override
    public void initiationPhaseStart(MobAnimation.Action animation) {
        if (animation == MobAnimation.Action.CLAW) {
            this.playSound(MSSoundEvents.ENTITY_SWOOSH.get(), 0.2f, 1.75f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controller) {
        controller.add(new AnimationController((GeoAnimatable)this, "idleAnimation", LichEntity::idleAnimation));
        controller.add(new AnimationController((GeoAnimatable)this, "walkAnimation", LichEntity::walkAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 4.0));
        controller.add(new AnimationController((GeoAnimatable)this, "deathAnimation", LichEntity::deathAnimation));
        controller.add(new AnimationController((GeoAnimatable)this, "attackAnimation", LichEntity::attackAnimation));
    }

    private static PlayState idleAnimation(AnimationState<LichEntity> state) {
        if (state.isMoving() || ((LichEntity)state.getAnimatable()).getCurrentAction() != MobAnimation.Action.IDLE) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(IDLE_ANIMATION);
        return PlayState.CONTINUE;
    }

    private static PlayState walkAnimation(AnimationState<LichEntity> state) {
        MobAnimation.Action action = ((LichEntity)state.getAnimatable()).getCurrentAction();
        if (action == MobAnimation.Action.CLAW) {
            state.getController().setAnimation(CLAW_LEGS_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (!MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable())) {
            return PlayState.STOP;
        }
        state.getController().setAnimation(WALK_ANIMATION);
        return PlayState.CONTINUE;
    }

    private static PlayState deathAnimation(AnimationState<LichEntity> state) {
        if (((LichEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState attackAnimation(AnimationState<LichEntity> state) {
        if (((LichEntity)state.getAnimatable()).isActive()) {
            state.getController().setAnimation(CLAW_ARMS_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        state.getController().setAnimationSpeed(MobAnimation.getAttributeAffectedSpeed((LivingEntity)state.getAnimatable(), (Holder<Attribute>)Attributes.ATTACK_SPEED));
        return PlayState.STOP;
    }

    private class AttackResistanceGoal
    extends Goal {
        private AttackResistanceGoal() {
        }

        public boolean canUse() {
            return LichEntity.this.isBeforeContact();
        }

        public void start() {
            AttributeInstance instance = LichEntity.this.getAttributes().getInstance(Attributes.KNOCKBACK_RESISTANCE);
            if (instance != null && !instance.hasModifier(RESISTANCE_MODIFIER_ATTACKING_ID)) {
                instance.addTransientModifier(RESISTANCE_MODIFIER_ATTACKING);
            }
        }

        public void stop() {
            AttributeInstance instance = LichEntity.this.getAttributes().getInstance(Attributes.KNOCKBACK_RESISTANCE);
            if (instance != null) {
                instance.removeModifier(RESISTANCE_MODIFIER_ATTACKING_ID);
            }
        }
    }
}

