/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.ai.attack.AnimatedAttackWhenInRangeGoal;
import com.mraof.minestuck.entity.ai.attack.GroundSlamGoal;
import com.mraof.minestuck.entity.ai.attack.MoveToTargetGoal;
import com.mraof.minestuck.entity.animation.MobAnimation;
import com.mraof.minestuck.entity.animation.PhasedMobAnimation;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.util.MSSoundEvents;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.Animation;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;

@ParametersAreNonnullByDefault
public class OgreEntity
extends UnderlingEntity {
    public static final PhasedMobAnimation RIGHT_PUNCH_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.RIGHT_PUNCH, 22, true, true), 3, 5, 6, 11);
    public static final PhasedMobAnimation LEFT_PUNCH_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.LEFT_PUNCH, 22, true, true), 3, 5, 6, 11);
    public static final PhasedMobAnimation SLAM_PROPERTIES = new PhasedMobAnimation(new MobAnimation(MobAnimation.Action.SLAM, 30, true, true), 6, 7, 9, 15);
    public static final RawAnimation WALK_ANIMATION = RawAnimation.begin().thenLoop("walk");
    public static final RawAnimation WALKARMS_ANIMATION = RawAnimation.begin().thenLoop("walkarms");
    public static final RawAnimation RIGHT_PUNCH_ANIMATION = RawAnimation.begin().then("right_punch", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation LEFT_PUNCH_ANIMATION = RawAnimation.begin().then("left_punch", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation SMASH_ANIMATION = RawAnimation.begin().then("smash", Animation.LoopType.PLAY_ONCE);
    public static final RawAnimation DIE_ANIMATION = RawAnimation.begin().then("die", Animation.LoopType.PLAY_ONCE);

    public OgreEntity(EntityType<? extends OgreEntity> type, Level level) {
        super(type, level, 3);
    }

    public static AttributeSupplier.Builder ogreAttributes() {
        return UnderlingEntity.underlingAttributes().add(Attributes.MAX_HEALTH, 50.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.4).add(Attributes.MOVEMENT_SPEED, 0.22).add(Attributes.ATTACK_DAMAGE, 6.0).add(Attributes.ATTACK_KNOCKBACK, 12.0).add(Attributes.ATTACK_SPEED, 0.5).add(Attributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<OgreEntity>(this, RIGHT_PUNCH_PROPERTIES, 0.0f, -1.0f, 40, 35.0f, 55.0f));
        this.goalSelector.addGoal(2, new AnimatedAttackWhenInRangeGoal<OgreEntity>(this, LEFT_PUNCH_PROPERTIES, 0.0f, -1.0f, 40, -35.0f, 55.0f));
        this.goalSelector.addGoal(3, new GroundSlamGoal<OgreEntity>(this, SLAM_PROPERTIES, -1.0f, 15.0f, 160));
        this.goalSelector.addGoal(3, (Goal)new MoveToTargetGoal(this, 1.0f, false));
    }

    protected SoundEvent getAmbientSound() {
        return MSSoundEvents.ENTITY_OGRE_AMBIENT.get();
    }

    protected SoundEvent getDeathSound() {
        return MSSoundEvents.ENTITY_OGRE_DEATH.get();
    }

    protected SoundEvent getHurtSound(DamageSource damageSourceIn) {
        return MSSoundEvents.ENTITY_OGRE_HURT.get();
    }

    @Override
    public MutableGristSet getGristSpoils() {
        return GristHelper.generateUnderlingGristDrops(this, this.damageMap, 4.0);
    }

    @Override
    protected int getVitalityGel() {
        return this.random.nextInt(3) + 3;
    }

    @Override
    protected void onGristTypeUpdated(GristType type) {
        super.onGristTypeUpdated(type);
        this.applyGristModifier((Holder<Attribute>)Attributes.MAX_HEALTH, 13.0f * type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.applyGristModifier((Holder<Attribute>)Attributes.ATTACK_DAMAGE, 2.1 * (double)type.getPower(), AttributeModifier.Operation.ADD_VALUE);
        this.xpReward = (int)(5.0f * type.getPower() + 4.0f);
    }

    @Override
    public void die(DamageSource cause) {
        super.die(cause);
        Entity entity = cause.getEntity();
        if (this.dead && !this.level().isClientSide) {
            this.computePlayerProgress((int)(15.0 + 2.2 * (double)this.getGristType().getPower()));
            OgreEntity.firstKillBonus(entity, EcheladderBonusType.OGRE);
        }
    }

    @Override
    public void initiationPhaseStart(MobAnimation.Action animation) {
        if (animation == MobAnimation.Action.RIGHT_PUNCH || animation == MobAnimation.Action.LEFT_PUNCH || animation == MobAnimation.Action.SLAM) {
            this.playSound(MSSoundEvents.ENTITY_SWOOSH.get(), 0.5f, 0.0f);
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController((GeoAnimatable)this, "walkArmsAnimation", OgreEntity::walkArmsAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 2.27));
        controllers.add(new AnimationController((GeoAnimatable)this, "walkAnimation", OgreEntity::walkAnimation).setAnimationSpeedHandler(entity -> MobAnimation.getAttributeAffectedSpeed((LivingEntity)entity, (Holder<Attribute>)Attributes.MOVEMENT_SPEED) * 2.27));
        controllers.add(new AnimationController((GeoAnimatable)this, "attackAnimation", OgreEntity::attackAnimation));
        controllers.add(new AnimationController((GeoAnimatable)this, "deathAnimation", OgreEntity::deathAnimation).setAnimationSpeed(0.85));
    }

    private static PlayState walkAnimation(AnimationState<OgreEntity> state) {
        if (MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable())) {
            state.getController().setAnimation(WALK_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState walkArmsAnimation(AnimationState<OgreEntity> state) {
        if (MobAnimation.isEntityMovingHorizontally((Entity)state.getAnimatable()) && !((OgreEntity)state.getAnimatable()).isActive()) {
            state.getController().setAnimation(WALKARMS_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    private static PlayState attackAnimation(AnimationState<OgreEntity> state) {
        MobAnimation.Action action = ((OgreEntity)state.getAnimatable()).getCurrentAction();
        if (action == MobAnimation.Action.RIGHT_PUNCH) {
            state.getController().setAnimation(RIGHT_PUNCH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (action == MobAnimation.Action.LEFT_PUNCH) {
            state.getController().setAnimation(LEFT_PUNCH_ANIMATION);
            return PlayState.CONTINUE;
        }
        if (action == MobAnimation.Action.SLAM) {
            state.getController().setAnimation(SMASH_ANIMATION);
            return PlayState.CONTINUE;
        }
        state.getController().forceAnimationReset();
        state.getController().setAnimationSpeed(MobAnimation.getAttributeAffectedSpeed((LivingEntity)state.getAnimatable(), (Holder<Attribute>)Attributes.ATTACK_SPEED));
        return PlayState.STOP;
    }

    private static PlayState deathAnimation(AnimationState<OgreEntity> state) {
        if (((OgreEntity)state.getAnimatable()).dead) {
            state.getController().setAnimation(DIE_ANIMATION);
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }
}

