/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.api.alchemy.MutableGristSet;
import com.mraof.minestuck.entity.AttackingAnimatedEntity;
import com.mraof.minestuck.entity.EntityListFilter;
import com.mraof.minestuck.entity.ai.HurtByTargetAlliedGoal;
import com.mraof.minestuck.entity.consort.ConsortReputation;
import com.mraof.minestuck.entity.item.GristEntity;
import com.mraof.minestuck.entity.item.VitalityGelEntity;
import com.mraof.minestuck.entity.underling.UnderlingSpawnSettings;
import com.mraof.minestuck.player.Echeladder;
import com.mraof.minestuck.player.EcheladderBonusType;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.util.MSTags;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.util.GeckoLibUtil;

@ParametersAreNonnullByDefault
public abstract class UnderlingEntity
extends AttackingAnimatedEntity
implements Enemy,
GeoEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final ResourceLocation GRIST_MODIFIER_ID = Minestuck.id("grist_type");
    private static final EntityDataAccessor<String> GRIST_TYPE = SynchedEntityData.defineId(UnderlingEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    protected final EntityListFilter attackEntitySelector = new EntityListFilter(new ArrayList());
    protected boolean fromSpawner;
    public boolean dropCandy;
    private int consortRep;
    private static final float MAX_SHARED_PROGRESS = 2.0f;
    protected Map<PlayerIdentifier, Double> damageMap = new HashMap<PlayerIdentifier, Double>();

    public UnderlingEntity(EntityType<? extends UnderlingEntity> type, Level level, int consortRep) {
        super((EntityType<? extends AttackingAnimatedEntity>)type, level);
        this.consortRep = consortRep;
        this.attackEntitySelector.entityList.add(EntityType.PLAYER);
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(1, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.8));
        this.goalSelector.addGoal(5, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.goalSelector.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetAlliedGoal((Mob)this, entity -> entity.getType().is(MSTags.EntityTypes.UNDERLINGS)));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 2, true, false, this::isAppropriateTarget));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    protected boolean isAppropriateTarget(LivingEntity entity) {
        return this.attackEntitySelector.isEntityApplicable((Entity)entity);
    }

    public static AttributeSupplier.Builder underlingAttributes() {
        return Mob.createMobAttributes().add(Attributes.ATTACK_DAMAGE).add(Attributes.FOLLOW_RANGE, 32.0);
    }

    public SoundSource getSoundSource() {
        return SoundSource.HOSTILE;
    }

    public float getVoicePitch() {
        return this.getGristType() == GristTypes.ARTIFACT.get() ? (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 0.7f : (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(GRIST_TYPE, (Object)String.valueOf(GristTypes.REGISTRY.getKey((Object)GristTypes.ARTIFACT.get())));
    }

    protected void applyGristType(GristType type) {
        if (!type.isUnderlingType()) {
            throw new IllegalArgumentException("Can't set underling grist type to " + String.valueOf(type));
        }
        this.entityData.set(GRIST_TYPE, (Object)String.valueOf(type.getIdOrThrow()));
        this.onGristTypeUpdated(type);
        this.setHealth(this.getMaxHealth());
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> parameter) {
        if (parameter == GRIST_TYPE) {
            this.onGristTypeUpdated(this.getGristType());
        }
    }

    protected void onGristTypeUpdated(GristType type) {
    }

    protected void applyGristModifier(Holder<Attribute> attribute, double modifier, AttributeModifier.Operation operation) {
        this.getAttribute(attribute).removeModifier(GRIST_MODIFIER_ID);
        this.getAttribute(attribute).addTransientModifier(new AttributeModifier(GRIST_MODIFIER_ID, modifier, operation));
    }

    @Nonnull
    public GristType getGristType() {
        GristType type = (GristType)GristTypes.REGISTRY.get(ResourceLocation.tryParse((String)((String)this.entityData.get(GRIST_TYPE))));
        if (type != null) {
            return type;
        }
        LOGGER.warn("Unable to read underling grist type from string {}.", this.entityData.get(GRIST_TYPE));
        return GristTypes.ARTIFACT.get();
    }

    public abstract MutableGristSet getGristSpoils();

    protected abstract int getVitalityGel();

    public boolean doHurtTarget(Entity entityIn) {
        return entityIn.hurt(this.damageSources().mobAttack((LivingEntity)this), (float)this.getAttribute(Attributes.ATTACK_DAMAGE).getValue());
    }

    public void remove(Entity.RemovalReason reason) {
        super.remove(reason);
        if (reason == Entity.RemovalReason.KILLED) {
            MutableGristSet grist = this.getGristSpoils();
            if (grist == null) {
                return;
            }
            if (this.fromSpawner) {
                grist.scale(0.5f, false);
            }
            if (!this.dropCandy) {
                for (GristAmount gristAmount : grist.asAmounts()) {
                    if (gristAmount.amount() <= 0L) continue;
                    this.level().addFreshEntity((Entity)new GristEntity(this.level(), this.randX(), this.getY(), this.randZ(), gristAmount));
                }
            } else {
                for (GristAmount amount : grist.asAmounts()) {
                    ItemStack candyItem = amount.type().getCandyItem();
                    if (candyItem.isEmpty()) {
                        if (amount.amount() <= 0L) continue;
                        this.level().addFreshEntity((Entity)new GristEntity(this.level(), this.randX(), this.getY(), this.randZ(), amount));
                        continue;
                    }
                    int candy = (int)Math.min(64L, (amount.amount() + 2L) / 4L);
                    long gristAmount = amount.amount() - (long)(candy * 2);
                    candyItem.setCount(candy);
                    if (candy > 0) {
                        this.level().addFreshEntity((Entity)new ItemEntity(this.level(), this.randX(), this.getY(), this.randZ(), candyItem));
                    }
                    if (gristAmount <= 0L) continue;
                    this.level().addFreshEntity((Entity)new GristEntity(this.level(), this.randX(), this.getY(), this.randZ(), amount.type().amount(gristAmount)));
                }
            }
            if (this.random.nextInt(3) == 0) {
                this.level().addFreshEntity((Entity)new VitalityGelEntity(this.level(), this.randX(), this.getY(), this.randZ(), this.getVitalityGel()));
            }
        }
    }

    public void die(DamageSource cause) {
        ServerPlayer player;
        LivingEntity entity = this.getKillCredit();
        if (entity instanceof ServerPlayer && !((player = (ServerPlayer)entity) instanceof FakePlayer)) {
            ConsortReputation.get(player).addConsortReputation(this.consortRep, (ResourceKey<Level>)this.level().dimension());
        }
        super.die(cause);
    }

    private double randX() {
        return this.getX() + this.random.nextDouble() * (double)this.getBbWidth() - (double)(this.getBbWidth() / 2.0f);
    }

    private double randZ() {
        return this.getZ() + this.random.nextDouble() * (double)this.getBbWidth() - (double)(this.getBbWidth() / 2.0f);
    }

    public Component getName() {
        if (this.getCustomName() == null) {
            return Component.translatable((String)(this.getType().getDescriptionId() + ".type"), (Object[])new Object[]{this.getGristType().getDisplayName()});
        }
        return super.getName();
    }

    public void setTarget(LivingEntity entity) {
        super.setTarget(entity);
        if (entity != null) {
            this.addEnemy(entity.getType());
        }
    }

    public void addEnemy(EntityType<?> enemyType) {
        if (!this.attackEntitySelector.entityList.contains(enemyType) && !enemyType.is(MSTags.EntityTypes.UNDERLINGS)) {
            this.attackEntitySelector.entityList.add(enemyType);
        }
    }

    @Override
    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        GristType gristType = this.getGristType();
        compound.put("Type", GristHelper.encodeGristType(gristType));
        compound.putBoolean("Spawned", this.fromSpawner);
        if (this.hasRestriction()) {
            CompoundTag nbt = new CompoundTag();
            BlockPos home = this.getRestrictCenter();
            nbt.putInt("HomeX", home.getX());
            nbt.putInt("HomeY", home.getY());
            nbt.putInt("HomeZ", home.getZ());
            nbt.putInt("MaxHomeDistance", (int)this.getRestrictRadius());
            compound.put("HomePos", (Tag)nbt);
        }
    }

    @Override
    public void readAdditionalSaveData(CompoundTag compound) {
        if (compound.contains("Type", 8)) {
            this.applyGristType(GristHelper.parseGristType(compound.get("Type")).orElseGet(GristTypes.ARTIFACT));
        } else {
            this.applyGristType(GristHelper.getPrimaryGrist(this.getRandom()));
        }
        super.readAdditionalSaveData(compound);
        this.fromSpawner = compound.getBoolean("Spawned");
        if (compound.contains("HomePos", 10)) {
            CompoundTag nbt = compound.getCompound("HomePos");
            BlockPos pos = new BlockPos(nbt.getInt("HomeX"), nbt.getInt("HomeY"), nbt.getInt("HomeZ"));
            this.restrictTo(pos, nbt.getInt("MaxHomeDistance"));
        }
    }

    public static boolean canSpawnOnAndNotPeaceful(EntityType<? extends Mob> type, LevelAccessor worldIn, MobSpawnType reason, BlockPos pos, RandomSource randomIn) {
        return worldIn.getDifficulty() != Difficulty.PEACEFUL && UnderlingEntity.checkMobSpawnRules(type, (LevelAccessor)worldIn, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)randomIn);
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn) {
        if (!(spawnDataIn instanceof UnderlingData)) {
            this.applyGristType(UnderlingSpawnSettings.getUnderlingType(this));
            spawnDataIn = new UnderlingData(this.getGristType());
        } else {
            this.applyGristType(((UnderlingData)spawnDataIn).type);
        }
        return super.finalizeSpawn(worldIn, difficultyIn, reason, spawnDataIn);
    }

    public void onEntityDamaged(DamageSource source, float amount) {
        PlayerIdentifier playerId = null;
        Entity entity = source.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            playerId = IdentifierHandler.encode((Player)player);
        }
        if (this.damageMap.containsKey(playerId)) {
            this.damageMap.put(playerId, this.damageMap.get(playerId) + (double)amount);
        } else {
            this.damageMap.put(playerId, Double.valueOf(amount));
        }
    }

    public void baseTick() {
        super.baseTick();
        if (this.getHealth() > 0.0f) {
            this.dropCandy = false;
        }
    }

    protected void computePlayerProgress(int progress) {
        int i;
        double totalDamage = 0.0;
        for (Double i2 : this.damageMap.values()) {
            totalDamage += i2.doubleValue();
        }
        if (totalDamage < (double)this.getMaxHealth()) {
            totalDamage = this.getMaxHealth();
        }
        int maxProgress = (int)((float)progress * 2.0f);
        this.damageMap.remove(null);
        PlayerIdentifier[] playerList = this.damageMap.keySet().toArray(new PlayerIdentifier[0]);
        double[] modifiers = new double[playerList.length];
        double totalModifier = 0.0;
        for (i = 0; i < playerList.length; ++i) {
            double f = this.damageMap.get(playerList[i]) / totalDamage;
            modifiers[i] = 2.0 * f - f * f;
            totalModifier += modifiers[i];
        }
        if (playerList.length > 0) {
            LOGGER.debug("{} players are splitting on {} progress from {}", (Object)playerList.length, (Object)progress, (Object)this.getType());
        }
        if (totalModifier > 2.0) {
            for (i = 0; i < playerList.length; ++i) {
                Echeladder.get(playerList[i], this.level()).increaseProgress((int)((double)maxProgress * modifiers[i] / totalModifier));
            }
        } else {
            for (i = 0; i < playerList.length; ++i) {
                Echeladder.get(playerList[i], this.level()).increaseProgress((int)((double)progress * modifiers[i]));
            }
        }
    }

    protected static void firstKillBonus(Entity killer, EcheladderBonusType type) {
        if (killer instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)killer;
            if (!(killer instanceof FakePlayer)) {
                Echeladder ladder = Echeladder.get(player);
                ladder.checkBonus(type);
            }
        }
    }

    protected static class UnderlingData
    implements SpawnGroupData {
        public final GristType type;

        public UnderlingData(GristType type) {
            this.type = type;
        }
    }
}

