/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entity.underling;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.alchemy.GristHelper;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.event.UnderlingSpawnListEvent;
import com.mraof.minestuck.world.lands.GristLayerInfo;
import java.util.ArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public final class UnderlingSpawnSettings {
    private static final WeightedRandomList<MobSpawnSettings.SpawnerData>[] difficultyList = new WeightedRandomList[31];

    public static GristType getUnderlingType(UnderlingEntity entity) {
        return GristLayerInfo.get((ServerLevel)entity.level()).map(info -> info.randomTypeFor((LivingEntity)entity)).orElseGet(() -> GristHelper.getPrimaryGrist(entity.getRandom()));
    }

    public static WeightedRandomList<MobSpawnSettings.SpawnerData> getUnderlingList(BlockPos pos) {
        int giclopsWeight;
        int lichWeight;
        int basiliskWeight;
        int ogreWeight;
        BlockPos spawn = new BlockPos(0, 0, 0);
        int difficulty = (int)Math.round(Math.sqrt(new Vec3i(pos.getX() >> 4, 0, pos.getZ() >> 4).distSqr(new Vec3i(spawn.getX() >> 4, 0, spawn.getZ() >> 4))));
        if (difficultyList[difficulty = Math.min(30, difficulty / 3)] != null) {
            return difficultyList[difficulty];
        }
        ArrayList<MobSpawnSettings.SpawnerData> list = new ArrayList<MobSpawnSettings.SpawnerData>();
        int impWeight = difficulty < 8 ? difficulty + 1 : 8 - (difficulty - 8) / 3;
        int n = ogreWeight = difficulty < 20 ? (difficulty - 5) / 3 : 5 - (difficulty - 20) / 3;
        int n2 = difficulty >= 16 && difficulty < 26 ? (difficulty - 14) / 2 : (basiliskWeight = difficulty >= 26 ? 6 : 0);
        int n3 = difficulty >= 28 ? 6 : (lichWeight = difficulty >= 16 ? (difficulty - 12) / 3 : 0);
        int n4 = difficulty >= 20 && difficulty < 30 ? (difficulty - 17) / 3 : (giclopsWeight = difficulty >= 30 ? 4 : 0);
        if (impWeight > 0 && ((Boolean)MinestuckConfig.SERVER.naturalImpSpawn.get()).booleanValue()) {
            list.add(new MobSpawnSettings.SpawnerData(MSEntityTypes.IMP.get(), impWeight, Math.max(1, (int)((double)impWeight / 2.5)), Math.min(5, Math.max(3, impWeight))));
        }
        if (ogreWeight > 0 && ((Boolean)MinestuckConfig.SERVER.naturalOgreSpawn.get()).booleanValue()) {
            list.add(new MobSpawnSettings.SpawnerData(MSEntityTypes.OGRE.get(), ogreWeight, ogreWeight >= 5 ? 2 : 1, Math.min(5, Math.max(1, ogreWeight / 2))));
        }
        if (basiliskWeight > 0 && ((Boolean)MinestuckConfig.SERVER.naturalBasiliskSpawn.get()).booleanValue()) {
            list.add(new MobSpawnSettings.SpawnerData(MSEntityTypes.BASILISK.get(), basiliskWeight, 1, Math.min(5, Math.max(1, basiliskWeight / 2))));
        }
        if (lichWeight > 0 && ((Boolean)MinestuckConfig.SERVER.naturalLichSpawn.get()).booleanValue()) {
            list.add(new MobSpawnSettings.SpawnerData(MSEntityTypes.LICH.get(), lichWeight, 1, Math.min(5, Math.max(1, lichWeight / 2))));
        }
        if (giclopsWeight > 0 && !((Boolean)MinestuckConfig.SERVER.disableGiclops.get()).booleanValue()) {
            list.add(new MobSpawnSettings.SpawnerData(MSEntityTypes.GICLOPS.get(), giclopsWeight, 1, Math.min(5, Math.max(1, giclopsWeight / 2))));
        }
        NeoForge.EVENT_BUS.post((Event)new UnderlingSpawnListEvent(difficulty, list));
        UnderlingSpawnSettings.difficultyList[difficulty] = WeightedRandomList.create(list);
        return UnderlingSpawnSettings.difficultyList[difficulty];
    }
}

