/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entry;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class BlockCopier {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Set<CopyStep> copySteps = new HashSet<CopyStep>();

    public static void addStep(CopyStep processing) {
        copySteps.add(processing);
    }

    static void copyBlock(LevelChunk sourceChunk, BlockPos source, BlockState block, LevelChunk targetChunk, BlockPos targetPos) {
        targetChunk.setBlockState(targetPos, block, true);
        BlockEntity blockEntity = sourceChunk.getBlockEntity(source, LevelChunk.EntityCreationType.CHECK);
        BlockEntity newBE = null;
        if (blockEntity != null) {
            newBE = BlockCopier.cloneBEToPos(block, targetChunk, targetPos, blockEntity);
        }
        for (CopyStep processing : copySteps) {
            processing.copyOver((ServerLevel)sourceChunk.getLevel(), source, (ServerLevel)targetChunk.getLevel(), targetPos, block, blockEntity, newBE);
        }
    }

    @Nullable
    private static BlockEntity cloneBEToPos(BlockState block, LevelChunk targetChunk, BlockPos targetPos, BlockEntity blockEntity) {
        RegistryAccess provider = Objects.requireNonNull(blockEntity.getLevel()).registryAccess();
        CompoundTag nbt = blockEntity.saveWithId((HolderLookup.Provider)provider);
        nbt.putInt("x", targetPos.getX());
        nbt.putInt("y", targetPos.getY());
        nbt.putInt("z", targetPos.getZ());
        BlockEntity newBE = BlockEntity.loadStatic((BlockPos)targetPos, (BlockState)block, (CompoundTag)nbt, (HolderLookup.Provider)provider);
        if (newBE != null) {
            targetChunk.addAndRegisterBlockEntity(newBE);
        } else {
            LOGGER.warn("Unable to create a new block entity {} when teleporting blocks to the medium!", (Object)BuiltInRegistries.BLOCK_ENTITY_TYPE.getKey((Object)blockEntity.getType()));
        }
        return newBE;
    }

    public static interface CopyStep {
        public void copyOver(ServerLevel var1, BlockPos var2, ServerLevel var3, BlockPos var4, BlockState var5, @Nullable BlockEntity var6, @Nullable BlockEntity var7);
    }
}

