/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entry;

import com.google.common.collect.AbstractIterator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;

public final class EntryBlockIterator {
    public static Iterable<BlockPos.MutableBlockPos> get(final int centerX, final int centerY, final int centerZ, final int range) {
        return () -> new AbstractIterator<BlockPos.MutableBlockPos>(){
            private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            private int xOffset;
            private int zOffset;
            private int yOffset;
            {
                this.updateXOffset(-range);
            }

            @Nullable
            protected BlockPos.MutableBlockPos computeNext() {
                if (this.xOffset > range) {
                    return (BlockPos.MutableBlockPos)this.endOfData();
                }
                this.pos.set(centerX + this.xOffset, centerY + this.yOffset, centerZ + this.zOffset);
                this.updateOffsets();
                return this.pos;
            }

            private void updateOffsets() {
                if (this.yOffset <= EntryBlockIterator.yReachAtXZ(range, this.xOffset, this.zOffset)) {
                    ++this.yOffset;
                } else if (this.zOffset <= EntryBlockIterator.zReachAtX(range, this.xOffset)) {
                    this.updateZOffset(this.zOffset + 1);
                } else {
                    this.updateXOffset(this.xOffset + 1);
                }
            }

            private void updateXOffset(int x) {
                this.xOffset = x;
                if (this.xOffset <= range) {
                    this.updateZOffset(-EntryBlockIterator.zReachAtX(range, this.xOffset));
                }
            }

            private void updateZOffset(int z) {
                this.zOffset = z;
                this.yOffset = -EntryBlockIterator.yReachAtXZ(range, this.xOffset, this.zOffset);
            }
        };
    }

    public static Iterable<BlockPos.MutableBlockPos> getHorizontal(final int centerX, final int centerY, final int centerZ, final int range) {
        return () -> new AbstractIterator<BlockPos.MutableBlockPos>(){
            private final BlockPos.MutableBlockPos pos;
            private int xOffset;
            private int zOffset;
            {
                this.pos = new BlockPos.MutableBlockPos().setY(centerY);
                this.updateXOffset(-range);
            }

            @Nullable
            protected BlockPos.MutableBlockPos computeNext() {
                if (this.xOffset > range) {
                    return (BlockPos.MutableBlockPos)this.endOfData();
                }
                this.pos.setX(centerX + this.xOffset);
                this.pos.setZ(centerZ + this.zOffset);
                this.updateOffsets();
                return this.pos;
            }

            private void updateOffsets() {
                if (this.zOffset <= EntryBlockIterator.zReachAtX(range, this.xOffset)) {
                    ++this.zOffset;
                } else {
                    this.updateXOffset(this.xOffset + 1);
                }
            }

            private void updateXOffset(int x) {
                this.xOffset = x;
                if (this.xOffset <= range) {
                    this.zOffset = -EntryBlockIterator.zReachAtX(range, this.xOffset);
                }
            }
        };
    }

    private static int zReachAtX(int range, int xOffset) {
        return (int)Math.sqrt(((double)range + 0.5) * ((double)range + 0.5) - (double)(xOffset * xOffset));
    }

    private static int yReachAtXZ(int range, int xOffset, int zOffset) {
        return (int)Math.sqrt(((double)range + 0.5) * ((double)range + 0.5) - (double)((float)(xOffset * xOffset + zOffset * zOffset) / 2.0f));
    }

    public static int yReach(BlockPos pos, int range, int centerX, int centerZ) {
        return EntryBlockIterator.yReachAtXZ(range, pos.getX() - centerX, pos.getZ() - centerZ);
    }
}

