/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entry;

import com.mraof.minestuck.skaianet.ActiveConnection;
import com.mraof.minestuck.skaianet.SburbConnections;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import java.util.Objects;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Level;

public class EntryEvent {
    private static final int FREQUENCY = 8;
    private static final int RADIUS = 30;

    public static void tick(MinecraftServer server) {
        if (server.overworld().getGameTime() % 8L == 0L) {
            SburbConnections connections = SburbConnections.get(server);
            connections.activeConnections().filter(connection -> connections.hasPrimaryConnectionForClient(connection.client()) && !SburbPlayerData.get(connection.client(), server).hasEntered()).forEach(connection -> EntryEvent.handleConnection(connection, server));
        }
    }

    private static void handleConnection(ActiveConnection connection, MinecraftServer server) {
        GlobalPos pos = connection.clientComputer().getPosForEditmode();
        ServerLevel level = server.getLevel(pos.dimension());
        if (level != null && level.isLoaded(pos.pos())) {
            RandomSource rand = level.getRandom();
            double x = (double)pos.pos().getX() + 0.5 + 30.0 * EntryEvent.invertedPyramidDist(rand);
            double y = 256.0;
            double z = (double)pos.pos().getZ() + 0.5 + 30.0 * EntryEvent.invertedPyramidDist(rand);
            AbstractHurtingProjectile entity = (double)rand.nextFloat() < 0.95 ? (AbstractHurtingProjectile)EntityType.FIREBALL.create((Level)level) : (AbstractHurtingProjectile)EntityType.DRAGON_FIREBALL.create((Level)level);
            Objects.requireNonNull(entity);
            entity.moveTo(x, y, z, entity.getYRot(), entity.getXRot());
            entity.setDeltaMovement(0.0, -0.1, 0.0);
            level.addFreshEntity((Entity)entity);
        }
    }

    private static double invertedPyramidDist(RandomSource rand) {
        double value = rand.nextDouble() - rand.nextDouble();
        if (value > 0.0) {
            return 1.0 - value;
        }
        return -1.0 - value;
    }
}

