/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.entry;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.GateBlock;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.blockentity.TransportalizerBlockEntity;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.computer.SburbServerData;
import com.mraof.minestuck.computer.editmode.ServerEditHandler;
import com.mraof.minestuck.entry.BlockCopier;
import com.mraof.minestuck.entry.EntryBlockIterator;
import com.mraof.minestuck.entry.PostEntryTask;
import com.mraof.minestuck.network.EntryEffectPackets;
import com.mraof.minestuck.player.IdentifierHandler;
import com.mraof.minestuck.player.PlayerIdentifier;
import com.mraof.minestuck.skaianet.SburbHandler;
import com.mraof.minestuck.skaianet.SburbPlayerData;
import com.mraof.minestuck.skaianet.TitleSelectionHook;
import com.mraof.minestuck.util.Teleport;
import com.mraof.minestuck.world.GateHandler;
import com.mraof.minestuck.world.MSDimensions;
import com.mraof.minestuck.world.storage.MSExtraData;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CommonLevelAccessor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck")
public class EntryProcess {
    public static final String WRONG_DIMENSION = "minestuck.entry.wrong_dimension";
    public static final String BUSY = "minestuck.entry.busy";
    public static final String CREATION_FAILED = "minestuck.entry.creation_failed";
    public static final String DIMENSION_MISSING = "minestuck.entry.dimension_missing";
    public static final String NOT_ALLOWED_HERE = "minestuck.entry.not_allowed_here";
    public static final String NO_REENTRY = "minestuck.entry.no_reentry";
    public static final String WRONG_DIMENSION_REENTRY = "minestuck.entry.wrong_dimension_reentry";
    public static final String TELEPORT_FAILED = "minestuck.entry.teleport_failed";
    public static final String COMMAND_BLOCK_DENIED = "minestuck.entry.command_block_denied";
    public static final String SKAIANET_DENIED = "minestuck.entry.skaianet_denied";
    public static final String NOT_YOUR_COMPUTER = "minestuck.entry.not_your_computer";
    public static final String NEEDS_COMPUTER = "minestuck.entry.needs_computer";
    public static final String EXCEPTION = "minestuck.entry.exception";
    private static final Logger LOGGER = LogManager.getLogger();
    public static final TicketType<Unit> CHUNK_TICKET_TYPE = TicketType.create((String)"entry", (_left, _right) -> 0);
    private final PlayerIdentifier playerId;
    private final ServerLevel originLevel;
    private final ServerLevel landLevel;
    private final int artifactRange;
    private final int xDiff;
    private final int yDiff;
    private final int zDiff;
    private final BlockPos origin;
    private final boolean creative;
    private static EntryProcess waitingProcess;
    private static long startTime;

    private EntryProcess(ServerPlayer player, ServerLevel landLevel, BlockPos pos) {
        this.artifactRange = (Integer)MinestuckConfig.SERVER.artifactRange.get();
        this.origin = pos;
        this.originLevel = (ServerLevel)player.level();
        this.landLevel = landLevel;
        int topY = (Boolean)MinestuckConfig.SERVER.adaptEntryBlockHeight.get() != false ? this.getTopHeight(player.serverLevel(), this.origin.getX(), this.origin.getY(), this.origin.getZ()) : this.origin.getY() + this.artifactRange;
        this.yDiff = 119 - topY;
        this.xDiff = -this.origin.getX();
        this.zDiff = -this.origin.getZ();
        this.playerId = IdentifierHandler.encode((Player)player);
        this.creative = player.gameMode.isCreative();
    }

    public static void enter(ServerPlayer player) {
        EntryProcess.enter(player, BlockPos.containing((double)player.getX(), (double)player.getY(), (double)player.getZ()));
    }

    public static void enter(ServerPlayer player, BlockPos pos) {
        long time = System.currentTimeMillis();
        if (player.level().dimension() == Level.NETHER) {
            player.sendSystemMessage((Component)Component.translatable((String)WRONG_DIMENSION));
            return;
        }
        if (!TitleSelectionHook.performEntryCheck(player, pos)) {
            return;
        }
        if (waitingProcess != null) {
            player.sendSystemMessage((Component)Component.translatable((String)BUSY));
            return;
        }
        PlayerIdentifier identifier = IdentifierHandler.encode((Player)player);
        ResourceKey<Level> land = SburbPlayerData.get(identifier, player.server).getLandDimensionIfEntered();
        if (land != null) {
            EntryProcess.secondEntryTeleport(player, land);
            return;
        }
        ResourceKey<Level> landDimension = SburbHandler.prepareEntry(identifier, player.server);
        if (landDimension == null) {
            player.sendSystemMessage((Component)Component.translatable((String)CREATION_FAILED));
            return;
        }
        ServerLevel landLevel = Objects.requireNonNull(player.getServer()).getLevel(landDimension);
        if (landLevel == null) {
            player.sendSystemMessage((Component)Component.translatable((String)DIMENSION_MISSING));
            return;
        }
        EntryProcess process = new EntryProcess(player, landLevel, pos);
        if (!process.canModifyEntryBlocks((Player)player, player.level(), pos)) {
            player.sendSystemMessage((Component)Component.translatable((String)NOT_ALLOWED_HERE));
            return;
        }
        landLevel.getChunkSource().addRegionTicket(CHUNK_TICKET_TYPE, new ChunkPos(0, 0), 0, (Object)Unit.INSTANCE);
        waitingProcess = process;
        startTime = player.level().getGameTime() + (long)((Integer)MinestuckConfig.COMMON.entryDelay.get()).intValue();
        PacketDistributor.sendToAllPlayers((CustomPacketPayload)new EntryEffectPackets.Effect((ResourceKey<Level>)player.level().dimension(), process.origin, process.artifactRange), (CustomPacketPayload[])new CustomPacketPayload[0]);
        LOGGER.info("Entry prep done in {}ms", (Object)(System.currentTimeMillis() - time));
    }

    private static void secondEntryTeleport(ServerPlayer player, ResourceKey<Level> land) {
        if (((Boolean)MinestuckConfig.SERVER.stopSecondEntry.get()).booleanValue()) {
            player.sendSystemMessage((Component)Component.translatable((String)NO_REENTRY));
            return;
        }
        if (MSDimensions.isLandDimension(player.server, (ResourceKey<Level>)player.level().dimension())) {
            player.sendSystemMessage((Component)Component.translatable((String)WRONG_DIMENSION_REENTRY));
            return;
        }
        ServerLevel landLevel = Objects.requireNonNull(player.getServer()).getLevel(land);
        if (landLevel == null) {
            player.sendSystemMessage((Component)Component.translatable((String)DIMENSION_MISSING));
            return;
        }
        BlockPos spawn = new BlockPos(0, 0, 0);
        spawn = spawn.atY(landLevel.getChunk(spawn).getHeight(Heightmap.Types.MOTION_BLOCKING, spawn.getX(), spawn.getZ()) + 1);
        Teleport.teleportEntity((Entity)player, landLevel, (float)spawn.getX() + 0.5f, spawn.getY(), (float)spawn.getZ() + 0.5f, player.getYRot(), player.getXRot());
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Pre event) {
        if (waitingProcess != null && startTime <= event.getServer().overworld().getGameTime()) {
            EntryProcess.waitingProcess.landLevel.getChunkSource().removeRegionTicket(CHUNK_TICKET_TYPE, new ChunkPos(0, 0), 0, (Object)Unit.INSTANCE);
            waitingProcess.runEntry();
            waitingProcess = null;
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new EntryEffectPackets.Clear(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void runEntry() {
        long time = System.currentTimeMillis();
        ServerPlayer player = this.playerId.getPlayer(this.landLevel.getServer());
        if (player == null) {
            LOGGER.warn("Player left before entry was completed. Cancelling entry.");
            return;
        }
        try {
            boolean wasInsideEntryArea;
            LOGGER.info("Checking entry block conditions");
            if (this.doesBlocksStopEntry(player, this.originLevel)) {
                return;
            }
            LOGGER.info("Entry starting");
            this.copyBlocks(this.originLevel, this.landLevel);
            boolean bl = wasInsideEntryArea = player.level() == this.originLevel && player.distanceToSqr((double)this.origin.getX() + 0.5, (double)this.origin.getY() + 0.5, (double)this.origin.getZ() + 0.5) <= (double)(this.artifactRange * this.artifactRange);
            if (Teleport.teleportEntity((Entity)player, this.landLevel) == null) {
                player.sendSystemMessage((Component)Component.translatable((String)TELEPORT_FAILED));
                return;
            }
            this.finalizeEntry(player, this.originLevel, this.landLevel, wasInsideEntryArea);
            SburbHandler.onEntry(player.server, player);
            LOGGER.info("Entry finished in {}ms", (Object)(System.currentTimeMillis() - time));
        }
        catch (Exception e) {
            LOGGER.error("Exception when {} tried to enter their land.", (Object)player.getName().getString(), (Object)e);
            player.sendSystemMessage((Component)Component.translatable((String)EXCEPTION, (Object[])new Object[]{this.landLevel.getServer().isDedicatedServer() ? "Check the console for the error message." : "Notify the server owner about this."}).withStyle(ChatFormatting.RED));
        }
    }

    private boolean doesBlocksStopEntry(ServerPlayer player, ServerLevel level) {
        boolean foundComputer = false;
        for (BlockPos blockPos : EntryBlockIterator.get(this.origin.getX(), this.origin.getY(), this.origin.getZ(), this.artifactRange)) {
            if (!level.isInWorldBounds(blockPos)) continue;
            BlockState block = level.getBlockState(blockPos);
            BlockEntity be = level.getBlockEntity(blockPos);
            if (!this.creative && (block.is(Blocks.COMMAND_BLOCK) || block.is(Blocks.CHAIN_COMMAND_BLOCK) || block.is(Blocks.REPEATING_COMMAND_BLOCK))) {
                player.displayClientMessage((Component)Component.translatable((String)COMMAND_BLOCK_DENIED), false);
                return true;
            }
            if (block.is((Block)MSBlocks.SKAIANET_DENIER.get())) {
                player.displayClientMessage((Component)Component.translatable((String)SKAIANET_DENIED, (Object[])new Object[]{player.getDisplayName().getString(), blockPos.toShortString()}), false);
                return true;
            }
            if (!(be instanceof ComputerBlockEntity)) continue;
            ComputerBlockEntity computer = (ComputerBlockEntity)be;
            if (computer.getOwner() != null && !computer.getOwner().appliesTo((Player)player)) {
                player.displayClientMessage((Component)Component.translatable((String)NOT_YOUR_COMPUTER), false);
                return true;
            }
            foundComputer = true;
        }
        if (!foundComputer && ((Boolean)MinestuckConfig.SERVER.needComputer.get()).booleanValue()) {
            player.displayClientMessage((Component)Component.translatable((String)NEEDS_COMPUTER), false);
            return true;
        }
        return false;
    }

    private void copyBlocks(ServerLevel sourceLevel, ServerLevel targetLevel) {
        for (BlockPos blockPos : EntryBlockIterator.get(this.origin.getX(), this.origin.getY(), this.origin.getZ(), this.artifactRange)) {
            if (!sourceLevel.isInWorldBounds(blockPos)) continue;
            BlockPos blockPos2 = blockPos.immutable();
            BlockPos targetPos = blockPos2.offset(this.xDiff, this.yDiff, this.zDiff);
            LevelChunk sourceChunk = sourceLevel.getChunkAt(blockPos2);
            BlockState block = sourceChunk.getBlockState(blockPos2);
            if (block.is(Blocks.BEDROCK) || block.is(Blocks.NETHER_PORTAL)) {
                block = Blocks.AIR.defaultBlockState();
            }
            BlockCopier.copyBlock(sourceChunk, blockPos2, block, targetLevel.getChunkAt(targetPos), targetPos);
        }
    }

    private void finalizeEntry(ServerPlayer player, ServerLevel level0, ServerLevel level1, boolean wasInsideEntryArea) {
        AABB entityTeleportBB = player.getBoundingBox().inflate((double)this.artifactRange + 0.5);
        List entities = level0.getEntities((Entity)player, entityTeleportBB);
        this.moveOrCopyEntities(entities, level1);
        this.removeOriginalBlocks(level0);
        if (wasInsideEntryArea) {
            player.teleportTo(player.getX() + (double)this.xDiff, player.getY() + (double)this.yDiff, player.getZ() + (double)this.zDiff);
        } else {
            player.teleportTo((double)(this.origin.getX() + this.xDiff) + 0.5, (double)(this.origin.getY() + this.yDiff), (double)(this.origin.getZ() + this.zDiff) + 0.5);
        }
        if (!this.creative || ((Boolean)MinestuckConfig.SERVER.entryCrater.get()).booleanValue()) {
            EntryProcess.removeDroppedEntities(player, level0, entityTeleportBB, entities);
        }
        EntryProcess.placeGates(level1);
        MSExtraData.get((Level)level1).addPostEntryTask(new PostEntryTask((ResourceKey<Level>)level1.dimension(), this.origin.getX() + this.xDiff, this.origin.getY() + this.yDiff, this.origin.getZ() + this.zDiff, this.artifactRange));
    }

    private static void removeDroppedEntities(ServerPlayer player, ServerLevel level0, AABB entityTeleportBB, List<Entity> entities) {
        List removalList = level0.getEntities((Entity)player, entityTeleportBB);
        removalList.removeAll(entities);
        Iterator iterator = removalList.iterator();
        if (((Boolean)MinestuckConfig.SERVER.entryCrater.get()).booleanValue()) {
            while (iterator.hasNext()) {
                ((Entity)iterator.next()).remove(Entity.RemovalReason.CHANGED_DIMENSION);
            }
        } else {
            while (iterator.hasNext()) {
                Entity e = (Entity)iterator.next();
                if (!(e instanceof ItemEntity)) continue;
                e.remove(Entity.RemovalReason.CHANGED_DIMENSION);
            }
        }
    }

    private void removeOriginalBlocks(ServerLevel level0) {
        for (BlockPos blockPos : EntryBlockIterator.get(this.origin.getX(), this.origin.getY(), this.origin.getZ(), this.artifactRange)) {
            if (!level0.isInWorldBounds(blockPos)) continue;
            EntryProcess.removeBlockEntity(level0, blockPos, this.creative);
            if (!((Boolean)MinestuckConfig.SERVER.entryCrater.get()).booleanValue() || level0.getBlockState(blockPos).is(Blocks.BEDROCK)) continue;
            level0.setBlock(blockPos, Blocks.AIR.defaultBlockState(), 2);
        }
    }

    private void moveOrCopyEntities(List<Entity> entities, ServerLevel level1) {
        Iterator<Entity> iterator = entities.iterator();
        while (iterator.hasNext()) {
            Entity entity = iterator.next();
            if (!(this.origin.distToCenterSqr(entity.getX(), entity.getY(), entity.getZ()) <= (double)(this.artifactRange * this.artifactRange))) continue;
            if (((Boolean)MinestuckConfig.SERVER.entryCrater.get()).booleanValue() || entity instanceof Player || !this.creative && entity instanceof ItemEntity) {
                try {
                    if (entity instanceof Player && ServerEditHandler.getData((Player)entity) != null) {
                        ServerEditHandler.reset(ServerEditHandler.getData((Player)entity));
                    } else {
                        Teleport.teleportEntity(entity, level1, entity.getX() + (double)this.xDiff, entity.getY() + (double)this.yDiff, entity.getZ() + (double)this.zDiff);
                    }
                    iterator.remove();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Exception while teleporting entity during entry {}:", (Object)entity, (Object)e);
                }
                continue;
            }
            Entity newEntity = entity.getType().create((Level)level1);
            if (newEntity == null) continue;
            newEntity.restoreFrom(entity);
            newEntity.setPos(newEntity.getX() + (double)this.xDiff, newEntity.getY() + (double)this.yDiff, newEntity.getZ() + (double)this.zDiff);
            level1.addFreshEntity(newEntity);
        }
    }

    private static void removeBlockEntity(ServerLevel level, BlockPos pos, boolean creative) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity != null) {
            if (((Boolean)MinestuckConfig.SERVER.entryCrater.get()).booleanValue() || !creative) {
                Block block = level.getBlockState(pos).getBlock();
                try {
                    level.removeBlockEntity(pos);
                    level.removeBlock(pos, true);
                }
                catch (Exception e) {
                    LOGGER.warn("Exception encountered when removing block entity {} during entry:", (Object)block, (Object)e);
                }
            } else if (blockEntity instanceof ComputerBlockEntity) {
                ComputerBlockEntity computer = (ComputerBlockEntity)blockEntity;
                computer.getSburbClientData().ifPresent(SburbClientData::handleBeingDuplicated);
                computer.getSburbServerData().ifPresent(SburbServerData::handleBeingDuplicated);
            } else if (blockEntity instanceof TransportalizerBlockEntity) {
                level.removeBlockEntity(pos);
            }
        }
    }

    private boolean canModifyEntryBlocks(Player player, Level level, BlockPos pos) {
        for (BlockPos blockPos : EntryBlockIterator.getHorizontal(pos.getX(), pos.getY(), pos.getZ(), this.artifactRange)) {
            if (level.mayInteract(player, blockPos)) continue;
            return false;
        }
        return true;
    }

    private int getTopHeight(ServerLevel level, int x, int y, int z) {
        LOGGER.debug("Getting maxY..");
        int maxY = y;
        block0: for (BlockPos.MutableBlockPos pos : EntryBlockIterator.getHorizontal(x, y, z, this.artifactRange)) {
            int height = EntryBlockIterator.yReach((BlockPos)pos, this.artifactRange, x, z);
            for (int blockY = Math.min(level.getMaxBuildHeight(), y + height); blockY > maxY; --blockY) {
                if (level.isEmptyBlock((BlockPos)pos.setY(blockY))) continue;
                maxY = blockY;
                continue block0;
            }
        }
        LOGGER.debug("maxY: {}", (Object)maxY);
        return maxY;
    }

    public static void placeGates(ServerLevel level) {
        GateBlock.placeGate((CommonLevelAccessor)level, new BlockPos(0, 124, 0), GateHandler.Type.GATE_1, 0);
        GateBlock.placeGate((CommonLevelAccessor)level, new BlockPos(0, 154, 0), GateHandler.Type.GATE_2, 0);
    }
}

